/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.mixin.gui;

import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.avatar.AvatarManager;
import fabric.org.figuramc.figura.avatar.Badges;
import fabric.org.figuramc.figura.config.Configs;
import fabric.org.figuramc.figura.lua.api.nameplate.NameplateCustomization;
import fabric.org.figuramc.figura.permissions.Permissions;
import fabric.org.figuramc.figura.utils.TextUtils;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_355;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_355.class})
public class PlayerTabOverlayMixin {
    @Unique
    private UUID uuid;

    @Inject(at={@At(value="RETURN")}, method={"getNameForDisplay"}, cancellable=true)
    private void getPlayerName(class_640 playerInfo, CallbackInfoReturnable<class_2561> cir) {
        int config = (Integer)Configs.LIST_NAMEPLATE.value;
        if (config == 0 || AvatarManager.panic) {
            return;
        }
        class_2561 text = (class_2561)cir.getReturnValue();
        class_5250 name = class_2561.method_43470((String)playerInfo.method_2966().getName());
        UUID uuid = playerInfo.method_2966().getId();
        Avatar avatar = AvatarManager.getAvatarForPlayer(uuid);
        NameplateCustomization custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.LIST;
        class_5250 replacement = custom != null && custom.getJson() != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1 ? TextUtils.replaceInText((class_5348)custom.getJson().method_27661(), "\n|\\\\n", " ") : name;
        replacement = TextUtils.replaceInText((class_5348)replacement, "\\$\\{name\\}", name);
        replacement = Badges.appendBadges((class_2561)replacement, uuid, config > 1);
        replacement = TextUtils.trim((class_5348)replacement);
        text = TextUtils.replaceInText((class_5348)text, "\\b" + Pattern.quote(playerInfo.method_2966().getName()) + "\\b", replacement);
        cir.setReturnValue((Object)text);
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getPlayerByUUID(Ljava/util/UUID;)Lnet/minecraft/world/entity/player/Player;"), method={"render"})
    private UUID getPlayerByUUID(UUID id) {
        this.uuid = id;
        return id;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/PlayerFaceRenderer;draw(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/resources/ResourceLocation;IIIZZ)V"), index=4)
    private int doNotDrawFace(class_332 guiGraphics, class_2960 id, int x, int y, int size, boolean hasHatLayer, boolean upsideDown) {
        Avatar avatar;
        if (this.uuid != null && (avatar = AvatarManager.getAvatarForPlayer(this.uuid)) != null && avatar.renderPortrait(guiGraphics, x, y, size, 16.0f, upsideDown)) {
            return 0;
        }
        return size;
    }
}

