/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.lua.docs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.lua.docs.FiguraDocsManager;
import fabric.org.figuramc.figura.lua.docs.LuaFieldDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodOverload;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import fabric.org.figuramc.figura.utils.ColorUtils;
import fabric.org.figuramc.figura.utils.FiguraClientCommandSource;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.TextUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public abstract class FiguraDoc {
    public static final class_5250 HEADER = class_2561.method_43473().method_27696(ColorUtils.Colors.AWESOME_BLUE.style).method_10852((class_2561)class_2561.method_43470((String)"\n\u2022*+\u2022* ").method_10852((class_2561)FiguraText.of()).method_27693(" Docs *\u2022+*\u2022").method_27692(class_124.field_1073));
    public final String name;
    public final String description;

    public FiguraDoc(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public abstract int print();

    public LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder command = LiteralArgumentBuilder.literal((String)this.name);
        command.executes(context -> this.print());
        return command;
    }

    public JsonObject toJson(boolean translate) {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.addProperty("description", (String)(translate ? class_2477.method_10517().method_48307(FiguraText.of("docs." + this.description).getString()) : "figura.docs." + this.description));
        return json;
    }

    public static int printRoot() {
        FiguraMod.sendChatMessage((class_2561)HEADER.method_27661().method_27693("\n\n").method_10852((class_2561)FiguraText.of("docs").method_27696(ColorUtils.Colors.BLUE.style)));
        return 1;
    }

    public static class FieldDoc
    extends FiguraDoc {
        public final Class<?> type;
        public final boolean editable;
        public final List<FiguraDoc> children;

        public FieldDoc(Field field, LuaFieldDoc luaFieldDoc, List<FiguraDoc> children) {
            super(field.getName(), luaFieldDoc.value());
            this.type = field.getType();
            this.editable = !Modifier.isFinal(field.getModifiers());
            this.children = children;
        }

        @Override
        public int print() {
            class_5250 message = HEADER.method_27661().method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.text.field")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style)).method_27693("\n\t").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_27696(ColorUtils.Colors.BLUE.style)).method_10852((class_2561)FiguraDocsManager.getClassText(this.type).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)(" " + this.name)).method_27696(ColorUtils.Colors.BLUE.style)).method_10852((class_2561)class_2561.method_43470((String)" (").method_10852((class_2561)FiguraText.of(this.editable ? "docs.text.editable" : "docs.text.not_editable")).method_27693(")").method_27692(this.editable ? class_124.field_1060 : class_124.field_1079));
            message.method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.text.description")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style));
            class_5250 descText = class_2561.method_43473().method_27696(ColorUtils.Colors.BLUE.style);
            for (class_2561 component : TextUtils.splitText((class_5348)FiguraText.of("docs." + this.description), "\n")) {
                descText.method_27693("\n\t").method_27693("\u2022 ").method_10852(component);
            }
            message.method_10852((class_2561)descText);
            FiguraMod.sendChatMessage((class_2561)message);
            return 1;
        }

        @Override
        public LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
            LiteralArgumentBuilder<FiguraClientCommandSource> command = super.getCommand();
            if (this.children != null) {
                for (FiguraDoc child : this.children) {
                    command.then(child.getCommand());
                }
            }
            return command;
        }

        @Override
        public JsonObject toJson(boolean translate) {
            JsonObject json = super.toJson(translate);
            json.addProperty("type", FiguraDocsManager.getNameFor(this.type));
            json.addProperty("editable", Boolean.valueOf(this.editable));
            JsonArray children = new JsonArray();
            if (this.children != null) {
                for (FiguraDoc child : this.children) {
                    children.add((JsonElement)child.toJson(translate));
                }
            }
            json.add("children", (JsonElement)children);
            return json;
        }
    }

    public static class MethodDoc
    extends FiguraDoc {
        public final Class<?>[][] parameterTypes;
        public final String[][] parameterNames;
        public final Class<?>[] returnTypes;
        public final String typeName;
        public final String[] aliases;
        public final boolean isStatic;
        public final List<FiguraDoc> children;

        public MethodDoc(Method method, LuaMethodDoc methodDoc, List<FiguraDoc> children, String typeName) {
            super(method.getName(), methodDoc.value());
            LuaMethodOverload[] overloads = methodDoc.overloads();
            this.parameterTypes = new Class[overloads.length][];
            this.parameterNames = new String[overloads.length][];
            this.returnTypes = new Class[overloads.length];
            this.isStatic = Modifier.isStatic(method.getModifiers());
            this.aliases = methodDoc.aliases();
            this.typeName = typeName;
            this.children = children;
            for (int i = 0; i < overloads.length; ++i) {
                this.parameterTypes[i] = overloads[i].argumentTypes();
                this.parameterNames[i] = overloads[i].argumentNames();
                this.returnTypes[i] = overloads[i].returnType() == LuaMethodOverload.DEFAULT.class ? method.getReturnType() : overloads[i].returnType();
            }
        }

        @Override
        public int print() {
            class_5250 message = HEADER.method_27661();
            message.method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.text.function")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style)).method_27693("\n\t").method_10852((class_2561)class_2561.method_43470((String)("\u2022 " + this.name)).method_27696(ColorUtils.Colors.BLUE.style));
            if (this.aliases.length > 0) {
                message.method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.text.aliases")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style));
                for (String alias : this.aliases) {
                    message.method_27693("\n\t").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_27693(alias).method_27696(ColorUtils.Colors.BLUE.style));
                }
            }
            message.method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.text.syntax")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style));
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                message.method_27693("\n\t").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_27696(ColorUtils.Colors.BLUE.style)).method_10852((class_2561)class_2561.method_43470((String)("<" + this.typeName + ">")).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)(this.isStatic ? "." : ":")).method_27692(class_124.field_1067)).method_10852((class_2561)class_2561.method_43470((String)this.name).method_27696(ColorUtils.Colors.BLUE.style)).method_27693("(");
                for (int j = 0; j < this.parameterTypes[i].length; ++j) {
                    message.method_10852((class_2561)FiguraDocsManager.getClassText(this.parameterTypes[i][j]).method_27692(class_124.field_1054)).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)this.parameterNames[i][j]).method_27692(class_124.field_1068));
                    if (j == this.parameterTypes[i].length - 1) continue;
                    message.method_27693(", ");
                }
                message.method_27693(") \u2192 ").method_10852((class_2561)FiguraText.of("docs.text.returns").method_27693(" ").method_27696(ColorUtils.Colors.BLUE.style)).method_10852((class_2561)FiguraDocsManager.getClassText(this.returnTypes[i]).method_27692(class_124.field_1054));
            }
            message.method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.text.description")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style));
            class_5250 descText = class_2561.method_43473().method_27696(ColorUtils.Colors.BLUE.style);
            for (class_2561 component : TextUtils.splitText((class_5348)FiguraText.of("docs." + this.description), "\n")) {
                descText.method_27693("\n\t").method_27693("\u2022 ").method_10852(component);
            }
            message.method_10852((class_2561)descText);
            FiguraMod.sendChatMessage((class_2561)message);
            return 1;
        }

        @Override
        public LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
            LiteralArgumentBuilder<FiguraClientCommandSource> command = super.getCommand();
            if (this.children != null) {
                for (FiguraDoc child : this.children) {
                    command.then(child.getCommand());
                }
            }
            return command;
        }

        @Override
        public JsonObject toJson(boolean translate) {
            JsonObject json = super.toJson(translate);
            JsonArray params = new JsonArray();
            for (int i = 0; i < this.parameterNames.length; ++i) {
                Class<?>[] param = new JsonArray();
                for (int j = 0; j < this.parameterNames[i].length; ++j) {
                    JsonObject paramObj = new JsonObject();
                    paramObj.addProperty("name", this.parameterNames[i][j]);
                    paramObj.addProperty("type", FiguraDocsManager.getNameFor(this.parameterTypes[i][j]));
                    param.add((JsonElement)paramObj);
                }
                params.add(param);
            }
            json.add("parameters", (JsonElement)params);
            JsonArray returns = new JsonArray();
            for (Class<?> returnType : this.returnTypes) {
                returns.add(FiguraDocsManager.getNameFor(returnType));
            }
            json.add("returns", (JsonElement)returns);
            JsonArray aliases = new JsonArray();
            for (String alias : this.aliases) {
                aliases.add(alias);
            }
            json.add("aliases", (JsonElement)aliases);
            JsonArray children = new JsonArray();
            if (this.children != null) {
                for (FiguraDoc child : this.children) {
                    children.add((JsonElement)child.toJson(translate));
                }
            }
            json.add("children", (JsonElement)children);
            json.addProperty("static", Boolean.valueOf(this.isStatic));
            return json;
        }
    }

    public static class ClassDoc
    extends FiguraDoc {
        public final ArrayList<MethodDoc> documentedMethods;
        public final ArrayList<FieldDoc> documentedFields;
        public final Class<?> thisClass;
        public final Class<?> superclass;

        public ClassDoc(Class<?> clazz, LuaTypeDoc typeDoc) {
            this(clazz, typeDoc, null);
        }

        public ClassDoc(Class<?> clazz, LuaTypeDoc typeDoc, Map<String, List<FiguraDoc>> children) {
            super(typeDoc.name(), typeDoc.value());
            this.thisClass = clazz;
            this.superclass = clazz.getSuperclass().isAnnotationPresent(LuaTypeDoc.class) ? clazz.getSuperclass() : null;
            this.documentedMethods = new ArrayList();
            HashSet<String> foundIndices = new HashSet<String>();
            for (Method method : clazz.getDeclaredMethods()) {
                this.parseMethodIfNeeded(foundIndices, children, typeDoc, method);
            }
            for (Method method : clazz.getMethods()) {
                this.parseMethodIfNeeded(foundIndices, children, typeDoc, method);
            }
            this.documentedFields = new ArrayList();
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                this.parseFieldIfNeeded(children, foundIndices, (Field)accessibleObject);
            }
            for (AccessibleObject accessibleObject : clazz.getFields()) {
                this.parseFieldIfNeeded(children, foundIndices, (Field)accessibleObject);
            }
        }

        private void parseMethodIfNeeded(Set<String> foundIndices, Map<String, List<FiguraDoc>> children, LuaTypeDoc typeDoc, Method method) {
            String name = method.getName();
            if (foundIndices.contains(name) || !method.isAnnotationPresent(LuaMethodDoc.class)) {
                return;
            }
            foundIndices.add(name);
            LuaMethodDoc doc = method.getAnnotation(LuaMethodDoc.class);
            List<FiguraDoc> childList = children == null ? null : children.get(name);
            this.documentedMethods.add(new MethodDoc(method, doc, childList, typeDoc.name()));
        }

        private void parseFieldIfNeeded(Map<String, List<FiguraDoc>> children, Set<String> foundIndices, Field field) {
            String name = field.getName();
            if (foundIndices.contains(name) || !field.isAnnotationPresent(LuaFieldDoc.class)) {
                return;
            }
            foundIndices.add(name);
            List<FiguraDoc> childList = children == null ? null : children.get(name);
            this.documentedFields.add(new FieldDoc(field, field.getAnnotation(LuaFieldDoc.class), childList));
        }

        @Override
        public int print() {
            class_5250 message = HEADER.method_27661().method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.text.type")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style));
            message.method_27693("\n\t").method_10852((class_2561)class_2561.method_43470((String)("\u2022 " + this.name)).method_27696(ColorUtils.Colors.BLUE.style));
            if (this.superclass != null) {
                message.method_27693(" (").method_10852((class_2561)FiguraText.of("docs.text.extends")).method_27693(" ").method_10852((class_2561)FiguraDocsManager.getClassText(this.superclass).method_27692(class_124.field_1054)).method_27693(")");
            }
            message.method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.text.description")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style));
            class_5250 descText = class_2561.method_43473().method_27696(ColorUtils.Colors.BLUE.style);
            for (class_2561 component : TextUtils.splitText((class_5348)FiguraText.of("docs." + this.description), "\n")) {
                descText.method_27693("\n\t").method_27693("\u2022 ").method_10852(component);
            }
            message.method_10852((class_2561)descText);
            FiguraMod.sendChatMessage((class_2561)message);
            return 1;
        }

        @Override
        public LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
            LiteralArgumentBuilder<FiguraClientCommandSource> command = super.getCommand();
            for (MethodDoc methodDoc : this.documentedMethods) {
                command.then(methodDoc.getCommand());
            }
            for (FieldDoc fieldDoc : this.documentedFields) {
                command.then(fieldDoc.getCommand());
            }
            return command;
        }

        @Override
        public JsonObject toJson(boolean translate) {
            JsonObject json = super.toJson(translate);
            if (this.superclass != null) {
                json.addProperty("parent", FiguraDocsManager.getNameFor(this.superclass));
            }
            JsonArray methods = new JsonArray();
            for (MethodDoc methodDoc : this.documentedMethods) {
                methods.add((JsonElement)methodDoc.toJson(translate));
            }
            json.add("methods", (JsonElement)methods);
            JsonArray fields = new JsonArray();
            for (FieldDoc fieldDoc : this.documentedFields) {
                fields.add((JsonElement)fieldDoc.toJson(translate));
            }
            json.add("fields", (JsonElement)fields);
            return json;
        }
    }
}

