/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.lua.api;

import fabric.org.figuramc.figura.lua.LuaNotNil;
import fabric.org.figuramc.figura.lua.LuaWhitelist;
import fabric.org.figuramc.figura.lua.docs.LuaMethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodOverload;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import fabric.org.figuramc.figura.math.vector.FiguraVec4;
import fabric.org.figuramc.figura.mixin.render.TextureAtlasAccessor;
import fabric.org.figuramc.figura.utils.LuaUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;

@LuaWhitelist
@LuaTypeDoc(name="TextureAtlas", value="texture_atlas")
public class TextureAtlasAPI {
    private final class_1059 atlas;

    public TextureAtlasAPI(class_1059 atlas) {
        this.atlas = atlas;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture_atlas.list_sprites")
    public List<String> listSprites() {
        ArrayList<String> list = new ArrayList<String>();
        for (class_2960 res : ((TextureAtlasAccessor)this.atlas).getTexturesByName().keySet()) {
            list.add(res.toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"path"})}, value="texture_atlas.get_sprite_uv")
    public FiguraVec4 getSpriteUV(@LuaNotNil String sprite) {
        class_2960 spriteLocation = LuaUtils.parsePath(sprite);
        class_1058 s = this.atlas.method_4608(spriteLocation);
        return FiguraVec4.of(s.method_4594(), s.method_4593(), s.method_4577(), s.method_4575());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture_atlas.get_width")
    public int getWidth() {
        return ((TextureAtlasAccessor)this.atlas).getWidth();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture_atlas.get_height")
    public int getHeight() {
        return ((TextureAtlasAccessor)this.atlas).getHeight();
    }

    public String toString() {
        return "TextureAtlas (" + String.valueOf(this.atlas.method_24106()) + ")";
    }
}

