/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.widgets.lists;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.gui.widgets.FiguraWidget;
import fabric.org.figuramc.figura.gui.widgets.SwitchButton;
import fabric.org.figuramc.figura.gui.widgets.TextField;
import fabric.org.figuramc.figura.gui.widgets.lists.AbstractList;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import fabric.org.figuramc.figura.wizards.AvatarWizard;
import fabric.org.figuramc.figura.wizards.WizardEntry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class AvatarWizardList
extends AbstractList {
    private final AvatarWizard wizard;
    private final Map<class_2561, List<class_364>> map = new LinkedHashMap<class_2561, List<class_364>>();

    public AvatarWizardList(int x, int y, int width, int height, AvatarWizard wizard) {
        super(x, y, width, height);
        this.wizard = wizard;
        this.generate();
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        int x = this.method_46426();
        int y = this.method_46427();
        int width = this.method_25368();
        int height = this.method_25364();
        UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
        this.enableScissors(gui);
        class_327 font = class_310.method_1551().field_1772;
        Objects.requireNonNull(font);
        int lineHeight = 9 + 8;
        int entryHeight = 24;
        int size = 0;
        for (List<class_364> list : this.map.values()) {
            for (class_364 class_3642 : list) {
                if (class_3642 instanceof WizardInputBox) {
                    WizardInputBox ib = (WizardInputBox)class_3642;
                    ib.setVisible(this.wizard.checkDependency(ib.entry));
                    if (!ib.isVisible()) continue;
                    ++size;
                    continue;
                }
                if (!(class_3642 instanceof WizardToggleButton)) continue;
                WizardToggleButton tb = (WizardToggleButton)class_3642;
                tb.setVisible(this.wizard.checkDependency(tb.entry));
                if (!tb.isVisible()) continue;
                ++size;
            }
        }
        int totalHeight = entryHeight * size + lineHeight * this.map.size();
        this.scrollBar.setVisible(totalHeight > height);
        this.scrollBar.setScrollRatio(entryHeight, totalHeight - height);
        int yOffset = this.scrollBar.isVisible() ? (int)(-class_3532.method_16436((double)this.scrollBar.getScrollProgress(), (double)-4.0, (double)(totalHeight - height))) : 4;
        for (Map.Entry entry : this.map.entrySet()) {
            List value = (List)entry.getValue();
            if (value.isEmpty()) continue;
            int newY = yOffset + lineHeight;
            for (class_364 w : (List)entry.getValue()) {
                FiguraWidget widget = (FiguraWidget)w;
                if (!widget.isVisible()) continue;
                widget.method_46419(y + newY);
                newY += entryHeight;
            }
            if (newY == yOffset + lineHeight) continue;
            gui.method_27534(font, (class_2561)entry.getKey(), x + width / 2, y + yOffset + 4, 0xFFFFFF);
            yOffset = newY;
        }
        super.method_25394(gui, mouseX, mouseY, delta);
        gui.method_44380();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_364 class_3642 : this.method_25396()) {
            if (!(class_3642 instanceof TextField)) continue;
            TextField field = (TextField)class_3642;
            field.getField().method_25365(field.isEnabled() && field.method_25405(mouseX, mouseY));
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void generate() {
        for (List<class_364> value : this.map.values()) {
            this.children.removeAll(value);
        }
        this.map.clear();
        int x = this.method_46426() + this.method_25368() / 2 + 4;
        int width = this.method_25368() / 2 - 20;
        class_5250 lastName = class_2561.method_43473();
        ArrayList<FiguraWidget> lastList = new ArrayList<FiguraWidget>();
        for (WizardEntry value : WizardEntry.all()) {
            switch (value.type) {
                case CATEGORY: {
                    if (!lastList.isEmpty()) {
                        this.map.put((class_2561)lastName, lastList);
                        this.children.addAll(lastList);
                    }
                    lastName = FiguraText.of("gui.avatar_wizard." + value.name.toLowerCase());
                    lastList = new ArrayList();
                    break;
                }
                case TEXT: {
                    lastList.add(new WizardInputBox(x, width, this, value));
                    break;
                }
                case TOGGLE: {
                    lastList.add(new WizardToggleButton(x, width, this, value));
                }
            }
        }
        this.map.put((class_2561)lastName, lastList);
        this.children.addAll(lastList);
    }

    private static class WizardInputBox
    extends TextField {
        private final AvatarWizardList parent;
        private final WizardEntry entry;
        private final class_2561 name;

        public WizardInputBox(int x, int width, AvatarWizardList parent, WizardEntry entry) {
            super(x, 0, width, 20, TextField.HintType.ANY, s -> parent.wizard.changeEntry(entry, s));
            this.parent = parent;
            this.entry = entry;
            this.name = FiguraText.of("gui.avatar_wizard." + entry.name.toLowerCase());
            this.getField().method_1852(String.valueOf(parent.wizard.getEntry(entry, "")));
        }

        @Override
        public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
            if (!this.isVisible()) {
                return;
            }
            super.method_25394(gui, mouseX, mouseY, delta);
            class_327 font = class_310.method_1551().field_1772;
            class_5250 name = this.name.method_27661();
            if (!this.getField().method_1882().isBlank()) {
                name.method_10862(FiguraMod.getAccentColor());
            }
            int n = this.method_46426() - this.method_25368() - 8;
            float f = this.method_46427();
            int n2 = this.method_25364();
            Objects.requireNonNull(font);
            gui.method_27535(font, (class_2561)name, n, (int)(f + (float)(n2 - 9) / 2.0f), 0xFFFFFF);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.method_25405(mouseX, mouseY);
        }
    }

    private static class WizardToggleButton
    extends SwitchButton {
        private final AvatarWizardList parent;
        private final WizardEntry entry;

        public WizardToggleButton(int x, int width, AvatarWizardList parent, WizardEntry entry) {
            super(x, 0, width, 20, (class_2561)FiguraText.of("gui.avatar_wizard." + entry.name.toLowerCase()), false);
            this.parent = parent;
            this.entry = entry;
            this.setToggled((Boolean)parent.wizard.getEntry(entry, false));
        }

        @Override
        public void method_25306() {
            super.method_25306();
            this.parent.wizard.changeEntry(this.entry, this.isToggled());
        }

        @Override
        protected void renderDefaultTexture(class_332 gui, float delta) {
            class_4587 pose = gui.method_51448();
            pose.method_22903();
            pose.method_46416((float)(this.method_25368() - 30), 0.0f, 0.0f);
            super.renderDefaultTexture(gui, delta);
            pose.method_22909();
        }

        @Override
        protected void renderText(class_332 gui, float delta) {
            class_327 font = class_310.method_1551().field_1772;
            class_5250 name = this.method_25369().method_27661();
            if (this.isToggled()) {
                name.method_27696(FiguraMod.getAccentColor());
            }
            int n = this.method_46426() - this.method_25368() - 8;
            float f = this.method_46427();
            int n2 = this.method_25364();
            Objects.requireNonNull(font);
            gui.method_27535(font, (class_2561)name, n, (int)(f + (float)(n2 - 9) / 2.0f), 0xFFFFFF);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.method_25405(mouseX, mouseY);
        }
    }
}

