/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.widgets;

import fabric.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import fabric.org.figuramc.figura.utils.FiguraIdentifier;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.TextUtils;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class TextField
extends AbstractContainerElement {
    public static final class_2960 BACKGROUND = new FiguraIdentifier("textures/gui/text_field.png");
    public static final int ENABLED_COLOR = class_124.field_1068.method_532();
    public static final int DISABLED_COLOR = class_124.field_1063.method_532();
    private final HintType hint;
    private final class_342 field;
    private int borderColour = -1;
    private boolean enabled = true;

    public TextField(int x, int y, int width, int height, HintType hint, Consumer<String> changedListener) {
        super(x, y, width, height);
        this.hint = hint;
        this.field = new class_342(class_310.method_1551().field_1772, x + 4, y + (height - 8) / 2, width - 12, height - (height - 8) / 2, (class_2561)class_2561.method_43473());
        this.field.method_1880(Short.MAX_VALUE);
        this.field.method_1858(false);
        this.field.method_1863(changedListener);
        this.children.add(this.field);
    }

    @Override
    public void tick() {
        this.field.method_1865();
        super.tick();
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        UIHelper.blitSliced(gui, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), !this.isEnabled() ? 0.0f : (this.method_25405(mouseX, mouseY) ? 32.0f : 16.0f), 0.0f, 16, 16, 48, 16, BACKGROUND);
        if (this.method_25370()) {
            UIHelper.fillOutline(gui, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.borderColour);
        }
        if (this.hint != null && this.field.method_1882().isEmpty() && !this.field.method_25370()) {
            this.renderHint(gui);
        }
        super.method_25394(gui, mouseX, mouseY, delta);
    }

    protected void renderHint(class_332 gui) {
        class_327 font = class_310.method_1551().field_1772;
        class_5250 class_52502 = this.hint.hint.method_27661().method_10852(TextUtils.ELLIPSIS).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056});
        int n = this.method_46426() + 4;
        int n2 = this.method_46427();
        int n3 = this.method_25364();
        Objects.requireNonNull(font);
        gui.method_27535(font, (class_2561)class_52502, n, n2 + (int)((float)(n3 - 9 + 1) / 2.0f), 0xFFFFFF);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isEnabled() || !this.method_25405(mouseX, mouseY)) {
            return false;
        }
        mouseX = class_3532.method_15350((double)mouseX, (double)this.field.method_46426(), (double)(this.field.method_46426() + this.field.method_25368() - 1));
        mouseY = class_3532.method_15350((double)mouseY, (double)this.field.method_46427(), (double)(this.field.method_46427() + this.field.method_25364() - 1));
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        return !this.field.method_25370();
    }

    @Override
    public void method_46421(int x) {
        super.method_46421(x);
        this.field.method_46421(x + 4);
    }

    @Override
    public void method_46419(int y) {
        super.method_46419(y);
        this.field.method_46419(y + (this.method_25364() - 8) / 2);
    }

    public void setBorderColour(int borderColour) {
        this.borderColour = borderColour;
    }

    public int getBorderColour() {
        return this.borderColour;
    }

    public class_342 getField() {
        return this.field;
    }

    @Override
    public void method_37020(class_6382 output) {
        this.field.method_37020(output);
    }

    @Override
    public class_6379.class_6380 method_37018() {
        return this.field.method_37018();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        this.field.method_25365(false);
    }

    public void setColor(int color) {
        this.field.method_1868(this.enabled ? color : DISABLED_COLOR);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setColor(ENABLED_COLOR);
    }

    @Override
    public void method_25365(boolean bl) {
        this.field.method_25365(bl);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean method_25370() {
        return this.isEnabled() && this.field.method_25370();
    }

    public static enum HintType {
        ANY,
        INT,
        POSITIVE_INT,
        FLOAT,
        POSITIVE_FLOAT,
        HEX_COLOR,
        FOLDER_PATH,
        IP,
        SEARCH,
        NAME;

        private final class_2561 hint = FiguraText.of("gui.text_hint." + this.name().toLowerCase());
    }
}

