/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.widgets;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import fabric.org.figuramc.figura.gui.widgets.ParentedButton;
import fabric.org.figuramc.figura.lua.api.sound.LuaSound;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5348;

public class PianoWidget
extends AbstractContainerElement {
    private static final int TOTAL_KEYS = 29;
    private static final String[] NOTES = new String[]{"F", "G", "A", "B", "C", "D", "E"};
    private final List<Key> keys = new ArrayList<Key>();
    private final Supplier<LuaSound> soundSupplier;
    private Key hovered;
    public boolean pressed;

    public PianoWidget(int x, int y, int width, int height, Supplier<LuaSound> soundSupplier) {
        super(x, y, width, height);
        this.soundSupplier = soundSupplier;
        double keyWidth = (double)(width - 2) / Math.ceil(14.5);
        float j = 0.0f;
        ArrayList<Key> sharpKeys = new ArrayList<Key>();
        int i = 1;
        int note = 0;
        int count = 0;
        while (i <= 29) {
            if (i % 2 != 1 || i % 7 != 0 && (i + 1) % 7 != 0) {
                boolean isSharp = i % 2 == 1;
                int keyX = x + 1 + (int)(keyWidth * (double)j);
                if (!isSharp) {
                    note = (note + 1) % NOTES.length;
                }
                Key key = new Key(keyX, y + 1, (int)Math.round(keyWidth), isSharp ? height / 2 : height - 2, NOTES[note] + (isSharp ? "#" : ""), (float)Math.pow(2.0, (float)(count - 12) / 12.0f), isSharp, this);
                ++count;
                if (!isSharp) {
                    this.children.add(key);
                } else {
                    sharpKeys.add(key);
                }
                this.keys.add(key);
            }
            ++i;
            j += 0.5f;
        }
        this.children.addAll(sharpKeys);
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        this.setHovered(this.method_25405(mouseX, mouseY));
        UIHelper.blitSliced(gui, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), UIHelper.OUTLINE_FILL);
        Key lastHovered = this.hovered;
        for (Key key : this.keys) {
            key.setHovered(key.method_25405(mouseX, mouseY));
        }
        super.method_25394(gui, mouseX, mouseY, delta);
        if (this.pressed && this.hovered != lastHovered && this.hovered != null) {
            this.hovered.run();
        }
    }

    private static class Key
    extends ParentedButton {
        private final PianoWidget parent;
        private final float pitch;
        private final boolean isSharp;

        public Key(int x, int y, int width, int height, String key, float pitch, boolean isSharp, PianoWidget parent) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)key), parent, button -> {});
            this.parent = parent;
            this.pitch = pitch;
            this.isSharp = isSharp;
        }

        public void method_25354(class_1144 soundManager) {
            LuaSound sound = this.parent.soundSupplier.get();
            if (sound != null) {
                class_243 vec = class_310.method_1551().field_1724 == null ? new class_243(0.0, 0.0, 0.0) : class_310.method_1551().field_1724.method_19538();
                sound.pos(vec.field_1352, vec.field_1351, vec.field_1350).pitch(this.pitch).play();
            } else {
                soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15114.comp_349()), (float)this.pitch, (float)1.0f));
            }
        }

        @Override
        public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
            if (!this.isVisible()) {
                return;
            }
            this.method_48579(gui, mouseX, mouseY, delta);
        }

        @Override
        public void method_48579(class_332 gui, int mouseX, int mouseY, float delta) {
            UIHelper.fillRounded(gui, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), (this.isSharp ? 0 : 0xFFFFFF) + -16777216);
            UIHelper.blitSliced(gui, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), UIHelper.OUTLINE);
            if (this.method_49606()) {
                UIHelper.fillRounded(gui, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), FiguraMod.getAccentColor().method_10973().method_27716() + -1610612736);
            }
            class_327 font = class_310.method_1551().field_1772;
            class_2561 message = this.method_25369();
            int x = this.method_46426() + this.method_25368() / 2 - font.method_27525((class_5348)message) / 2;
            int n = this.method_46427() + this.method_25364() / 2;
            Objects.requireNonNull(font);
            int y = n - 9 / 2;
            if (!this.isSharp) {
                y += this.method_25364() / 4;
            }
            gui.method_51439(font, this.method_25369(), x, y, this.isSharp ? 0xFFFFFF : 0, false);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            boolean over = super.method_25405(mouseX, mouseY);
            if (this.parent.hovered == this) {
                this.parent.hovered = over ? this : null;
                return over;
            }
            if (!over) {
                return false;
            }
            if (this.parent.hovered == null) {
                this.parent.hovered = this;
                return true;
            }
            if (this.parent.hovered.isSharp) {
                return false;
            }
            if (this.isSharp) {
                this.parent.hovered.setHovered(false);
                this.parent.hovered = this;
                return true;
            }
            return false;
        }
    }
}

