/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.widgets;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.gui.screens.AvatarScreen;
import fabric.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import fabric.org.figuramc.figura.gui.widgets.SwitchButton;
import fabric.org.figuramc.figura.model.rendering.EntityRenderMode;
import fabric.org.figuramc.figura.utils.FiguraIdentifier;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class EntityPreview
extends AbstractContainerElement {
    public static final class_2960 UNKNOWN = new FiguraIdentifier("textures/gui/unknown_entity.png");
    public static final class_2960 OVERLAY = new FiguraIdentifier("textures/gui/entity_overlay.png");
    private class_1309 entity;
    private final float pitch;
    private final float yaw;
    private final float scale;
    private SwitchButton button;
    private boolean isRotating = false;
    private float anchorX = 0.0f;
    private float anchorY = 0.0f;
    private float anchorAngleX = 0.0f;
    private float anchorAngleY = 0.0f;
    private float angleX;
    private float angleY;
    private float scaledValue = 0.0f;
    private float scaledPrecise = 0.0f;
    private static final float SCALE_FACTOR = 1.1f;
    private boolean isDragging = false;
    private int modelX;
    private int modelY;
    private float dragDeltaX;
    private float dragDeltaY;
    private float dragAnchorX;
    private float dragAnchorY;

    public EntityPreview(int x, int y, int width, int height, float scale, float pitch, float yaw, class_1309 entity, class_437 parentScreen) {
        super(x, y, width, height);
        this.scale = scale;
        this.pitch = pitch;
        this.yaw = yaw;
        this.entity = entity;
        this.modelX = width / 2;
        this.modelY = height / 2;
        this.angleX = pitch;
        this.angleY = yaw;
        this.button = new SwitchButton(x + 4, y + 4, 16, 16, 0, 0, 16, new FiguraIdentifier("textures/gui/expand.png"), 48, 32, (class_2561)FiguraText.of("gui.expand"), bx -> {
            if (this.button.isToggled()) {
                class_310.method_1551().method_1507((class_437)new AvatarScreen(scale, pitch, yaw, this.entity, parentScreen));
            } else {
                class_310.method_1551().method_1507(parentScreen);
            }
        });
        this.children.add(this.button);
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        int x = this.method_46426();
        int y = this.method_46427();
        int width = this.method_25368();
        int height = this.method_25364();
        if (!this.button.isToggled()) {
            UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
            UIHelper.blit(gui, x + 1, y + 1, width - 2, height, OVERLAY);
        }
        gui.method_44379(x + 1, y + 1, x + width - 1, y + height - 1);
        class_4587 pose = gui.method_51448();
        if (this.entity != null) {
            pose.method_22903();
            this.scaledValue = class_3532.method_16439((float)((float)(1.0 - Math.pow(0.5, delta))), (float)this.scaledValue, (float)this.scaledPrecise);
            UIHelper.drawEntity(x + this.modelX, y + this.modelY, this.scale + this.scaledValue, this.angleX, this.angleY, this.entity, gui, EntityRenderMode.FIGURA_GUI);
            pose.method_22909();
        } else {
            int s = Math.min(width, height) * 2 / 3;
            UIHelper.enableBlend();
            gui.method_25293(UNKNOWN, x + (width - s) / 2, y + (height - s) / 2, s, s, 0.0f, (float)(64 * ((int)((float)FiguraMod.ticks / 3.0f) % 8)), 64, 64, 64, 512);
        }
        gui.method_44380();
        super.method_25394(gui, mouseX, mouseY, delta);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isVisible() || !this.method_25405(mouseX, mouseY)) {
            return false;
        }
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        switch (button) {
            case 0: {
                this.anchorX = (float)mouseX;
                this.anchorY = (float)mouseY;
                this.anchorAngleX = this.angleX;
                this.anchorAngleY = this.angleY;
                this.isRotating = true;
                return true;
            }
            case 1: {
                this.dragDeltaX = (float)mouseX;
                this.dragDeltaY = (float)mouseY;
                this.dragAnchorX = this.modelX;
                this.dragAnchorY = this.modelY;
                this.isDragging = true;
                return true;
            }
            case 2: {
                this.isRotating = false;
                this.isDragging = false;
                this.anchorX = 0.0f;
                this.anchorY = 0.0f;
                this.anchorAngleX = 0.0f;
                this.anchorAngleY = 0.0f;
                this.angleX = this.pitch;
                this.angleY = this.yaw;
                this.scaledValue = 0.0f;
                this.scaledPrecise = 0.0f;
                this.modelX = this.method_25368() / 2;
                this.modelY = this.method_25364() / 2;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isRotating = false;
            return true;
        }
        if (button == 1) {
            this.isDragging = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isRotating) {
            this.angleX = (float)((double)this.anchorAngleX + ((double)this.anchorY - mouseY) / (3.0 / class_310.method_1551().method_22683().method_4495()));
            this.angleY = (float)((double)this.anchorAngleY - ((double)this.anchorX - mouseX) / (3.0 / class_310.method_1551().method_22683().method_4495()));
            if (this.angleX >= 360.0f || this.angleX <= -360.0f) {
                this.anchorY = (float)mouseY;
                this.anchorAngleX = 0.0f;
                this.angleX = 0.0f;
            }
            if (this.angleY >= 360.0f || this.angleY <= -360.0f) {
                this.anchorX = (float)mouseX;
                this.anchorAngleY = 0.0f;
                this.angleY = 0.0f;
            }
            return true;
        }
        if (this.isDragging) {
            float x = (float)(mouseX - (double)this.dragDeltaX);
            float y = (float)(mouseY - (double)this.dragDeltaY);
            this.modelX = (int)(this.dragAnchorX + x);
            this.modelY = (int)(this.dragAnchorY + y);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        float scaleDir = amount > 0.0 ? 1.1f : 0.9090909f;
        this.scaledPrecise = (this.scale + this.scaledPrecise) * scaleDir - this.scale;
        return true;
    }

    public void setEntity(class_1309 entity) {
        this.entity = entity;
    }

    public void setToggled(boolean toggled) {
        this.button.setToggled(toggled);
        this.button.setTooltip((class_2561)(toggled ? FiguraText.of("gui.minimise") : FiguraText.of("gui.expand")));
    }
}

