/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.avatar.local;

import com.sun.nio.file.ExtendedWatchEventModifier;
import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.AvatarManager;
import fabric.org.figuramc.figura.avatar.UserData;
import fabric.org.figuramc.figura.gui.FiguraToast;
import fabric.org.figuramc.figura.parsers.AvatarMetadataParser;
import fabric.org.figuramc.figura.parsers.BlockbenchModelParser;
import fabric.org.figuramc.figura.parsers.LuaScriptParser;
import fabric.org.figuramc.figura.utils.FiguraResourceListener;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3298;

public class LocalAvatarLoader {
    public static final boolean IS_WINDOWS = class_156.method_668() == class_156.class_158.field_1133;
    private static final HashMap<Path, WatchKey> KEYS = new HashMap();
    private static CompletableFuture<Void> tasks;
    private static Path lastLoadedPath;
    private static LoadState loadState;
    private static String loadError;
    private static WatchService watcher;
    public static final HashMap<class_2960, class_2487> CEM_AVATARS;
    public static final FiguraResourceListener AVATAR_LISTENER;

    protected static void async(Runnable toRun) {
        if (tasks == null || tasks.isDone()) {
            tasks = CompletableFuture.runAsync(toRun);
        } else {
            tasks.thenRun(toRun);
        }
    }

    public static void loadAvatar(Path path, UserData target) {
        loadError = null;
        loadState = LoadState.UNKNOWN;
        LocalAvatarLoader.resetWatchKeys();
        try {
            path = path == null ? null : (path.getFileSystem() == FileSystems.getDefault() ? Path.of(path.toFile().getCanonicalPath(), new String[0]) : path.normalize());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        lastLoadedPath = path;
        if (path == null || target == null) {
            return;
        }
        LocalAvatarLoader.addWatchKey(path, KEYS::put);
        Path finalPath = path;
        LocalAvatarLoader.async(() -> {
            try {
                class_2487 nbt = new class_2487();
                loadState = LoadState.SCRIPTS;
                LocalAvatarLoader.loadScripts(finalPath, nbt);
                loadState = LoadState.SOUNDS;
                LocalAvatarLoader.loadSounds(finalPath, nbt);
                class_2487 textures = new class_2487();
                class_2499 animations = new class_2499();
                BlockbenchModelParser modelParser = new BlockbenchModelParser();
                loadState = LoadState.MODELS;
                class_2487 models = LocalAvatarLoader.loadModels(finalPath, finalPath, modelParser, textures, animations, "");
                models.method_10582("name", "models");
                loadState = LoadState.METADATA;
                String metadata = IOUtils.readFile(finalPath.resolve("avatar.json"));
                nbt.method_10566("metadata", (class_2520)AvatarMetadataParser.parse(metadata, IOUtils.getFileNameOrEmpty(finalPath)));
                AvatarMetadataParser.injectToModels(metadata, models);
                AvatarMetadataParser.injectToTextures(metadata, textures);
                if (!models.method_33133()) {
                    nbt.method_10566("models", (class_2520)models);
                }
                if (!textures.method_33133()) {
                    nbt.method_10566("textures", (class_2520)textures);
                }
                if (!animations.isEmpty()) {
                    nbt.method_10566("animations", (class_2520)animations);
                }
                target.loadAvatar(nbt);
            }
            catch (Throwable e) {
                loadError = e.getMessage();
                FiguraMod.LOGGER.error("Failed to load avatar from " + String.valueOf(finalPath), e);
                FiguraToast.sendToast(FiguraText.of("toast.load_error"), FiguraText.of("gui.load_error." + LocalAvatarLoader.getLoadState()), FiguraToast.ToastType.ERROR);
            }
        });
    }

    private static void loadScripts(Path path, class_2487 nbt) throws IOException {
        List<Path> scripts = IOUtils.getFilesByExtension(path, ".lua");
        if (scripts.size() > 0) {
            class_2487 scriptsNbt = new class_2487();
            String pathRegex = path.toString().isEmpty() ? "\\Q\\E" : Pattern.quote(String.valueOf(path) + path.getFileSystem().getSeparator());
            for (Path script : scripts) {
                String name = script.toString().replaceFirst(pathRegex, "").replaceAll("[/\\\\]", ".");
                name = name.substring(0, name.length() - 4);
                scriptsNbt.method_10566(name, (class_2520)LuaScriptParser.parseScript(name, IOUtils.readFile(script)));
            }
            nbt.method_10566("scripts", (class_2520)scriptsNbt);
        }
    }

    private static void loadSounds(Path path, class_2487 nbt) throws IOException {
        List<Path> sounds = IOUtils.getFilesByExtension(path, ".ogg");
        if (sounds.size() > 0) {
            class_2487 soundsNbt = new class_2487();
            String pathRegex = Pattern.quote((String)(path.toString().isEmpty() ? path.toString() : String.valueOf(path) + path.getFileSystem().getSeparator()));
            for (Path sound : sounds) {
                String name = sound.toString().replaceFirst(pathRegex, "").replaceAll("[/\\\\]", ".");
                name = name.substring(0, name.length() - 4);
                soundsNbt.method_10570(name, IOUtils.readFileBytes(sound));
            }
            nbt.method_10566("sounds", (class_2520)soundsNbt);
        }
    }

    private static class_2487 loadModels(Path avatarFolder, Path currentFile, BlockbenchModelParser parser, class_2487 textures, class_2499 animations, String folders) throws Exception {
        class_2487 result = new class_2487();
        List<Path> subFiles = IOUtils.listPaths(currentFile);
        class_2499 children = new class_2499();
        if (subFiles != null) {
            for (Path file : subFiles) {
                if (IOUtils.isHidden(file)) continue;
                String name = IOUtils.getFileNameOrEmpty(file);
                if (Files.isDirectory(file, new LinkOption[0])) {
                    class_2487 subfolder = LocalAvatarLoader.loadModels(avatarFolder, file, parser, textures, animations, folders + name + ".");
                    if (subfolder.method_33133()) continue;
                    subfolder.method_10582("name", name);
                    BlockbenchModelParser.parseParent(name, subfolder);
                    children.add((Object)subfolder);
                    continue;
                }
                if (!file.toString().toLowerCase().endsWith(".bbmodel")) continue;
                BlockbenchModelParser.ModelData data = parser.parseModel(avatarFolder, file, IOUtils.readFile(file), name.substring(0, name.length() - 8), folders);
                children.add((Object)data.modelNbt());
                animations.addAll(data.animationList());
                class_2487 dataTag = data.textures();
                if (dataTag.method_33133()) continue;
                if (textures.method_33133()) {
                    textures.method_10566("data", (class_2520)new class_2499());
                    textures.method_10566("src", (class_2520)new class_2487());
                }
                textures.method_10554("data", 10).addAll((Collection)dataTag.method_10554("data", 10));
                textures.method_10562("src").method_10543(dataTag.method_10562("src"));
            }
        }
        if (children.size() > 0) {
            result.method_10566("chld", (class_2520)children);
        }
        return result;
    }

    public static void tick() {
        WatchEvent<?> event = null;
        boolean reload = false;
        for (Map.Entry<Path, WatchKey> entry : KEYS.entrySet()) {
            WatchKey key = entry.getValue();
            if (!key.isValid()) continue;
            for (WatchEvent<?> watchEvent : key.pollEvents()) {
                WatchEvent.Kind<?> kind = watchEvent.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                event = watchEvent;
                Path path = entry.getKey().resolve((Path)event.context());
                String name = IOUtils.getFileNameOrEmpty(path);
                if (IOUtils.isHidden(path) || !Files.isDirectory(path, new LinkOption[0]) && !name.matches("(.*(\\.lua|\\.bbmodel|\\.ogg|\\.png)$|avatar\\.json)")) continue;
                if (kind == StandardWatchEventKinds.ENTRY_CREATE && !IS_WINDOWS) {
                    LocalAvatarLoader.addWatchKey(path, KEYS::put);
                }
                reload = true;
                break;
            }
            if (!reload) continue;
            break;
        }
        if (reload) {
            FiguraMod.debug("Detected file changes in the Avatar directory (" + event.context().toString() + "), reloading!", new Object[0]);
            AvatarManager.loadLocalAvatar(lastLoadedPath);
        }
    }

    public static void resetWatchKeys() {
        lastLoadedPath = null;
        for (WatchKey key : KEYS.values()) {
            key.cancel();
        }
        KEYS.clear();
    }

    protected static void addWatchKey(Path path, BiConsumer<Path, WatchKey> consumer) {
        if (watcher == null || path == null || path.getFileSystem() != FileSystems.getDefault()) {
            return;
        }
        if (!Files.isDirectory(path, new LinkOption[0]) || IOUtils.isHidden(path)) {
            return;
        }
        try {
            WatchEvent.Kind[] events = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
            WatchKey key = IS_WINDOWS ? path.register(watcher, events, ExtendedWatchEventModifier.FILE_TREE) : path.register(watcher, events);
            consumer.accept(path, key);
            List<Path> children = IOUtils.listPaths(path);
            if (children == null || IS_WINDOWS) {
                return;
            }
            for (Path child : children) {
                LocalAvatarLoader.addWatchKey(child, consumer);
            }
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to register watcher for " + String.valueOf(path), (Throwable)e);
        }
    }

    public static Path getLastLoadedPath() {
        return lastLoadedPath;
    }

    public static String getLoadState() {
        return loadState.name().toLowerCase();
    }

    public static String getLoadError() {
        return loadError;
    }

    static {
        loadState = LoadState.UNKNOWN;
        CEM_AVATARS = new HashMap();
        AVATAR_LISTENER = FiguraResourceListener.createResourceListener("cem", manager -> {
            CEM_AVATARS.clear();
            AvatarManager.clearCEMAvatars();
            for (Map.Entry cem : manager.method_14488("cem", location -> location.method_12836().equals("figura") && location.method_12832().endsWith(".moon")).entrySet()) {
                class_2487 nbt;
                class_2960 key = (class_2960)cem.getKey();
                String[] split = key.method_12832().split("/");
                if (split.length <= 1) continue;
                String namespace = split[split.length - 2];
                String path = split[split.length - 1];
                class_2960 id = new class_2960(namespace, path.substring(0, path.length() - 5));
                try {
                    nbt = class_2507.method_10629((InputStream)((class_3298)cem.getValue()).method_14482());
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error("Failed to load " + String.valueOf(id) + " avatar", (Throwable)e);
                    continue;
                }
                FiguraMod.LOGGER.info("Loaded CEM model for " + String.valueOf(id));
                CEM_AVATARS.put(id, nbt);
            }
        });
        try {
            watcher = FileSystems.getDefault().newWatchService();
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to initialize the watcher service", (Throwable)e);
        }
    }

    private static enum LoadState {
        UNKNOWN,
        SCRIPTS,
        SOUNDS,
        MODELS,
        METADATA;

    }
}

