/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.common.InternalChopEvent;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.util.TickUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="treechop", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MultiMine {
    private static final Map<Player, Long> lastChopTickByPlayers = new HashMap<Player, Long>();

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        if (ConfigHandler.COMMON.compatForMultiMine.get().booleanValue()) {
            MinecraftForge.EVENT_BUS.register(EventHandler.class);
        }
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onChop(InternalChopEvent.PreChopEvent event) {
            Player player = event.getPlayer();
            long gameTick = event.getLevel().m_46467_();
            if (lastChopTickByPlayers.getOrDefault(player, TickUtil.NEVER) == gameTick) {
                event.setCanceled(true);
            } else {
                lastChopTickByPlayers.put(player, gameTick);
            }
        }
    }
}

