/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.api.IChoppingItem;
import ht.treechop.api.ICylinderBlock;
import ht.treechop.api.IFellableBlock;
import ht.treechop.api.IStrippableBlock;
import ht.treechop.api.ITreeBlock;
import ht.treechop.api.ITreeChopBlockBehavior;
import ht.treechop.common.config.ConfigHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ClassUtil {
    @Nullable
    public static IChoppableBlock getChoppableBlock(BlockGetter level, BlockPos blockPos, BlockState blockState) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlockUnchecked(blockState.m_60734_());
        return choppableBlock != null && choppableBlock.isChoppable(level, blockPos, blockState) ? choppableBlock : null;
    }

    @Nullable
    public static IChoppableBlock getChoppableBlockUnchecked(Block block) {
        if (block instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)block;
            return choppableBlock;
        }
        ITreeChopBlockBehavior iTreeChopBlockBehavior = TreeChop.api.getRegisteredChoppableBlockBehavior(block);
        if (iTreeChopBlockBehavior instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)iTreeChopBlockBehavior;
            return choppableBlock;
        }
        if (ConfigHandler.COMMON.choppableBlocks.get().contains(block)) {
            return (IChoppableBlock)TreeChop.platform.getChoppedLogBlock();
        }
        return null;
    }

    @Nullable
    public static IFellableBlock getFellableBlock(Block block) {
        if (block instanceof IFellableBlock) {
            IFellableBlock fellableBlock = (IFellableBlock)block;
            return fellableBlock;
        }
        ITreeChopBlockBehavior iTreeChopBlockBehavior = TreeChop.api.getRegisteredChoppableBlockBehavior(block);
        if (iTreeChopBlockBehavior instanceof IFellableBlock) {
            IFellableBlock fellableBlock = (IFellableBlock)iTreeChopBlockBehavior;
            return fellableBlock;
        }
        return null;
    }

    @Nullable
    public static ICylinderBlock getCylinderBlock(Block block) {
        if (block instanceof ICylinderBlock) {
            ICylinderBlock cylinderBlock = (ICylinderBlock)block;
            return cylinderBlock;
        }
        ITreeChopBlockBehavior iTreeChopBlockBehavior = TreeChop.api.getRegisteredChoppableBlockBehavior(block);
        if (iTreeChopBlockBehavior instanceof ICylinderBlock) {
            ICylinderBlock cylinderBlock = (ICylinderBlock)iTreeChopBlockBehavior;
            return cylinderBlock;
        }
        return null;
    }

    @Nullable
    public static IStrippableBlock getStrippableBlock(Block block) {
        if (block instanceof IStrippableBlock) {
            IStrippableBlock strippableBlock = (IStrippableBlock)block;
            return strippableBlock;
        }
        ITreeChopBlockBehavior iTreeChopBlockBehavior = TreeChop.api.getRegisteredChoppableBlockBehavior(block);
        if (iTreeChopBlockBehavior instanceof IStrippableBlock) {
            IStrippableBlock strippableBlock = (IStrippableBlock)iTreeChopBlockBehavior;
            return strippableBlock;
        }
        return null;
    }

    @Nullable
    public static ITreeBlock getTreeBlock(Block block) {
        if (block instanceof ITreeBlock) {
            ITreeBlock treeBlock = (ITreeBlock)block;
            return treeBlock;
        }
        ITreeChopBlockBehavior iTreeChopBlockBehavior = TreeChop.api.getRegisteredChoppableBlockBehavior(block);
        if (iTreeChopBlockBehavior instanceof ITreeBlock) {
            ITreeBlock treeBlock = (ITreeBlock)iTreeChopBlockBehavior;
            return treeBlock;
        }
        return null;
    }

    public static IChoppingItem getChoppingItem(Item item) {
        if (item instanceof IChoppingItem) {
            IChoppingItem choppingItem = (IChoppingItem)item;
            return choppingItem;
        }
        return TreeChop.api.getRegisteredChoppingItemBehavior(item);
    }
}

