/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.api.AbstractTreeData;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.common.chop.Chop;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.util.BlockNeighbors;
import ht.treechop.common.util.ClassUtil;
import ht.tuber.graph.DirectedGraph;
import ht.tuber.graph.FloodFill;
import ht.tuber.graph.FloodFillImpl;
import ht.tuber.graph.GraphUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.RandomUtils;

public class LazyTreeData
extends AbstractTreeData {
    private final Level level;
    private final int chops;
    private final int maxNumLogs;
    private final boolean smartDetection;
    private final int maxLeavesDistance;
    private double mass = 0.0;
    private boolean overrideLeaves = false;
    private Set<BlockPos> logs = new HashSet<BlockPos>(){

        @Override
        public boolean add(BlockPos blockPos) {
            if (super.add(blockPos)) {
                LazyTreeData.this.mass += ChopUtil.getSupportFactor(LazyTreeData.this.level, blockPos);
                return true;
            }
            return false;
        }
    };
    private final Set<BlockPos> leaves = new HashSet<BlockPos>(){

        @Override
        public boolean add(BlockPos blockPos) {
            return super.add(blockPos);
        }
    };
    private FloodFill<BlockPos> generator;
    private Set<BlockPos> base;
    private final DirectedGraph<BlockPos> logsWorld;
    private final DirectedGraph<BlockPos> leavesWorld;

    public LazyTreeData(Level level, BlockPos origin, DirectedGraph<BlockPos> logGraph, DirectedGraph<BlockPos> leavesGraph, Predicate<BlockPos> logFilter, Predicate<BlockPos> leavesFilter, int maxNumLogs, int maxLeavesDistance, boolean smartDetection) {
        this.level = level;
        this.maxNumLogs = maxNumLogs;
        this.smartDetection = smartDetection;
        this.maxLeavesDistance = maxLeavesDistance;
        this.logsWorld = GraphUtil.filter(logGraph, this::gatherLog, pos -> this.check((BlockPos)pos, logFilter, leavesFilter));
        this.leavesWorld = GraphUtil.filterNeighbors(leavesGraph, leavesFilter);
        this.makeTreeBase(level, origin);
        this.chops = this.base.stream().map(pos -> ChopUtil.getNumChops(level, pos)).reduce(Integer::sum).orElse(0);
        this.generator = GraphUtil.flood(this.logsWorld, this.base, Vec3i::m_123342_);
    }

    private boolean gatherLog(BlockPos pos) {
        this.logs.add(pos);
        return true;
    }

    private boolean check(BlockPos pos, Predicate<BlockPos> logFilter, Predicate<BlockPos> leavesFilter) {
        if (leavesFilter.test(pos)) {
            this.leaves.add(pos);
        }
        return logFilter.test(pos);
    }

    @Override
    public boolean hasLeaves() {
        if (this.overrideLeaves || !this.leaves.isEmpty()) {
            return true;
        }
        return this.generator.fill().anyMatch(p -> !this.leaves.isEmpty() || this.overrideLeaves);
    }

    @Override
    public void setLogBlocks(Set<BlockPos> logBlocks) {
        this.logs = logBlocks;
        this.mass = ChopUtil.getSupportFactor(this.level, this.logs.stream()).orElse(1.0);
        this.generator = new FloodFillImpl<BlockPos>(List.of(), a -> Stream.empty(), a -> 0);
    }

    @Override
    public void setLeaves(boolean hasLeaves) {
        this.overrideLeaves = hasLeaves;
    }

    @Override
    public Stream<BlockPos> streamLogs() {
        return Stream.concat(this.logs.stream(), this.generator.fill()).limit(this.maxNumLogs);
    }

    @Override
    public Stream<BlockPos> streamLeaves() {
        LinkedList allLeaves = new LinkedList();
        this.forEachLeaves(this.leaves, allLeaves::add);
        return allLeaves.stream();
    }

    private void completeTree() {
        this.generator.fill().forEach(a -> {});
    }

    @Override
    public void forEachLeaves(Consumer<BlockPos> consumer) {
        this.forEachLeaves(this.leaves, consumer);
    }

    private void forEachLeaves(Collection<BlockPos> firstLeaves, Consumer<BlockPos> forEach) {
        this.completeTree();
        if (this.smartDetection) {
            this.forEachLeavesSmart(firstLeaves, forEach);
        } else {
            this.forEachLeavesDumb(firstLeaves, forEach);
        }
    }

    private void forEachLeavesSmart(Collection<BlockPos> firstLeaves, Consumer<BlockPos> forEach) {
        this.leaves.stream().filter(pos -> this.leavesHasExactDistance(this.level.m_8055_(pos), 1)).forEach(forEach);
        AtomicInteger highestDistance = new AtomicInteger(this.maxLeavesDistance);
        AtomicInteger distance = new AtomicInteger();
        DirectedGraph<BlockPos> distancedLeavesGraph = GraphUtil.filterNeighbors(this.leavesWorld, pos -> {
            BlockState state = this.level.m_8055_(pos);
            state.m_61145_((Property)LeavesBlock.f_54418_).ifPresent(d -> {
                if (d > highestDistance.get()) {
                    highestDistance.set((int)d);
                }
            });
            return this.leavesHasAtLeastDistance(state, distance.get());
        });
        FloodFillImpl<BlockPos> flood = new FloodFillImpl<BlockPos>(firstLeaves, distancedLeavesGraph, a -> 0);
        for (int i = 2; i <= highestDistance.get(); ++i) {
            distance.set(i);
            flood.fillOnce(forEach);
        }
    }

    private void forEachLeavesDumb(Collection<BlockPos> firstLeaves, Consumer<BlockPos> forEach) {
        FloodFillImpl<BlockPos> flood = new FloodFillImpl<BlockPos>(firstLeaves, this.leavesWorld, a -> 0);
        for (int i = 0; i < this.maxLeavesDistance; ++i) {
            flood.fillOnce(forEach);
        }
    }

    @Override
    public boolean readyToFell(int numChops) {
        if (!ChopUtil.enoughChopsToFell(numChops, this.mass)) {
            return false;
        }
        return this.generator.fill().allMatch(ignored -> ChopUtil.enoughChopsToFell(numChops, this.mass));
    }

    @Override
    public int getChops() {
        return this.chops;
    }

    public Level getLevel() {
        return this.level;
    }

    private boolean leavesHasExactDistance(BlockState state, int distance) {
        return state.m_61145_((Property)LeavesBlock.f_54418_).orElse(distance) == distance || state.m_61145_((Property)LeavesBlock.f_54419_).orElse(false) != false;
    }

    private boolean leavesHasAtLeastDistance(BlockState state, int distance) {
        return state.m_61145_((Property)LeavesBlock.f_54418_).orElse(distance) >= distance || state.m_61145_((Property)LeavesBlock.f_54419_).orElse(false) != false;
    }

    private void makeTreeBase(Level level, BlockPos origin) {
        this.base = new HashSet<BlockPos>();
        if (ChopUtil.isBlockChoppable(level, origin)) {
            DirectedGraph<BlockPos> adjacentWorld = BlockNeighbors.ADJACENTS_AND_DIAGONALS::asStream;
            this.base.add(origin);
            GraphUtil.flood(GraphUtil.filterNeighbors(adjacentWorld, pos -> ChopUtil.getNumChops(level, pos) > 0), origin, Vec3i::m_123342_).fill().forEach(this.base::add);
        }
    }

    @Override
    public Collection<Chop> chop(BlockPos target, int numChops) {
        Stack<Chop> chops = new Stack<Chop>();
        AtomicInteger chopsLeft = new AtomicInteger(numChops);
        if (chopsLeft.get() > 0) {
            GraphUtil.flood(this.logsWorld, this.base, a -> ChopUtil.blockDistance(target, a) * 32 + RandomUtils.nextInt((int)0, (int)32)).fill().takeWhile(pos -> {
                chopsLeft.set(LazyTreeData.gatherChopAndGetNumChopsRemaining(this.level, pos, chopsLeft.get(), chops));
                return chopsLeft.get() > 0;
            }).count();
        }
        return chops;
    }

    private static int gatherChopAndGetNumChopsRemaining(Level level, BlockPos pos, int numChops, List<Chop> chops) {
        BlockState blockStateBeforeChopping = level.m_8055_(pos);
        if (!(blockStateBeforeChopping.m_60734_() instanceof IChoppableBlock) && LazyTreeData.isBlockSurrounded(level, pos)) {
            return numChops;
        }
        int adjustedNumChops = LazyTreeData.adjustNumChops(level, pos, blockStateBeforeChopping, numChops);
        if (adjustedNumChops > 0) {
            chops.add(new Chop(pos, adjustedNumChops));
        }
        return numChops - adjustedNumChops;
    }

    private static int adjustNumChops(Level level, BlockPos blockPos, BlockState blockState, int numChops) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlock((BlockGetter)level, blockPos, blockState);
        if (choppableBlock != null) {
            int currentNumChops = choppableBlock.getNumChops((BlockGetter)level, blockPos, blockState);
            int maxNondestructiveChops = choppableBlock.getMaxNumChops((BlockGetter)level, blockPos, blockState) - currentNumChops;
            return Math.min(maxNondestructiveChops, numChops);
        }
        return 0;
    }

    private static boolean isBlockSurrounded(Level level, BlockPos pos) {
        return Stream.of(pos.m_122024_(), pos.m_122012_(), pos.m_122029_(), pos.m_122019_()).allMatch(neighborPos -> ChopUtil.isBlockALog(level, neighborPos));
    }
}

