/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.api.TreeData;
import ht.treechop.common.chop.ChopResult;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class FellTreeResult
implements ChopResult {
    private final Level level;
    private final TreeData tree;

    public FellTreeResult(Level level, TreeData tree) {
        this.level = level;
        this.tree = tree;
    }

    @Override
    public void apply(BlockPos targetPos, ServerPlayer player, ItemStack tool, boolean breakLeaves) {
        ServerLevel serverLevel;
        GameType gameType = player.f_8941_.m_9290_();
        Level level = this.level;
        if (level instanceof ServerLevel && !(serverLevel = (ServerLevel)level).m_8055_(targetPos).m_60795_() && !player.m_36187_((Level)serverLevel, targetPos, gameType)) {
            Consumer<BlockPos> blockBreaker = FellTreeResult.makeBlockBreaker(player, serverLevel);
            this.breakLogs(player, serverLevel, gameType, blockBreaker, targetPos);
            if (breakLeaves) {
                this.breakLeaves(player, serverLevel, gameType, blockBreaker);
            }
        }
    }

    @NotNull
    private static Consumer<BlockPos> makeBlockBreaker(ServerPlayer player, ServerLevel level) {
        if (player.m_7500_()) {
            BlockState air = Blocks.f_50016_.m_49966_();
            return pos -> level.m_46597_(pos, air);
        }
        return pos -> FellTreeResult.harvestWorldBlock(null, (Level)level, pos, ItemStack.f_41583_);
    }

    private void breakLogs(ServerPlayer player, ServerLevel level, GameType gameType, Consumer<BlockPos> blockBreaker, BlockPos targetPos) {
        long maxNumEffects = 4L;
        AtomicInteger i = new AtomicInteger(0);
        PriorityQueue<Pair> effects = new PriorityQueue<Pair>(Comparator.comparing(pair -> ((BlockPos)pair.getLeft()).m_123342_()));
        this.tree.streamLogs().filter(pos -> !pos.equals((Object)targetPos) && !player.m_36187_((Level)level, targetPos, gameType)).forEach(pos -> {
            FellTreeResult.collectSomeBlocks(effects, pos, level.m_8055_(pos), i, 3);
            blockBreaker.accept((BlockPos)pos);
        });
        effects.stream().limit(4L).forEach(posState -> FellTreeResult.playBlockBreakEffects((Level)level, (BlockPos)posState.getLeft(), (BlockState)posState.getRight()));
    }

    private void breakLeaves(ServerPlayer player, ServerLevel level, GameType gameType, Consumer<BlockPos> blockBreaker) {
        long maxNumEffects = 5L;
        AtomicInteger i = new AtomicInteger(0);
        PriorityQueue<Pair> effects = new PriorityQueue<Pair>(Comparator.comparing(pair -> ((BlockPos)pair.getLeft()).m_123342_()));
        Consumer<BlockPos> leavesBreaker = pos -> {
            if (!player.m_36187_((Level)level, pos, gameType)) {
                BlockState state = level.m_8055_(pos);
                if (FellTreeResult.isVanillaLeaves(state)) {
                    this.decayLeavesInsteadOfBreaking(level, (BlockPos)pos, state);
                } else {
                    blockBreaker.accept((BlockPos)pos);
                }
                if (player.m_20238_(pos.m_252807_()) > 9.0) {
                    FellTreeResult.collectSomeBlocks(effects, pos, state, i, 8);
                }
            }
        };
        this.tree.forEachLeaves(leavesBreaker);
        effects.stream().limit(5L).forEach(posState -> FellTreeResult.playBlockBreakEffects((Level)level, (BlockPos)posState.getLeft(), (BlockState)posState.getRight()));
    }

    private static void collectSomeBlocks(Queue<Pair<BlockPos, BlockState>> collection, BlockPos pos, BlockState state, AtomicInteger counter, int period) {
        if (counter.getAndIncrement() % period == 0) {
            collection.add((Pair<BlockPos, BlockState>)Pair.of((Object)pos, (Object)state));
        }
    }

    private static void playBlockBreakEffects(Level level, BlockPos pos, BlockState state) {
        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
    }

    private static void harvestWorldBlock(Entity agent, Level level, BlockPos pos, ItemStack tool) {
        BlockState blockState = level.m_8055_(pos);
        if (level instanceof ServerLevel) {
            FluidState fluidStateOrAir = level.m_6425_(pos);
            blockState.m_60734_().m_6786_((LevelAccessor)level, pos, blockState);
            Block.m_49881_((BlockState)blockState, (Level)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)agent, (ItemStack)tool);
            level.m_46597_(pos, fluidStateOrAir.m_76188_());
        }
    }

    private void decayLeavesInsteadOfBreaking(ServerLevel level, BlockPos pos, BlockState state) {
        BlockState decayingState = (BlockState)((BlockState)state.m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(7));
        decayingState.m_222972_(level, pos, level.f_46441_);
    }

    private static boolean isVanillaLeaves(BlockState blockState) {
        return blockState.m_61138_((Property)LeavesBlock.f_54418_) && blockState.m_61138_((Property)LeavesBlock.f_54419_) && ((BlockState)((BlockState)blockState.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_60823_();
    }
}

