/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.screen;

import ht.treechop.client.Client;
import ht.treechop.client.gui.element.ButtonGui;
import ht.treechop.client.gui.element.EmptyGui;
import ht.treechop.client.gui.element.ExclusiveButtonsGui;
import ht.treechop.client.gui.element.LabeledGui;
import ht.treechop.client.gui.element.NestedGui;
import ht.treechop.client.gui.element.RowsGui;
import ht.treechop.client.gui.element.ToggleGui;
import ht.treechop.client.gui.util.GUIUtil;
import ht.treechop.client.gui.util.Sprite;
import ht.treechop.client.gui.widget.StickyWidget;
import ht.treechop.client.gui.widget.ToggleWidget;
import ht.treechop.client.settings.ClientChopSettings;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.Setting;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClientSettingsScreen
extends Screen {
    private static final int ROW_SEPARATION = 1;
    private static final int INSET_SIZE = 20;
    private static final boolean IS_PAUSE_SCREEN = true;
    private static final int SPACE_ABOVE_AND_BELOW_LIST = 10;
    private static final int MIN_HEIGHT = 104;
    protected RowsGui optionsList;
    private Button doneButton;
    private int optionsPage = 0;
    private boolean needToRebuild = false;

    public ClientSettingsScreen() {
        super((Component)Component.m_237110_((String)"treechop.gui.settings.title", (Object[])new Object[]{"HT's TreeChop"}));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.rebuild();
    }

    private void rebuild() {
        List<NestedGui> optionRows = this.optionsPage == 0 ? this.makePageOne() : this.makePageTwo();
        this.addBufferRows(optionRows);
        optionRows.add(new ButtonGui(this.optionsPage == 0 ? Sprite.PAGE_ONE : Sprite.PAGE_TWO, this.optionsPage == 0 ? Sprite.HIGHLIGHTED_PAGE_ONE : Sprite.HIGHLIGHTED_PAGE_TWO, () -> {
            this.needToRebuild = true;
            this.optionsPage = this.optionsPage == 0 ? 1 : 0;
        }));
        this.optionsList = (RowsGui)this.m_142416_((GuiEventListener)new RowsGui(1, optionRows));
        int doneButtonWidth = 200;
        this.doneButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"gui.done"), button -> this.m_7379_()).m_252987_((this.f_96543_ - 200) / 2, this.getDoneButtonTop(), 200, 20).m_253136_());
    }

    private void addBufferRows(List<NestedGui> rows) {
        int missingHeight = 104 - RowsGui.getHeightForRows(rows, 1) - 2;
        if (missingHeight > 0) {
            rows.add(0, new EmptyGui(0, Math.floorDiv(missingHeight, 2)));
            rows.add(new EmptyGui(0, (int)Math.ceil((float)missingHeight / 2.0f)));
        }
    }

    private List<NestedGui> makePageOne() {
        LinkedList<NestedGui> optionRows = new LinkedList<NestedGui>();
        optionRows.add(new LabeledGui(this.f_96547_, (Component)Component.m_237115_((String)"treechop.gui.settings.label.chopping"), this.makeToggleSettingRow(SettingsField.CHOPPING, "treechop.gui.settings.tooltip.chopping")));
        if (((Boolean)ConfigHandler.CLIENT.showFellingOptions.get()).booleanValue()) {
            optionRows.add(new LabeledGui(this.f_96547_, (Component)Component.m_237115_((String)"treechop.gui.settings.label.felling"), this.makeToggleSettingRow(SettingsField.FELLING, "treechop.gui.settings.tooltip.felling")));
            optionRows.add(new LabeledGui(this.f_96547_, (Component)Component.m_237115_((String)"treechop.gui.settings.label.sneaking_inverts"), new ExclusiveButtonsGui.Builder().add((Component)Component.m_237115_((String)"treechop.gui.settings.button.chopping"), () -> Client.getChopSettings().setSneakBehavior(SneakBehavior.INVERT_CHOPPING), () -> StickyWidget.State.of(Client.getChopSettings().getSneakBehavior() == SneakBehavior.INVERT_CHOPPING, this.isSettingPermitted(SettingsField.CHOPPING, !Client.getChopSettings().getChoppingEnabled()) && this.isSettingPermitted(SettingsField.SNEAK_BEHAVIOR, (Object)SneakBehavior.INVERT_CHOPPING))).add((Component)Component.m_237115_((String)"treechop.gui.settings.button.felling"), () -> Client.getChopSettings().setSneakBehavior(SneakBehavior.INVERT_FELLING), () -> StickyWidget.State.of(Client.getChopSettings().getSneakBehavior() == SneakBehavior.INVERT_FELLING, this.isSettingPermitted(SettingsField.FELLING, !Client.getChopSettings().getFellingEnabled()) && this.isSettingPermitted(SettingsField.SNEAK_BEHAVIOR, (Object)SneakBehavior.INVERT_FELLING))).add((Component)Component.m_237115_((String)"treechop.gui.settings.button.nothing"), () -> Client.getChopSettings().setSneakBehavior(SneakBehavior.NONE), () -> this.makeStickyWidgetState(SettingsField.SNEAK_BEHAVIOR, (Object)SneakBehavior.NONE)).build(this::getSneakCycleTooltip)));
        } else {
            optionRows.add(new LabeledGui(this.f_96547_, (Component)Component.m_237115_((String)"treechop.gui.settings.label.sneaking_inverts_chopping"), new ToggleGui(() -> Client.getChopSettings().setSneakBehavior(this.getNextSneakBehavior()), () -> ToggleWidget.State.of(Client.getChopSettings().getSneakBehavior() == SneakBehavior.INVERT_CHOPPING, this.isSettingPermitted(SettingsField.SNEAK_BEHAVIOR, (Object)this.getNextSneakBehavior())), this::getSneakCycleTooltip)));
        }
        optionRows.add(new LabeledGui(this.f_96547_, (Component)Component.m_237115_((String)"treechop.gui.settings.label.only_chop_trees_with_leaves"), this.makeToggleSettingRow(SettingsField.TREES_MUST_HAVE_LEAVES, "treechop.gui.settings.tooltip.only_chop_trees_with_leaves")));
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_7500_()) {
            optionRows.add(new LabeledGui(this.f_96547_, (Component)Component.m_237115_((String)"treechop.gui.settings.label.chop_in_creative_mode"), this.makeToggleSettingRow(SettingsField.CHOP_IN_CREATIVE_MODE, "treechop.gui.settings.tooltip.chop_in_creative_mode")));
        }
        return optionRows;
    }

    private LinkedList<NestedGui> makePageTwo() {
        LinkedList<NestedGui> optionRows = new LinkedList<NestedGui>();
        optionRows.add(new LabeledGui(this.f_96547_, (Component)Component.m_237115_((String)"treechop.gui.settings.label.chop_in_creative_mode"), this.makeToggleSettingRow(SettingsField.CHOP_IN_CREATIVE_MODE, "treechop.gui.settings.tooltip.chop_in_creative_mode")));
        optionRows.add(new LabeledGui(this.f_96547_, (Component)Component.m_237115_((String)"treechop.gui.settings.label.chopping_indicator"), new ToggleGui(() -> Client.setChoppingIndicatorVisibility(!Client.isChoppingIndicatorEnabled()), () -> ToggleWidget.State.of(Client.isChoppingIndicatorEnabled(), true), () -> Component.m_237115_((String)("treechop.gui.settings.tooltip.chopping_indicator" + (Client.isChoppingIndicatorEnabled() ? ".on" : ".off"))))));
        optionRows.add(new LabeledGui(this.f_96547_, (Component)Component.m_237115_((String)"treechop.gui.settings.label.feedback_messages"), new ToggleGui(() -> ConfigHandler.CLIENT.showFeedbackMessages.set((Object)((Boolean)ConfigHandler.CLIENT.showFeedbackMessages.get() == false ? 1 : 0)), () -> ToggleWidget.State.of((Boolean)ConfigHandler.CLIENT.showFeedbackMessages.get(), true), () -> Component.m_237115_((String)("treechop.gui.settings.tooltip.feedback_messages" + ((Boolean)ConfigHandler.CLIENT.showFeedbackMessages.get() != false ? ".on" : ".off"))))));
        optionRows.add(new LabeledGui(this.f_96547_, (Component)Component.m_237115_((String)"treechop.gui.settings.label.felling_options"), new ToggleGui(() -> {
            boolean newValue = (Boolean)ConfigHandler.CLIENT.showFellingOptions.get() == false;
            ConfigHandler.CLIENT.showFellingOptions.set((Object)newValue);
            if (!newValue) {
                ClientChopSettings settings = Client.getChopSettings();
                settings.setFellingEnabled(true);
                if (settings.getSneakBehavior() == SneakBehavior.INVERT_FELLING) {
                    settings.setSneakBehavior(SneakBehavior.INVERT_CHOPPING);
                }
            }
        }, () -> ToggleWidget.State.of((Boolean)ConfigHandler.CLIENT.showFellingOptions.get(), Client.getServerPermissions().isPermitted(new Setting(SettingsField.FELLING, false))), () -> Component.m_237115_((String)("treechop.gui.settings.tooltip.felling_options" + ((Boolean)ConfigHandler.CLIENT.showFellingOptions.get() != false ? ".on" : ".off"))))));
        optionRows.add(new LabeledGui(this.f_96547_, (Component)Component.m_237115_((String)"treechop.gui.settings.label.tooltips"), new ToggleGui(() -> ConfigHandler.CLIENT.showTooltips.set((Object)((Boolean)ConfigHandler.CLIENT.showTooltips.get() == false ? 1 : 0)), () -> ToggleWidget.State.of((Boolean)ConfigHandler.CLIENT.showTooltips.get(), true), () -> Component.m_237115_((String)"treechop.gui.settings.tooltip.tooltips"))));
        return optionRows;
    }

    private Component getSneakCycleTooltip() {
        SettingsField field;
        switch (Client.getChopSettings().getSneakBehavior()) {
            case INVERT_CHOPPING: {
                field = SettingsField.CHOPPING;
                break;
            }
            case INVERT_FELLING: {
                field = SettingsField.FELLING;
                break;
            }
            default: {
                return Component.m_237115_((String)"treechop.gui.settings.tooltip.sneaking_does_nothing");
            }
        }
        String enablesOrDisablesLangKey = Client.getChopSettings().get(field, Boolean.class) != false ? "treechop.gui.settings.tooltip.sneaking_enables_x" : "treechop.gui.settings.tooltip.sneaking_disables_x";
        return Component.m_237110_((String)enablesOrDisablesLangKey, (Object[])new Object[]{field.getFancyName()});
    }

    private SneakBehavior getNextSneakBehavior() {
        return Client.getChopSettings().getSneakBehavior() == SneakBehavior.NONE ? SneakBehavior.INVERT_CHOPPING : SneakBehavior.NONE;
    }

    private ToggleGui makeToggleSettingRow(SettingsField field, String tooltipLangKey) {
        return new ToggleGui(() -> Client.getChopSettings().set(field, Client.getChopSettings().get(field, Boolean.class) == false), () -> ToggleWidget.State.of(Client.getChopSettings().get(field, Boolean.class), Client.getServerPermissions().isPermitted(new Setting(field, Client.getChopSettings().get(field, Boolean.class) == false))), () -> Component.m_237115_((String)(tooltipLangKey + (Client.getChopSettings().get(field, Boolean.class) != false ? ".on" : ".off"))));
    }

    private boolean isSettingPermitted(SettingsField field, Object value) {
        return Client.getServerPermissions().isPermitted(new Setting(field, value));
    }

    private StickyWidget.State makeStickyWidgetState(SettingsField field, Object value) {
        return StickyWidget.State.of(Client.getChopSettings().get(field) == value, Client.getServerPermissions().isPermitted(new Setting(field, value)));
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        if (this.needToRebuild) {
            this.m_169413_();
            this.rebuild();
            this.needToRebuild = false;
        }
        this.m_280273_(gui);
        this.doneButton.m_253211_(this.getDoneButtonTop());
        int listTop = this.getListTop();
        int listBottom = this.getListBottom();
        this.optionsList.setBox(0, listTop, this.f_96543_, listBottom - listTop);
        this.optionsList.m_88315_(gui, mouseX, mouseY, partialTicks);
        gui.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.getTitleTop(), 0xFFFFFF);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        if (((Boolean)ConfigHandler.CLIENT.showTooltips.get()).booleanValue()) {
            GUIUtil.renderTooltip(gui);
        }
    }

    public void m_280273_(GuiGraphics gui) {
        super.m_280273_(gui);
        gui.m_280509_(20, 20, this.f_96543_ - 20, this.f_96544_ - 20, 128);
    }

    public boolean m_7043_() {
        return true;
    }

    protected int getTop() {
        return 32;
    }

    protected int getBottom() {
        return this.f_96544_ - 32;
    }

    protected int getMiddleY() {
        return (this.getTop() + this.getBottom()) / 2;
    }

    protected int getTitleTop() {
        return this.getListTop() - 10 - 8;
    }

    protected int getListTop() {
        return this.getMiddleY() - this.getListHeight() / 2;
    }

    protected int getListHeight() {
        return this.optionsList.m_93694_();
    }

    protected int getListBottom() {
        return this.getMiddleY() + this.getListHeight() / 2;
    }

    protected int getDoneButtonTop() {
        return this.getListBottom() + 10;
    }
}

