/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client;

import ht.treechop.TreeChop;
import ht.treechop.client.Client;
import ht.treechop.client.KeyBindings;
import ht.treechop.client.gui.screen.ChopIndicator;
import ht.treechop.client.model.ForgeChoppedLogBakedModel;
import ht.treechop.common.network.CustomPacket;
import ht.treechop.common.network.ForgePacketHandler;
import ht.treechop.common.network.ServerUpdateChopsPacket;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeClient
extends Client {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ForgeChoppedLogBakedModel::overrideBlockStateModels);
    }

    @SubscribeEvent
    public static void onRegisterOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("chopping_indicator", (gui, poseStack, partialTicks, windowWidth, windowHeight) -> ChopIndicator.render(poseStack, windowWidth, windowHeight));
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        KeyBindings.registerKeyMappings(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    @Override
    void sendToServer(CustomPacket packet) {
        ForgePacketHandler.HANDLER.sendToServer((Object)packet);
    }

    static {
        Client.instance = new ForgeClient();
    }

    static class EventHandler {
        EventHandler() {
        }

        @SubscribeEvent
        public static void onConnect(ClientPlayerNetworkEvent.LoggingIn event) {
            Client.syncOnJoin();
        }

        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (!event.isCanceled() && event.getKey() != -1) {
                for (KeyBindings.ActionableKeyBinding keyBinding : KeyBindings.allKeyBindings) {
                    if (event.getKey() != keyBinding.getKey().m_84873_() || event.getAction() != 1) continue;
                    keyBinding.onPress();
                    return;
                }
            }
        }

        @SubscribeEvent
        public static void onLoadLevel(LevelEvent.Load event) {
            if (!TreeChop.platform.isDedicatedServer()) {
                ServerUpdateChopsPacket.checkLevel(event.getLevel());
            }
        }
    }
}

