/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMNetwork;
import party.lemons.biomemakeover.util.ClientUtil;

public class S2C_DoLightningEntity
extends BaseS2CMessage {
    private int entityID;
    private int count;

    public S2C_DoLightningEntity(int id, int count) {
        this.entityID = id;
        this.count = count;
    }

    public S2C_DoLightningEntity(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.count = buf.readInt();
    }

    public MessageType getType() {
        return BMNetwork.LIGHTNING_ENTITY;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.count);
    }

    public void handle(NetworkManager.PacketContext context) {
        Entity e = Minecraft.m_91087_().f_91073_.m_6815_(this.entityID);
        if (e == null || !(e instanceof LivingEntity)) {
            return;
        }
        context.queue(() -> {
            RandomSource random = ((LivingEntity)e).m_217043_();
            Vec3 entityPos = e.m_20182_();
            SimpleParticleType particleEffect = (SimpleParticleType)BMEffects.LIGHTNING_SPARK.get();
            for (int i = 0; i < this.count; ++i) {
                double speed = random.m_188500_() * 1.0;
                double ac = random.m_188500_() * Math.PI * 2.0;
                double xVel = Math.cos(ac) * speed * 0.1 / 10.0;
                double yVel = 0.01 + random.m_188500_() * 0.5;
                double zVel = Math.sin(ac) * speed * 0.1 / 10.0;
                Particle particle = ClientUtil.spawnParticle((ParticleOptions)particleEffect, particleEffect.m_6012_().m_123742_(), true, entityPos.f_82479_ + xVel * 0.01, entityPos.f_82480_ + 0.3, entityPos.f_82481_ + zVel * 0.01, xVel, yVel, zVel);
                if (particle == null) continue;
                particle.m_107268_((float)speed);
            }
        });
    }
}

