/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.init;

import com.mojang.serialization.Codec;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.level.feature.FissureFeature;
import party.lemons.biomemakeover.level.feature.GrassPatchFeature;
import party.lemons.biomemakeover.level.feature.HugeGreenGlowshroomFeature;
import party.lemons.biomemakeover.level.feature.HugeOrangeGlowshroomFeature;
import party.lemons.biomemakeover.level.feature.HugePurpleGlowshroomFeature;
import party.lemons.biomemakeover.level.feature.ItchingIvyFeature;
import party.lemons.biomemakeover.level.feature.MesmeriteBoulderFeature;
import party.lemons.biomemakeover.level.feature.MesmermiteUndergroundFeature;
import party.lemons.biomemakeover.level.feature.OrangeGlowshroomFeature;
import party.lemons.biomemakeover.level.feature.PaydirtFeature;
import party.lemons.biomemakeover.level.feature.PeatFeature;
import party.lemons.biomemakeover.level.feature.ReedFeature;
import party.lemons.biomemakeover.level.feature.SaguaroCactusFeature;
import party.lemons.biomemakeover.level.feature.SurfaceFossilFeature;
import party.lemons.biomemakeover.level.feature.WaterTreeFeature;
import party.lemons.biomemakeover.level.feature.foliage.AncientOakTrunkPlacer;
import party.lemons.biomemakeover.level.feature.foliage.BalsaTrunkPlacer;
import party.lemons.biomemakeover.level.feature.foliage.CypressTrunkPlacer;
import party.lemons.biomemakeover.level.feature.foliage.HangingLeavesDecorator;
import party.lemons.biomemakeover.level.feature.foliage.IvyDecorator;
import party.lemons.biomemakeover.level.feature.foliage.WillowFoliagePlacer;
import party.lemons.biomemakeover.level.feature.foliage.WillowTrunkPlacer;
import party.lemons.biomemakeover.level.feature.foliage.WillowingBranchDecorator;

public class BMFeatures {
    private static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registries.f_256833_);
    private static final DeferredRegister<FoliagePlacerType<?>> FOLIAGE = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registries.f_256905_);
    private static final DeferredRegister<TreeDecoratorType<?>> DECORATOR = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registries.f_256845_);
    private static final DeferredRegister<TrunkPlacerType<?>> TRUNK = DeferredRegister.create((String)"biomemakeover", (ResourceKey)Registries.f_256963_);
    public static final Supplier<Feature<BlockStateConfiguration>> MESMERMITE_BOULDER_FEATURE = FEATURES.register(BiomeMakeover.ID("mesmerite_boulder"), () -> new MesmeriteBoulderFeature((Codec<BlockStateConfiguration>)BlockStateConfiguration.f_67546_));
    public static final Supplier<Feature<OreConfiguration>> MESMERITE_UNDERGROUND_FEATURE = FEATURES.register(BiomeMakeover.ID("mesmerite_underground"), () -> new MesmermiteUndergroundFeature((Codec<OreConfiguration>)OreConfiguration.f_67837_));
    public static final Supplier<Feature<NoneFeatureConfiguration>> ITCHING_IVY_FEATURE = FEATURES.register(BiomeMakeover.ID("itching_ivy"), () -> new ItchingIvyFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Supplier<Feature<TreeConfiguration>> WATER_TREE = FEATURES.register(BiomeMakeover.ID("water_tree"), () -> new WaterTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final Supplier<Feature<NoneFeatureConfiguration>> PAYDIRT_FEATURE = FEATURES.register(BiomeMakeover.ID("paydirt"), () -> new PaydirtFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Supplier<Feature<NoneFeatureConfiguration>> SAGUARO_CACTUS_FEATURE = FEATURES.register(BiomeMakeover.ID("saguaro_cactus"), () -> new SaguaroCactusFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Supplier<Feature<NoneFeatureConfiguration>> SURFACE_FOSSIL_FEATURE = FEATURES.register(BiomeMakeover.ID("surface_fossil"), () -> new SurfaceFossilFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Supplier<Feature<HugeMushroomFeatureConfiguration>> HUGE_PURPLE_GLOWSHROOM_CONFIG = FEATURES.register(BiomeMakeover.ID("huge_purple_glowshroom"), () -> new HugePurpleGlowshroomFeature((Codec<HugeMushroomFeatureConfiguration>)HugeMushroomFeatureConfiguration.f_67739_));
    public static final Supplier<Feature<HugeMushroomFeatureConfiguration>> HUGE_GREEN_GLOWSHROOM_CONFIG = FEATURES.register(BiomeMakeover.ID("huge_green_glowshroom"), () -> new HugeGreenGlowshroomFeature((Codec<HugeMushroomFeatureConfiguration>)HugeMushroomFeatureConfiguration.f_67739_));
    public static final Supplier<Feature<HugeMushroomFeatureConfiguration>> HUGE_ORANGE_GLOWSHROOM_FEATURE = FEATURES.register(BiomeMakeover.ID("huge_orange_glowshroom"), () -> new HugeOrangeGlowshroomFeature((Codec<HugeMushroomFeatureConfiguration>)HugeMushroomFeatureConfiguration.f_67739_));
    public static final Supplier<Feature<ProbabilityFeatureConfiguration>> ORANGE_GLOWSHROOM_FEATURE = FEATURES.register(BiomeMakeover.ID("orange_glowshroom"), () -> new OrangeGlowshroomFeature((Codec<ProbabilityFeatureConfiguration>)ProbabilityFeatureConfiguration.f_67858_));
    public static final Supplier<Feature<VegetationPatchConfiguration>> GRASS_PATCH = FEATURES.register(BiomeMakeover.ID("grass_patch"), () -> new GrassPatchFeature((Codec<VegetationPatchConfiguration>)VegetationPatchConfiguration.f_161280_));
    public static final Supplier<Feature<NoneFeatureConfiguration>> PEAT_FEATURE = FEATURES.register(BiomeMakeover.ID("peat"), () -> new PeatFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Supplier<Feature<NoneFeatureConfiguration>> REED_FEATURE = FEATURES.register(BiomeMakeover.ID("reeds"), () -> new ReedFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final Supplier<Feature<FissureFeature.FissureConfig>> FISSURE = FEATURES.register(BiomeMakeover.ID("fissure"), () -> new FissureFeature(FissureFeature.FissureConfig.CODEC));
    public static final Supplier<FoliagePlacerType<WillowFoliagePlacer>> WILLOW_FOLIAGE = FOLIAGE.register(BiomeMakeover.ID("willow_foliage"), () -> new FoliagePlacerType(WillowFoliagePlacer.CODEC));
    public static final Supplier<TreeDecoratorType<HangingLeavesDecorator>> HANGING_LEAVES_DECORATOR = DECORATOR.register(BiomeMakeover.ID("hanging_leaves_decorator"), () -> new TreeDecoratorType(HangingLeavesDecorator.CODEC));
    public static final Supplier<TreeDecoratorType<WillowingBranchDecorator>> WILLOWING_BRANCH_DECORATOR = DECORATOR.register(BiomeMakeover.ID("willowing_branch_decorator"), () -> new TreeDecoratorType(WillowingBranchDecorator.CODEC));
    public static final Supplier<TreeDecoratorType<IvyDecorator>> IVY_DECORATOR = DECORATOR.register(BiomeMakeover.ID("ivy"), () -> new TreeDecoratorType(IvyDecorator.CODEC));
    public static final TagKey<Biome> HAS_REWORKED_MANSION = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)BiomeMakeover.ID("has_structure/reworked_mansion"));
    public static final RegistrySupplier<TrunkPlacerType<AncientOakTrunkPlacer>> ANCIENT_OAK_TRUNK = TRUNK.register(BiomeMakeover.ID("ancient_oak"), () -> new TrunkPlacerType(AncientOakTrunkPlacer.CODEC));
    public static final RegistrySupplier<TrunkPlacerType<CypressTrunkPlacer>> CYPRESS_TRUNK = TRUNK.register(BiomeMakeover.ID("swamp_cypress"), () -> new TrunkPlacerType(CypressTrunkPlacer.CODEC));
    public static final RegistrySupplier<TrunkPlacerType<WillowTrunkPlacer>> WILLOW_TRUNK = TRUNK.register(BiomeMakeover.ID("willow"), () -> new TrunkPlacerType(WillowTrunkPlacer.CODEC));
    public static final RegistrySupplier<TrunkPlacerType<BalsaTrunkPlacer>> BLIGHTED_BALSA_TRUNK = TRUNK.register(BiomeMakeover.ID("blighted_balsa"), () -> new TrunkPlacerType(BalsaTrunkPlacer.CODEC));
    public static TagKey<Biome> DARK_FOREST_BIOMES = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)BiomeMakeover.ID("dark_forest"));
    public static TagKey<Biome> SWAMP_BIOMES = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)BiomeMakeover.ID("swamps"));
    public static TagKey<Biome> BADLANDS_BIOMES = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)BiomeMakeover.ID("badlands"));
    public static TagKey<Biome> MUSHROOM_FIELD_BIOMES = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)BiomeMakeover.ID("mushroom_fields"));
    public static TagKey<Biome> BEACH_BIOMES = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)BiomeMakeover.ID("beaches"));
    public static TagKey<Biome> HAS_TUMBLEWEED = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)BiomeMakeover.ID("spawns_tumbleweed"));
    public static TagKey<Biome> SWAMP_BONEMEAL = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)BiomeMakeover.ID("swamp_bonemeal"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> SINGLE_DARK_OAK_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)BiomeMakeover.ID("dark_forest/dark_oak_small"));

    public static void init() {
        FEATURES.register();
        FOLIAGE.register();
        DECORATOR.register();
        TRUNK.register();
        BiomeModifications.addProperties(biomeContext -> biomeContext.hasTag(MUSHROOM_FIELD_BIOMES), (biomeContext, mutable) -> {
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, BMFeatures.key("mushroom_fields/underground_mycelium"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.FLUID_SPRINGS, BMFeatures.key("mushroom_fields/blighted_balsa_trees"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("mushroom_fields/green_glowshrooms"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("mushroom_fields/purple_glowshrooms"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("mushroom_fields/orange_glowshrooms"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("mushroom_fields/mycelium_sprouts"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("mushroom_fields/mycelium_roots"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("mushroom_fields/underground_huge_glowshrooms"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("mushroom_fields/tall_brown_mushrooms"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("mushroom_fields/tall_red_mushrooms"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("mushroom_fields/wild_mushrooms"));
        });
        BiomeModifications.addProperties(biomeContext -> biomeContext.hasTag(BADLANDS_BIOMES), (biomeContext, mutable) -> {
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("badlands/barrel_cactus"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("badlands/saguaro_cactus"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, BMFeatures.key("badlands/paydirt"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, BMFeatures.key("badlands/surface_fossil"));
        });
        BiomeModifications.removeProperties(p -> p.hasTag(SWAMP_BIOMES), (biomeContext, mutable) -> mutable.getGenerationProperties().removeFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("trees_swamp"))));
        BiomeModifications.addProperties(biomeContext -> biomeContext.hasTag(SWAMP_BIOMES), (biomeContext, mutable) -> {
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("swamp/swamp_cypress_trees"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("swamp/willow_trees"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("swamp/big_mushrooms"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("swamp/flowers"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("swamp/pads"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, BMFeatures.key("swamp/peat"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, BMFeatures.key("swamp/reeds"));
        });
        BiomeModifications.addProperties(biomeContext -> biomeContext.hasTag(DARK_FOREST_BIOMES), (biomeContext, mutable) -> {
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("dark_forest/grass"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("dark_forest/tall_grass"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, BMFeatures.key("dark_forest/flowers"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, BMFeatures.key("dark_forest/itching_ivy"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, BMFeatures.key("dark_forest/trees"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, BMFeatures.key("dark_forest/wild_mushrooms"));
            mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, BMFeatures.key("dark_forest/mesmerite_fissure"));
        });
    }

    private static ResourceKey<PlacedFeature> key(String id) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)BiomeMakeover.ID(id));
    }
}

