/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render.forge;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraftforge.client.ForgeHooksClient;
import party.lemons.biomemakeover.entity.HelmitCrabEntity;
import party.lemons.biomemakeover.entity.render.HelmitCrabRender;

public class HelmitCrabRenderHelmitCrabShellRenderLayerImpl {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();

    public static Model getHelmetModel(HelmitCrabEntity entity, HumanoidModel bipedModel, ItemStack stack) {
        Model model = ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)stack, (EquipmentSlot)EquipmentSlot.HEAD, (HumanoidModel)bipedModel);
        return model;
    }

    public static void renderHelmetPlatform(HelmitCrabEntity entity, ItemStack stack, PoseStack matrices, MultiBufferSource vertexConsumers, int light, HumanoidModel baseModel) {
        matrices.m_85836_();
        Model model = HelmitCrabRenderHelmitCrabShellRenderLayerImpl.getHelmetModel(entity, baseModel, stack);
        if (model instanceof HumanoidModel) {
            matrices.m_85837_(0.0, 0.65, 0.05);
            matrices.m_85841_(1.1f, 1.0f, 1.0f);
        } else {
            matrices.m_252781_(Axis.f_252495_.m_252977_(10.0f));
            matrices.m_85837_(0.0, 1.5, 0.3);
        }
        ArmorItem armorItem = (ArmorItem)stack.m_41720_();
        if (armorItem instanceof DyeableLeatherItem) {
            DyeableLeatherItem dyeable = (DyeableLeatherItem)armorItem;
            int color = dyeable.m_41121_(stack);
            float dyeRed = (float)(color >> 16 & 0xFF) / 255.0f;
            float dyeGreen = (float)(color >> 8 & 0xFF) / 255.0f;
            float dyeBlue = (float)(color & 0xFF) / 255.0f;
            HelmitCrabRenderHelmitCrabShellRenderLayerImpl.renderModel(matrices, vertexConsumers, light, armorItem, model, false, dyeRed, dyeGreen, dyeBlue, HelmitCrabRenderHelmitCrabShellRenderLayerImpl.getArmorResource((Entity)entity, stack, EquipmentSlot.HEAD, null));
            HelmitCrabRenderHelmitCrabShellRenderLayerImpl.renderModel(matrices, vertexConsumers, light, armorItem, model, false, 1.0f, 1.0f, 1.0f, HelmitCrabRenderHelmitCrabShellRenderLayerImpl.getArmorResource((Entity)entity, stack, EquipmentSlot.HEAD, "overlay"));
        } else {
            HelmitCrabRenderHelmitCrabShellRenderLayerImpl.renderModel(matrices, vertexConsumers, light, armorItem, model, false, 1.0f, 1.0f, 1.0f, HelmitCrabRenderHelmitCrabShellRenderLayerImpl.getArmorResource((Entity)entity, stack, EquipmentSlot.HEAD, null));
        }
        ArmorTrim.m_266285_((RegistryAccess)entity.m_9236_().m_9598_(), (ItemStack)stack).ifPresent(arg3x -> HelmitCrabRender.renderTrim(armorItem.m_40401_(), matrices, vertexConsumers, light, arg3x, model, false));
        if (stack.m_41790_()) {
            model.m_7695_(matrices, vertexConsumers.m_6299_(RenderType.m_110484_()), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrices.m_85849_();
    }

    private static void renderModel(PoseStack arg, MultiBufferSource arg2, int i, ArmorItem arg3, Model arg4, boolean bl, float f, float g, float h, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = arg2.m_6299_(RenderType.m_110431_((ResourceLocation)armorResource));
        arg4.m_7695_(arg, vertexconsumer, i, OverlayTexture.f_118083_, f, g, h, 1.0f);
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

