/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.adjudicator.phase;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorEntity;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorState;
import party.lemons.biomemakeover.entity.adjudicator.phase.TimedPhase;
import party.lemons.biomemakeover.util.effect.BiomeMakeoverEffect;
import party.lemons.biomemakeover.util.effect.EffectHelper;
import party.lemons.biomemakeover.util.extension.GoalSelectorExtension;
import party.lemons.biomemakeover.util.extension.LootBlocker;

public class SummonPhase
extends TimedPhase {
    private final int mobCount;
    protected final EntityType<? extends LivingEntity>[] entities;
    protected int toSpawn;
    private BlockPos[] spawnPositions;
    int spawnIndex = 0;
    private boolean wasHit;

    public SummonPhase(ResourceLocation id, AdjudicatorEntity adjudicator, int mobCount, EntityType<? extends LivingEntity> ... entities) {
        super(id, 120, adjudicator);
        this.mobCount = mobCount;
        this.entities = entities;
    }

    @Override
    protected void initAI() {
    }

    @Override
    public void onEnterPhase() {
        super.onEnterPhase();
        this.toSpawn = this.mobCount;
        this.spawnIndex = 0;
        this.wasHit = false;
        this.adjudicator.setState(AdjudicatorState.SUMMONING);
        this.populateSpawnPositions();
        this.adjudicator.m_5496_(SoundEvents.f_11868_, 1.0f, 1.0f);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.time % (this.maxTime / this.mobCount) == 0) {
            this.spawnEntity();
            ++this.spawnIndex;
        }
        for (int i = this.spawnIndex; i < this.mobCount; ++i) {
            EffectHelper.doEffect(this.level, BiomeMakeoverEffect.BLOCK_ENDER_PARTICLES, this.spawnPositions[i]);
        }
    }

    @Override
    public void onHurt(DamageSource source, float amount) {
        super.onHurt(source, amount);
        if (source.m_7639_() instanceof Player) {
            this.wasHit = true;
        }
    }

    @Override
    public void onExitPhase() {
        super.onExitPhase();
        if (!this.wasHit) {
            for (int i = this.spawnIndex; i < this.mobCount; ++i) {
                this.spawnEntity();
            }
        }
    }

    @Override
    public boolean isPhaseOver() {
        return this.spawnIndex >= this.spawnPositions.length || this.wasHit || super.isPhaseOver();
    }

    protected void spawnEntity() {
        LivingEntity entity;
        BlockPos spawnPos = this.spawnPositions[this.spawnIndex];
        if (this.level.m_8055_(spawnPos.m_7495_()).m_60795_()) {
            this.level.m_7731_(spawnPos.m_7495_(), Blocks.f_50652_.m_49966_(), 3);
        }
        if ((entity = (LivingEntity)this.entities[this.random.m_188503_(this.entities.length)].m_20615_(this.level)) instanceof Mob) {
            ((Mob)entity).m_6518_((ServerLevelAccessor)this.level, this.level.m_6436_(spawnPos), MobSpawnType.EVENT, null, null);
        }
        ((LootBlocker)entity).setLootBlocked(true);
        entity.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
        this.level.m_7967_((Entity)entity);
        this.adjudicator.clearArea((Entity)entity);
        if (entity instanceof Evoker) {
            GoalSelectorExtension.removeGoal(entity, Evoker.EvokerSummonSpellGoal.class);
        }
        this.level.m_5594_(null, spawnPos, SoundEvents.f_11862_, SoundSource.HOSTILE, 10.0f, 1.0f);
    }

    @Override
    public void fromTag(CompoundTag tag) {
        this.spawnIndex = tag.m_128451_("SpawnIndex");
        this.populateSpawnPositions();
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag tag = super.toTag();
        tag.m_128405_("SpawnIndex", this.spawnIndex);
        return tag;
    }

    private void populateSpawnPositions() {
        this.spawnPositions = new BlockPos[this.mobCount];
        for (int i = 0; i < this.mobCount; ++i) {
            BlockPos spawnPos;
            this.spawnPositions[i] = spawnPos = this.adjudicator.findSuitableArenaPos();
        }
    }

    @Override
    public boolean isSelectable() {
        return this.level.m_6443_(Monster.class, this.adjudicator.getArenaBounds(), EntitySelector.f_20403_).size() < 4;
    }
}

