/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.adjudicator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorRoomListener;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorState;
import party.lemons.biomemakeover.entity.adjudicator.AdjudicatorStateProvider;
import party.lemons.biomemakeover.entity.adjudicator.RavagerChargePhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.AdjudicatorPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.BowAttackingPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.FangAttackingPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.FangBarragePhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.IdleAdjudicatorPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.MeleeAttackingPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.MimicPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.StoneGolemPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.SummonPhase;
import party.lemons.biomemakeover.entity.adjudicator.phase.TeleportingPhase;
import party.lemons.biomemakeover.entity.event.EntityEventBroadcaster;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.util.NBTUtil;
import party.lemons.biomemakeover.util.extension.GoalSelectorExtension;
import party.lemons.taniwha.entity.golem.PlayerCreatable;
import party.lemons.taniwha.util.ItemUtil;

public class AdjudicatorEntity
extends Monster
implements PowerableMob,
AdjudicatorStateProvider,
RangedAttackMob,
CrossbowAttackMob,
EntityEventBroadcaster {
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(AdjudicatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(AdjudicatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> INVULNERABLE = SynchedEntityData.m_135353_(AdjudicatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final Map<ResourceLocation, AdjudicatorPhase> PHASES = Maps.newHashMap();
    public final AdjudicatorPhase IDLE = new IdleAdjudicatorPhase(BiomeMakeover.ID("idle"), this);
    public final TeleportingPhase TELEPORT = new TeleportingPhase(BiomeMakeover.ID("teleport"), this);
    public final BowAttackingPhase BOW_ATTACK = new BowAttackingPhase(BiomeMakeover.ID("bow_attack"), this);
    public final MeleeAttackingPhase MELEE_ATTACK = new MeleeAttackingPhase(BiomeMakeover.ID("melee_attack"), this);
    public final FangAttackingPhase FANG_ATTACK = new FangAttackingPhase(BiomeMakeover.ID("fang_attack"), this);
    public final RavagerChargePhase RAVAGER = new RavagerChargePhase(BiomeMakeover.ID("ravager"), this);
    public final SummonPhase SPAWN_EVOKERS = new SummonPhase(BiomeMakeover.ID("spawn_evoker"), this, 2, EntityType.f_20568_);
    public final SummonPhase SPAWN_VINDICATORS = new SummonPhase(BiomeMakeover.ID("spawn_vindicator"), this, 6, EntityType.f_20493_);
    public final SummonPhase SPAWN_VEX = new SummonPhase(BiomeMakeover.ID("spawn_vex"), this, 2, EntityType.f_20491_);
    public final SummonPhase SPAWN_MIX = new SummonPhase(BiomeMakeover.ID("spawn_mix"), this, 3, EntityType.f_20491_, EntityType.f_20493_, EntityType.f_20568_, EntityType.f_20513_);
    public final MimicPhase MIMIC = new MimicPhase(BiomeMakeover.ID("mimic"), this);
    public final FangBarragePhase FANG_BARAGE = new FangBarragePhase(BiomeMakeover.ID("fang_barrage"), this);
    public final StoneGolemPhase STONE_GOLEM = new StoneGolemPhase(BiomeMakeover.ID("stone_golem"), this);
    private final ServerBossEvent bossBar;
    private AdjudicatorPhase phase;
    private boolean active = false;
    private BlockPos homePos;
    private boolean firstTick = true;
    private AABB roomBounds;
    private List<BlockPos> arenaPositions;
    public int stateTime = 0;
    private int finishFightTime = 0;
    public float renderRotPrevious = 0.0f;
    private final TargetingConditions targetPredicate = TargetingConditions.m_148352_().m_26883_(32.0);

    public AdjudicatorEntity(EntityType<? extends AdjudicatorEntity> entityType, Level level) {
        super(entityType, level);
        this.bossBar = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
        this.m_21153_(this.m_21233_());
        this.m_21573_().m_7008_(true);
        this.f_21364_ = 50;
        this.setPhase(this.IDLE);
    }

    protected void m_8099_() {
        super.m_8099_();
        AdjudicatorRoomListener.enableAdjudicator(this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(STATE, (Object)0);
        this.m_20088_().m_135372_(CHARGING, (Object)false);
        this.m_20088_().m_135372_(INVULNERABLE, (Object)false);
    }

    public void m_8119_() {
        ++this.stateTime;
        if (!this.m_9236_().m_5776_() && this.firstTick) {
            this.homePos = this.m_20183_();
            this.roomBounds = new AABB(this.homePos.m_6625_(4)).m_82377_(13.0, 0.0, 13.0).m_82363_(0.0, 13.0, 0.0);
            this.firstTick = false;
            this.arenaPositions = Lists.newArrayList();
            this.arenaPositions.add(this.homePos);
            BlockPos.m_121976_((int)((int)this.roomBounds.f_82288_), (int)((int)this.roomBounds.f_82289_), (int)((int)this.roomBounds.f_82290_), (int)((int)this.roomBounds.f_82291_), (int)((int)this.roomBounds.f_82292_), (int)((int)this.roomBounds.f_82293_)).forEach(b -> {
                if (this.m_9236_().m_8055_(b).m_60713_(Blocks.f_50472_)) {
                    this.m_9236_().m_7731_(b, Blocks.f_50016_.m_49966_(), 3);
                    this.arenaPositions.add(b.m_7949_());
                }
            });
        }
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.phase != null) {
            this.phase.tick();
            if (this.phase.isPhaseOver()) {
                this.setPhase(this.phase.getNextPhase());
            }
        }
        this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
        this.tickCastParticles();
        if (!this.m_9236_().m_5776_() && !this.getArenaBounds().m_82390_(this.m_20182_())) {
            this.m_8127_();
            this.teleportHome();
        }
        this.updatePlayers();
    }

    private void tickCastParticles() {
        if (this.m_9236_().f_46443_ && this.isCasting()) {
            double b;
            double g;
            double r;
            if (this.getState() == AdjudicatorState.TELEPORT) {
                r = 0.6196078658103943;
                g = 0.23529411852359772;
                b = 0.7607843279838562;
            } else {
                r = 0.5686274766921997;
                g = 0.5686274766921997;
                b = 0.5686274766921997;
            }
            float angle = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float xOffset = Mth.m_14089_((float)angle);
            float zOffset = Mth.m_14031_((float)angle);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)xOffset * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)zOffset * 0.6, r, g, b);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)xOffset * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)zOffset * 0.6, r, g, b);
        }
    }

    private void updatePlayers() {
        if (!this.active || this.m_9236_().m_5776_()) {
            return;
        }
        List players = this.m_9236_().m_6443_(Player.class, this.getArenaBounds(), EntitySelector.f_20408_);
        if (players.isEmpty()) {
            ++this.finishFightTime;
            if (this.finishFightTime > 350) {
                this.teleportHome();
                this.finishFightTime = 0;
                this.setState(AdjudicatorState.WAITING);
                this.setPhase(this.IDLE);
                this.active = false;
            }
        } else {
            this.finishFightTime = 0;
        }
        List playersWithSpectator = this.m_9236_().m_6443_(Player.class, this.getArenaBounds(), p -> true);
        ArrayList toRemove = Lists.newArrayList();
        for (ServerPlayer playerEntity : this.bossBar.m_8324_()) {
            if (playersWithSpectator.contains(playerEntity)) continue;
            toRemove.add(playerEntity);
        }
        toRemove.forEach(arg_0 -> ((ServerBossEvent)this.bossBar).m_6539_(arg_0));
        for (ServerPlayer playerEntity : playersWithSpectator) {
            if (this.bossBar.m_8324_().contains(playerEntity)) continue;
            this.bossBar.m_6543_(playerEntity);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (!this.active) {
            this.active = true;
        }
        if (this.phase != null) {
            this.phase.onHurt(damageSource, amount);
        }
        return super.m_6469_(damageSource, amount);
    }

    public boolean m_21275_(DamageSource damageSource) {
        if (this.active && this.phase == null) {
            this.setPhase(this.TELEPORT);
            return true;
        }
        if (this.phase == this.IDLE && !(damageSource.m_7639_() instanceof Player)) {
            return true;
        }
        if (this.phase.isInvulnerable() && !damageSource.m_269533_(DamageTypeTags.f_268738_)) {
            return true;
        }
        return super.m_21275_(damageSource);
    }

    protected void m_7625_(DamageSource damageSource, boolean causedByPlayer) {
        LootTable lootTable = this.m_9236_().m_7654_().m_278653_().m_278676_(this.m_5743_());
        LootParams.Builder context = new LootParams.Builder((ServerLevel)this.m_9236_());
        lootTable.m_287228_(context.m_287235_(LootContextParamSets.f_81410_), i -> {
            ItemEntity item = this.m_19983_((ItemStack)i);
            if (item != null) {
                item.m_32064_();
            }
        });
    }

    private void setPhase(AdjudicatorPhase phase) {
        if (this.phase != null) {
            this.phase.onExitPhase();
        }
        this.phase = phase;
        if (this.phase != null) {
            this.phase.onEnterPhase();
            this.setUpPhase();
        }
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (data == STATE) {
            this.stateTime = 0;
            this.renderRotPrevious = 0.0f;
            this.f_19854_ = this.m_20185_();
            this.f_19855_ = this.m_20186_();
            this.f_19856_ = this.m_20189_();
            this.f_19790_ = this.m_20185_();
            this.f_19791_ = this.m_20186_();
            this.f_19792_ = this.m_20189_();
        }
        super.m_7350_(data);
    }

    public void m_6667_(DamageSource damageSource) {
        if (this.phase != null) {
            this.phase.onExitPhase();
        }
        this.active = false;
        this.bossBar.m_7706_();
        this.bossBar.m_8321_(false);
        super.m_6667_(damageSource);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossBar.m_6539_(serverPlayer);
    }

    private void setUpPhase() {
        this.m_21573_().m_26573_();
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        GoalSelectorExtension.copy(this.f_21345_, this.phase.getGoalSelector());
        GoalSelectorExtension.copy(this.f_21346_, this.phase.getTargetSelector());
        this.bossBar.m_8321_(this.phase.showBossBar());
        this.m_20088_().m_135381_(INVULNERABLE, (Object)this.phase.isInvulnerable());
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("FirstTick", this.firstTick);
        tag.m_128379_("BossActive", this.active);
        if (this.homePos != null) {
            NBTUtil.writeBlockPos(this.homePos, tag);
        }
        if (this.roomBounds != null) {
            NBTUtil.writeBox(this.roomBounds, tag);
        }
        if (this.arenaPositions != null) {
            ListTag arenaPosTags = new ListTag();
            for (BlockPos pos : this.arenaPositions) {
                arenaPosTags.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            tag.m_128365_("ArenaPositions", (Tag)arenaPosTags);
        }
        if (this.phase == null) {
            this.phase = this.IDLE;
        }
        tag.m_128359_("Phase", this.phase.getPhaseID().toString());
        tag.m_128365_("PhaseData", (Tag)this.phase.toTag());
        tag.m_128405_("State", this.getState().ordinal());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.firstTick = tag.m_128471_("FirstTick");
        this.active = tag.m_128471_("BossActive");
        this.homePos = NBTUtil.readBlockPos(tag);
        this.roomBounds = NBTUtil.readBox(tag);
        if (tag.m_128441_("ArenaPositions")) {
            ListTag arenaTags = tag.m_128437_("ArenaPositions", 10);
            this.arenaPositions = Lists.newArrayList();
            for (int i = 0; i < arenaTags.size(); ++i) {
                this.arenaPositions.add(NbtUtils.m_129239_((CompoundTag)arenaTags.m_128728_(i)));
            }
        }
        ResourceLocation phaseID = new ResourceLocation(tag.m_128461_("Phase"));
        AdjudicatorPhase adjPhase = this.PHASES.get(phaseID);
        adjPhase.fromTag(tag.m_128469_("PhaseData"));
        this.phase = adjPhase;
        this.setUpPhase();
        this.setState(AdjudicatorState.values()[tag.m_128451_("State")]);
    }

    public void selectTarget(Class<? extends LivingEntity> targetClass) {
        Object targetEntity = null;
        targetEntity = targetClass != Player.class && targetClass != ServerPlayer.class ? this.m_9236_().m_45963_(targetClass, this.targetPredicate, (LivingEntity)this, this.m_20185_(), this.m_20188_(), this.m_20189_(), this.getArenaBounds()) : this.m_9236_().m_45949_(this.targetPredicate, (LivingEntity)this, this.m_20185_(), this.m_20188_(), this.m_20189_());
        if (targetEntity != null) {
            this.m_6710_((LivingEntity)targetEntity);
        }
    }

    public void setActive() {
        this.active = true;
    }

    public BlockPos getHomePosition() {
        return this.homePos;
    }

    protected SoundEvent m_7515_() {
        return this.isActive() ? BMEffects.ADJUDICATOR_LAUGH.get() : BMEffects.ADJUDICATOR_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        if (this.phase != null && this.phase.isInvulnerable()) {
            return null;
        }
        return BMEffects.ADJUDICATOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return BMEffects.ADJUDICATOR_DEATH.get();
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossBar.m_6456_(this.m_5446_());
    }

    public void m_7601_(BlockState blockState, Vec3 vec3) {
    }

    public void m_6043_() {
        this.f_20891_ = 0;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    public BlockPos findSuitableArenaPos() {
        BlockPos arenaPos;
        if (this.arenaPositions == null || this.arenaPositions.isEmpty()) {
            return this.m_20183_();
        }
        int safety = 0;
        while ((arenaPos = this.arenaPositions.get(this.f_19796_.m_188503_(this.arenaPositions.size()))).m_123314_((Vec3i)this.m_20097_(), 1.0) && ++safety < 100) {
        }
        return arenaPos;
    }

    @Override
    public AdjudicatorState getState() {
        return AdjudicatorState.values()[(Integer)this.m_20088_().m_135370_(STATE) % AdjudicatorState.values().length];
    }

    public void setState(AdjudicatorState state) {
        this.m_20088_().m_135381_(STATE, (Object)state.ordinal());
        this.stateTime = 0;
    }

    public void teleportToRandomArenaPos() {
        this.teleportTo(this.findSuitableArenaPos());
    }

    public void teleportHome() {
        this.teleportTo(this.homePos);
    }

    public void teleportTo(BlockPos pos) {
        if (this.m_9236_().m_8055_(pos.m_7495_()).m_60795_()) {
            this.m_9236_().m_7731_(pos.m_7495_(), Blocks.f_50652_.m_49966_(), 3);
        }
        this.m_6027_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 1.0f, (float)pos.m_123343_() + 0.5f);
        this.clearArea((Entity)this);
    }

    public void clearArea(Entity e) {
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            AABB hitBox = e.m_20191_();
            this.destroyArea(hitBox);
            if (e.m_5830_()) {
                hitBox = hitBox.m_82400_(1.0);
                this.destroyArea(hitBox);
            }
        }
    }

    private void destroyArea(AABB hitBox) {
        BlockPos.m_121940_((BlockPos)new BlockPos((int)hitBox.f_82288_, (int)hitBox.f_82289_, (int)hitBox.f_82290_), (BlockPos)new BlockPos((int)hitBox.f_82291_, (int)hitBox.f_82292_, (int)hitBox.f_82293_)).forEach(b -> {
            if (WitherBoss.m_31491_((BlockState)this.m_9236_().m_8055_(b))) {
                this.m_9236_().m_46953_(b, true, (Entity)this);
                this.m_9236_().m_5898_(null, 1022, b, 0);
            }
        });
    }

    public boolean isCasting() {
        AdjudicatorState state = this.getState();
        return state == AdjudicatorState.SUMMONING || state == AdjudicatorState.TELEPORT;
    }

    public AABB getArenaBounds() {
        return this.roomBounds;
    }

    public boolean m_7090_() {
        return (Boolean)this.m_20088_().m_135370_(INVULNERABLE);
    }

    public void m_6136_(boolean bl) {
        this.m_20088_().m_135381_(CHARGING, (Object)bl);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.m_20088_().m_135370_(CHARGING);
    }

    public void m_5811_(LivingEntity target, ItemStack itemStack, Projectile projectile, float multiShotSpray) {
        this.m_32322_((LivingEntity)this, target, projectile, multiShotSpray, 1.6f);
    }

    public void m_5847_() {
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        AdjudicatorRoomListener.disableAdjudicator(this);
    }

    public boolean m_6779_(LivingEntity target) {
        if (this.m_20202_() == target) {
            return false;
        }
        if (target instanceof PlayerCreatable && !((PlayerCreatable)target).isPlayerCreated()) {
            return false;
        }
        return super.m_6779_(target);
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        if (this.m_21205_().m_41720_() instanceof CrossbowItem) {
            this.m_32336_((LivingEntity)this, 2.0f);
        } else {
            ItemStack arrowTypeStack = this.m_6298_(this.m_21120_(ItemUtil.getHandPossiblyHolding((LivingEntity)this, i -> i.m_41720_() instanceof BowItem)));
            AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowTypeStack, (float)pullProgress);
            double distanceX = target.m_20185_() - this.m_20185_();
            double distanceY = target.m_20227_((double)0.333f) - arrow.m_20186_();
            double distanceZ = target.m_20189_() - this.m_20189_();
            double arc = Math.sqrt(distanceX * distanceX + distanceZ * distanceZ);
            arrow.m_6686_(distanceX, distanceY + arc * (double)0.2f, distanceZ, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
            this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.m_9236_().m_7967_((Entity)arrow);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AdjudicatorEntity.m_33035_().m_22268_(Attributes.f_22276_, 255.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0);
    }
}

