/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import party.lemons.biomemakeover.init.BMBlocks;
import party.lemons.biomemakeover.init.BMItems;
import party.lemons.taniwha.block.types.TBlock;

public class BarrelCactusBlock
extends TBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0);
    private final boolean flowered;

    public BarrelCactusBlock(boolean flowered, BlockBehaviour.Properties properties) {
        super(properties);
        this.flowered = flowered;
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockState checkState = levelReader.m_8055_(blockPos.m_7495_());
        return checkState.m_204336_(BMBlocks.BARREL_CACTUS_PLANTABLE);
    }

    public boolean m_8133_(BlockState blockState, Level level, BlockPos blockPos, int i, int j) {
        for (int m = 0; m < 15; ++m) {
            int dirX = level.m_213780_().m_188503_(2) * 2 - 1;
            int dirY = level.m_213780_().m_188503_(2) * 2 - 1;
            int dirZ = level.m_213780_().m_188503_(2) * 2 - 1;
            Vec3 pos = blockPos.m_252807_();
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), pos.f_82479_ + (double)((float)dirX * 0.1f), pos.f_82480_ - (double)0.15f + (double)((float)dirY * 0.1f), pos.f_82481_ + (double)((float)dirZ * 0.1f), 0.0, 0.0, 0.0);
        }
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos posFrom) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        return state;
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (!blockState.m_60710_((LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46961_(blockPos, true);
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (!entity.m_20161_()) {
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                if (entity.f_19797_ < 120 || itemEntity.m_32055_().m_204117_(BMItems.BARREL_CACTUS_IMMUNE)) {
                    return;
                }
            }
            entity.m_6469_(level.m_269111_().m_269325_(), 1.0f);
        }
        super.m_7892_(blockState, level, blockPos, entity);
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (!this.flowered && serverLevel.m_45524_(blockPos, 0) >= 9 && random.m_188503_(7) == 0) {
            serverLevel.m_7731_(blockPos, ((Block)BMBlocks.BARREL_CACTUS_FLOWERED.get()).m_49966_(), 3);
        }
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public BlockPathTypes getNodePathType() {
        return BlockPathTypes.DAMAGE_OTHER;
    }
}

