/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunky.util.Parameter;

public class TaskLoader {
    private final Chunky chunky;
    private final Path savePath;
    private final Map<String, Properties> tasks = new ConcurrentHashMap<String, Properties>();

    public TaskLoader(Chunky chunky) {
        this.chunky = chunky;
        this.savePath = chunky.getConfig().getDirectory().resolve("tasks");
        this.reload();
    }

    public void reload() {
        try {
            Files.createDirectories(this.savePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (Stream<Path> taskWalker = Files.walk(this.savePath, new FileVisitOption[0]);){
            taskWalker.forEach(task -> {
                if (task.getFileName().toString().endsWith(".properties")) {
                    try (InputStream input = Files.newInputStream(task, new OpenOption[0]);){
                        Properties properties = new Properties();
                        properties.load(input);
                        String world = properties.getProperty("world");
                        if (world != null) {
                            this.tasks.put(world, properties);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Optional<GenerationTask> loadTask(World world) {
        Properties task = this.tasks.get(world.getName());
        if (task == null) {
            return Optional.empty();
        }
        boolean cancelled = Input.tryBoolean(task.getProperty(TaskProperty.CANCELLED.key())).orElse(false);
        double centerX = Input.tryDouble(task.getProperty(TaskProperty.CENTER_X.key())).orElse(0.0);
        double centerZ = Input.tryDouble(task.getProperty(TaskProperty.CENTER_Z.key())).orElse(0.0);
        double radiusX = Input.tryDouble(task.getProperty(TaskProperty.RADIUS_X.key())).orElse(500.0);
        double radiusZ = Input.tryDouble(task.getProperty(TaskProperty.RADIUS_Z.key())).orElse(radiusX);
        String pattern = task.getProperty(TaskProperty.PATTERN.key(), "region");
        String file = task.getProperty(TaskProperty.CSV.key());
        String shape = task.getProperty(TaskProperty.SHAPE.key(), "square");
        Selection.Builder selection = Selection.builder(this.chunky, world).centerX(centerX).centerZ(centerZ).radiusX(radiusX).radiusZ(radiusZ).pattern(Parameter.of(pattern, file)).shape(shape);
        long chunks = Input.tryLong(task.getProperty(TaskProperty.CHUNKS.key())).orElse(0L);
        long time = Input.tryLong(task.getProperty(TaskProperty.TIME.key())).orElse(0L);
        return Optional.of(new GenerationTask(this.chunky, selection.build(), chunks, time, cancelled));
    }

    public List<GenerationTask> loadTasks() {
        ArrayList<GenerationTask> generationTasks = new ArrayList<GenerationTask>();
        for (World world : this.chunky.getServer().getWorlds()) {
            this.loadTask(world).ifPresent(generationTasks::add);
        }
        return generationTasks;
    }

    public void saveTask(GenerationTask task) {
        Selection selection = task.getSelection();
        String world = selection.world().getName();
        Properties properties = this.tasks.getOrDefault(world, new Properties());
        properties.setProperty(TaskProperty.WORLD.key(), world);
        properties.setProperty(TaskProperty.CANCELLED.key(), String.valueOf(task.isCancelled()));
        properties.setProperty(TaskProperty.CENTER_X.key(), String.valueOf(selection.centerX()));
        properties.setProperty(TaskProperty.CENTER_Z.key(), String.valueOf(selection.centerZ()));
        properties.setProperty(TaskProperty.RADIUS_X.key(), String.valueOf(selection.radiusX()));
        String shape = task.getShape().name();
        if ("rectangle".equals(shape) || "ellipse".equals(shape)) {
            properties.setProperty(TaskProperty.RADIUS_Z.key(), String.valueOf(selection.radiusZ()));
        }
        String pattern = task.getChunkIterator().name();
        properties.setProperty(TaskProperty.PATTERN.key(), pattern);
        if ("csv".equals(pattern)) {
            task.getSelection().pattern().getValue().ifPresent(file -> properties.setProperty(TaskProperty.CSV.key(), (String)file));
        }
        properties.setProperty(TaskProperty.SHAPE.key(), shape);
        properties.setProperty(TaskProperty.CHUNKS.key(), String.valueOf(task.getCount()));
        properties.setProperty(TaskProperty.TIME.key(), String.valueOf(task.getTotalTime()));
        this.tasks.put(world, properties);
        this.writeTask(world, properties);
    }

    public void saveTasks() {
        for (GenerationTask task : this.chunky.getGenerationTasks().values()) {
            this.saveTask(task);
        }
    }

    public void cancelTask(World world) {
        this.loadTask(world).ifPresent(generationTask -> {
            generationTask.stop(true);
            this.saveTask((GenerationTask)generationTask);
        });
    }

    public void cancelTasks() {
        this.loadTasks().forEach(generationTask -> this.cancelTask(generationTask.getSelection().world()));
    }

    private void writeTask(String world, Properties properties) {
        StringBuilder propertiesBuilder = new StringBuilder();
        for (TaskProperty taskProperty : TaskProperty.values()) {
            String propertyValue = properties.getProperty(taskProperty.key());
            if (propertyValue == null) continue;
            propertiesBuilder.append(taskProperty.key()).append('=').append(propertyValue).append('\n');
        }
        String taskFileName = world.replace(':', '/') + ".properties";
        Path taskPath = this.savePath.resolve(taskFileName);
        try {
            Files.createDirectories(taskPath.getParent(), new FileAttribute[0]);
            Files.write(taskPath, propertiesBuilder.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static enum TaskProperty {
        WORLD("world"),
        CANCELLED("cancelled"),
        CENTER_X("center-x"),
        CENTER_Z("center-z"),
        RADIUS_X("radius"),
        RADIUS_Z("radius-z"),
        SHAPE("shape"),
        PATTERN("pattern"),
        CSV("csv"),
        CHUNKS("chunks"),
        TIME("time");

        private final String key;

        private TaskProperty(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

