/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.Keys;
import com.mrcrayfish.backpacked.client.gui.ButtonAlignment;
import com.mrcrayfish.backpacked.client.gui.screen.CustomiseBackpackScreen;
import com.mrcrayfish.backpacked.client.gui.screen.widget.MiniButton;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainerMenu;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class BackpackScreen
extends AbstractContainerScreen<BackpackContainerMenu> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("backpacked", "textures/gui/backpack.png");
    private static final Component CUSTOMISE_TOOLTIP = Component.m_237115_((String)"backpacked.button.customise.tooltip");
    private static final Component CONFIG_TOOLTIP = Component.m_237115_((String)"backpacked.button.config.tooltip");
    private final int cols;
    private final int rows;
    private final boolean owner;
    private boolean opened;

    public BackpackScreen(BackpackContainerMenu backpackContainerMenu, Inventory playerInventory, Component titleIn) {
        super((AbstractContainerMenu)backpackContainerMenu, playerInventory, titleIn);
        this.cols = backpackContainerMenu.getCols();
        this.rows = backpackContainerMenu.getRows();
        this.owner = backpackContainerMenu.isOwner();
        this.f_97726_ = 14 + Math.max(this.cols, 9) * 18;
        this.f_97727_ = 114 + this.rows * 18;
        this.f_97730_ = Math.max((this.cols * 18 - 162) / 2, 0) + 7;
        this.f_97731_ = this.rows * 18 + 17 + 4;
    }

    public void m_7856_() {
        super.m_7856_();
        if (!this.opened) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11678_, (float)0.75f, (float)1.0f));
            this.opened = true;
        }
        List<MiniButton> buttons = this.gatherButtons();
        for (int i = 0; i < buttons.size(); ++i) {
            MiniButton button = buttons.get(i);
            switch ((ButtonAlignment)((Object)Config.CLIENT.buttonAlignment.get())) {
                case LEFT: {
                    int titleWidth = this.f_96541_.f_91062_.m_92852_((FormattedText)this.f_96539_);
                    button.m_252865_(this.f_97735_ + titleWidth + 8 + 3 + i * 13);
                    break;
                }
                case RIGHT: {
                    button.m_252865_(this.f_97735_ + this.f_97726_ - 7 - 10 - (buttons.size() - 1 - i) * 13);
                }
            }
            button.m_253211_(this.f_97736_ + 5);
            this.m_142416_((GuiEventListener)button);
        }
    }

    private List<MiniButton> gatherButtons() {
        boolean canCustomise;
        ArrayList<MiniButton> buttons = new ArrayList<MiniButton>();
        boolean bl = canCustomise = this.owner && (Boolean)Config.SERVER.common.disableCustomisation.get() == false;
        if (canCustomise) {
            MiniButton customiseButton = new MiniButton(0, 0, 225, 0, CustomiseBackpackScreen.GUI_TEXTURE, onPress -> Network.getPlay().sendToServer((IMessage)new MessageRequestCustomisation()));
            customiseButton.m_257544_(Tooltip.m_257550_((Component)CUSTOMISE_TOOLTIP));
            buttons.add(customiseButton);
        }
        if (!((Boolean)Config.CLIENT.hideConfigButton.get()).booleanValue()) {
            MiniButton configButton = new MiniButton(0, 0, 235, 0, CustomiseBackpackScreen.GUI_TEXTURE, onPress -> this.openConfigScreen());
            configButton.m_257544_(Tooltip.m_257550_((Component)CONFIG_TOOLTIP));
            buttons.add(configButton);
        }
        return buttons;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        this.drawBackgroundWindow(graphics, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
    }

    private void drawBackgroundWindow(GuiGraphics graphics, int x, int y, int width, int height) {
        int backpackHeight = 17 + this.rows * 18;
        graphics.m_280411_(GUI_TEXTURE, x, y, 7, backpackHeight, 0.0f, 0.0f, 7, backpackHeight, 256, 256);
        graphics.m_280411_(GUI_TEXTURE, x + width - 7, y, 7, backpackHeight, 8.0f, 0.0f, 7, backpackHeight, 256, 256);
        graphics.m_280411_(GUI_TEXTURE, x + 7, y, width - 14, backpackHeight, 7.0f, 0.0f, 1, backpackHeight, 256, 256);
        int slotWidth = this.cols * 18;
        int slotHeight = this.rows * 18;
        int minSlotWidth = 162;
        int backpackStartX = Math.max((minSlotWidth - slotWidth) / 2, 0);
        graphics.m_280411_(GUI_TEXTURE, backpackStartX + x + 7, y + 17, slotWidth, slotHeight, 15.0f, 0.0f, slotWidth, slotHeight, 256, 256);
        graphics.m_280411_(GUI_TEXTURE, x, y + backpackHeight, 7, 97, 0.0f, 143.0f, 7, 97, 256, 256);
        graphics.m_280411_(GUI_TEXTURE, x + width - 7, y + backpackHeight, 7, 97, 8.0f, 143.0f, 7, 97, 256, 256);
        graphics.m_280411_(GUI_TEXTURE, x + 7, y + backpackHeight, width - 14, 97, 7.0f, 143.0f, 1, 97, 256, 256);
        int inventoryStartX = Math.max((slotWidth - minSlotWidth) / 2, 0);
        graphics.m_280411_(GUI_TEXTURE, x + inventoryStartX + 7, y + backpackHeight + 14, 163, 76, 15.0f, 157.0f, 163, 76, 256, 256);
    }

    private void openConfigScreen() {
        ClientServices.SCREEN.openConfigScreen();
    }

    public boolean m_7933_(int key, int scanCode, int action) {
        if (Keys.KEY_BACKPACK.m_90832_(key, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(key, scanCode, action);
    }
}

