/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.recipe;

import com.github.alexthe666.citadel.recipe.SpecialRecipeInGuideBook;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.item.SkateboardWheels;
import com.github.alexthe668.iwannaskate.server.misc.IWSTags;
import com.github.alexthe668.iwannaskate.server.recipe.IWSRecipeRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RecipeSkateboardSwapWheels
extends CustomRecipe
implements SpecialRecipeInGuideBook {
    public RecipeSkateboardSwapWheels(ResourceLocation name, CraftingBookCategory category) {
        super(name, category);
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        ItemStack skateboard = ItemStack.f_41583_;
        ItemStack wheels1 = ItemStack.f_41583_;
        ItemStack wheels2 = ItemStack.f_41583_;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack itemstack2 = craftingContainer.m_8020_(i);
            if (itemstack2.m_41619_()) continue;
            if (itemstack2.m_204117_(IWSTags.SKATEBOARD_WHEELS)) {
                if (!wheels2.m_41619_()) {
                    return false;
                }
                if (wheels1.m_41619_()) {
                    wheels1 = itemstack2;
                    continue;
                }
                wheels2 = itemstack2;
                continue;
            }
            if (!itemstack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) {
                return false;
            }
            if (!skateboard.m_41619_()) {
                return false;
            }
            skateboard = itemstack2;
        }
        return !skateboard.m_41619_() && !wheels1.m_41619_() && ItemStack.m_41656_((ItemStack)wheels1, (ItemStack)wheels2);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer craftingContainer) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)craftingContainer.m_6643_(), (Object)ItemStack.f_41583_);
        ItemStack skateboard = ItemStack.f_41583_;
        ArrayList<Integer> wheelPositions = new ArrayList<Integer>();
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack itemstack2 = craftingContainer.m_8020_(i);
            if (itemstack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) {
                skateboard = itemstack2;
                continue;
            }
            if (itemstack2.m_41619_()) continue;
            wheelPositions.add(i);
        }
        if (!skateboard.m_41619_()) {
            ItemStack wheelCopy = new ItemStack((ItemLike)SkateboardData.fromStack(skateboard).getWheelType().getItemRegistryObject().get());
            Iterator iterator = wheelPositions.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                nonnulllist.set(i, (Object)wheelCopy.m_41777_());
            }
        }
        return nonnulllist;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack wheels = ItemStack.f_41583_;
        ItemStack skateboard = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemstack2 = container.m_8020_(i);
            if (itemstack2.m_41619_()) continue;
            if (itemstack2.m_204117_(IWSTags.SKATEBOARD_WHEELS)) {
                wheels = itemstack2;
                continue;
            }
            if (!itemstack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) continue;
            skateboard = itemstack2.m_41777_();
        }
        if (skateboard.m_41619_()) {
            return skateboard;
        }
        SkateboardData data = SkateboardData.fromStack(skateboard);
        data.setWheelType(SkateboardWheels.fromItem(wheels.m_41720_()));
        SkateboardData.setStackData(skateboard, data);
        return skateboard;
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)IWSRecipeRegistry.SKATEBOARD_SWAP_WHEELS.get();
    }

    public NonNullList<Ingredient> getDisplayIngredients() {
        ItemStack skateboard = new ItemStack((ItemLike)IWSItemRegistry.SKATEBOARD.get());
        SkateboardData data = SkateboardData.fromStack(skateboard);
        data.removeGripTape();
        data.removeBanner();
        data.setWheelType(SkateboardWheels.DEFAULT);
        SkateboardData.setStackData(skateboard, data);
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{skateboard}), Ingredient.m_204132_(IWSTags.SKATEBOARD_WHEELS), Ingredient.m_204132_(IWSTags.SKATEBOARD_WHEELS)});
    }

    public ItemStack getDisplayResultFor(NonNullList<ItemStack> nonNullList) {
        ItemStack wheels = ItemStack.f_41583_;
        ItemStack skateboard = ItemStack.f_41583_;
        for (int i = 0; i < nonNullList.size(); ++i) {
            ItemStack itemstack2 = (ItemStack)nonNullList.get(i);
            if (itemstack2.m_41619_()) continue;
            if (itemstack2.m_204117_(IWSTags.SKATEBOARD_WHEELS)) {
                wheels = itemstack2;
                continue;
            }
            if (!itemstack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) continue;
            skateboard = itemstack2.m_41777_();
        }
        if (skateboard.m_41619_()) {
            return skateboard;
        }
        SkateboardData data = SkateboardData.fromStack(skateboard);
        data.setWheelType(SkateboardWheels.fromItem(wheels.m_41720_()));
        SkateboardData.setStackData(skateboard, data);
        return skateboard;
    }
}

