/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardMaterials;
import com.github.alexthe668.iwannaskate.server.potion.IWSEffectRegistry;
import com.github.alexthe668.iwannaskate.server.recipe.IWSRecipeRegistry;
import com.github.alexthe668.iwannaskate.server.world.WanderingSkaterSpawner;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="iwannaskate", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonProxy {
    private static final Map<ServerLevel, WanderingSkaterSpawner> WANDERING_SKATER_SPAWNER_MAP = new HashMap<ServerLevel, WanderingSkaterSpawner>();

    public void init() {
    }

    public void clientInit() {
    }

    public Object getISTERProperties() {
        return null;
    }

    public Object getArmorRenderProperties() {
        return null;
    }

    @SubscribeEvent
    public void onTagsLoaded(TagsUpdatedEvent event) {
        SkateboardMaterials.reload();
        IWSRecipeRegistry.registerCauldronInteractions();
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        double rate = (Double)IWannaSkateMod.COMMON_CONFIG.skateboardExpAnvilRateModifier.get();
        if (event.getLeft().m_150930_((Item)IWSItemRegistry.SKATEBOARD.get()) && event.getRight().m_150930_(Items.f_42690_) && rate != 1.0 && event.getCost() > 1) {
            int initialCost = event.getCost();
            ItemStack copy = event.getLeft().m_41777_();
            boolean incompatible = false;
            Map map = EnchantmentHelper.m_44831_((ItemStack)copy);
            Map map1 = EnchantmentHelper.m_44882_((ListTag)EnchantedBookItem.m_41163_((ItemStack)event.getRight()));
            for (Map.Entry entry : map1.entrySet()) {
                int before = map.getOrDefault(entry.getKey(), 0);
                for (Map.Entry entry2 : map.entrySet()) {
                    if (entry.getKey() == entry2.getKey() || ((Enchantment)entry.getKey()).m_44695_((Enchantment)entry2.getKey())) continue;
                    incompatible = true;
                }
                if (incompatible) continue;
                initialCost += ((Enchantment)entry.getKey()).m_6175_(((Integer)entry.getValue()).intValue());
                map.put((Enchantment)entry.getKey(), before + (Integer)entry.getValue());
            }
            if (!incompatible && initialCost > 5) {
                EnchantmentHelper.m_44865_((Map)map, (ItemStack)copy);
                event.setOutput(copy);
                event.setCost(Math.max(1, (int)Math.ceil((double)initialCost * rate)));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTrySleepInBed(PlayerSleepInBedEvent event) {
        if (event.getEntity().m_21023_((MobEffect)IWSEffectRegistry.HIGH_OCTANE.get()) || event.getEntity().m_21023_((MobEffect)IWSEffectRegistry.OVERCAFFEINATED.get())) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
            event.getEntity().m_5661_((Component)Component.m_237115_((String)"item.iwannaskate.energy_drink.no_sleep"), true);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.LevelTickEvent tick) {
        Level level;
        if (!tick.level.f_46443_ && (level = tick.level) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            WANDERING_SKATER_SPAWNER_MAP.computeIfAbsent(serverWorld, k -> new WanderingSkaterSpawner(serverWorld));
            WanderingSkaterSpawner spawner = WANDERING_SKATER_SPAWNER_MAP.get(serverWorld);
            spawner.tick();
        }
    }

    public void setHoverItem(ItemStack stack) {
    }

    public Player getClientSidePlayer() {
        return null;
    }

    public boolean isKeyDown(int keyType) {
        return false;
    }

    public void onEntityStatus(Entity entity, byte updateKind) {
    }

    public void reloadConfig() {
    }

    public void openBookGUI(ItemStack itemStackIn) {
    }
}

