/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.render.entity;

import com.github.alexthe666.citadel.client.render.LightningBoltData;
import com.github.alexthe666.citadel.client.render.LightningRender;
import com.github.alexthe668.iwannaskate.client.model.SkateboardModel;
import com.github.alexthe668.iwannaskate.client.render.entity.SkateboardTexturer;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import com.github.alexthe668.iwannaskate.server.item.SkateboardWheels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeRenderTypes;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class SkateboardRenderer
extends EntityRenderer<SkateboardEntity> {
    private static final SkateboardModel SKATEBOARD_MODEL = new SkateboardModel();
    private static final ResourceLocation RAINBOW_TRAIL_TEXTURE = new ResourceLocation("iwannaskate", "textures/entity/skateboard/wheels/rainbow_trail.png");
    private static final ResourceLocation AESTHETIC_TRAIL_TEXTURE = new ResourceLocation("iwannaskate", "textures/entity/skateboard/wheels/aesthetic_trail.png");
    private LightningRender lightningRender = new LightningRender();
    private LightningBoltData.BoltRenderInfo lightningBoltData = new LightningBoltData.BoltRenderInfo(1.3f, 0.15f, 0.5f, 0.25f, new Vector4f(0.1f, 0.1f, 0.1f, 0.5f), 0.45f);

    public SkateboardRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.0f;
    }

    public Vec3 getRenderOffset(SkateboardEntity entity, float partialTicks) {
        return Vec3.f_82478_;
    }

    public void render(SkateboardEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        float ageInTicks = (float)entity.f_19797_ + partialTicks;
        float skateYaw = entity.m_5675_(partialTicks);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 1.5, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f - skateYaw));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        poseStack.m_252880_(0.0f, -entity.getRenderOffGroundAmount(partialTicks), 0.0f);
        poseStack.m_85836_();
        SKATEBOARD_MODEL.setupAnim(entity, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        if (entity.getSkateboardData().getWheelType().hasTrail()) {
            Vec3 from = Vec3.f_82478_;
            Vec3 to = entity.getTrailOffset(8, partialTicks).m_82542_(1.0, 0.3, 1.0);
            boolean rainbow = entity.getSkateboardData().getWheelType() == SkateboardWheels.RAINBOW;
            SkateboardRenderer.renderRainbowFromWheel(entity, from, to, 2, poseStack, buffer, skateYaw, rainbow);
            SkateboardRenderer.renderRainbowFromWheel(entity, from, to, 3, poseStack, buffer, skateYaw, rainbow);
            SkateboardRenderer.renderRainbowFromWheel(entity, from, to, 0, poseStack, buffer, skateYaw, rainbow);
            SkateboardRenderer.renderRainbowFromWheel(entity, from, to, 1, poseStack, buffer, skateYaw, rainbow);
        }
        SkateboardTexturer.renderBoard(SKATEBOARD_MODEL, entity.getSkateboardData(), poseStack, buffer, packedLight, entity.hasGlint());
        if (entity.getSkateboardData().getWheelType() == SkateboardWheels.SHOCKING) {
            this.renderLightningFromWheel(entity, 0, poseStack, buffer, partialTicks);
            this.renderLightningFromWheel(entity, 1, poseStack, buffer, partialTicks);
            this.renderLightningFromWheel(entity, 2, poseStack, buffer, partialTicks);
            this.renderLightningFromWheel(entity, 3, poseStack, buffer, partialTicks);
            this.lightningRender.render(partialTicks, poseStack, buffer);
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderLightningFromWheel(SkateboardEntity entity, int wheel, PoseStack poseStack, MultiBufferSource buffer, float partialTicks) {
        Vec3 strike = entity.lightningPositions[wheel];
        String wheelId = "skateboard" + entity.m_19879_() + "_wheel_" + wheel;
        if (strike != null) {
            Vec3 wheelPos = SkateboardRenderer.translateToWheel(wheel);
            LightningBoltData.BoltRenderInfo lightningBoltData = new LightningBoltData.BoltRenderInfo(0.05f, 0.2f, 0.5f, 0.85f, new Vector4f(0.3f, 0.45f, 0.6f, 0.85f), 0.1f);
            LightningBoltData bolt = new LightningBoltData(lightningBoltData, wheelPos, wheelPos.m_82549_(strike.m_82490_((double)0.7f)).m_82549_(entity.m_20184_()), 7).size(0.05f).lifespan(4).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE);
            this.lightningRender.update((Object)wheelId, bolt, partialTicks);
        }
    }

    private static Vec3 translateToWheel(int wheel) {
        PoseStack modelTranslateStack = new PoseStack();
        SkateboardRenderer.SKATEBOARD_MODEL.root.translateAndRotate(modelTranslateStack);
        SkateboardRenderer.SKATEBOARD_MODEL.board.translateAndRotate(modelTranslateStack);
        float up = 0.0f;
        boolean left = false;
        if (wheel == 0) {
            SkateboardRenderer.SKATEBOARD_MODEL.frontAxel.translateAndRotate(modelTranslateStack);
            SkateboardRenderer.SKATEBOARD_MODEL.leftFrontWheel.translateAndRotate(modelTranslateStack);
            left = true;
            up = 0.01f;
        } else if (wheel == 1) {
            SkateboardRenderer.SKATEBOARD_MODEL.frontAxel.translateAndRotate(modelTranslateStack);
            SkateboardRenderer.SKATEBOARD_MODEL.rightFrontWheel.translateAndRotate(modelTranslateStack);
            up = 0.015f;
        } else if (wheel == 2) {
            SkateboardRenderer.SKATEBOARD_MODEL.backAxel.translateAndRotate(modelTranslateStack);
            SkateboardRenderer.SKATEBOARD_MODEL.leftBackWheel.translateAndRotate(modelTranslateStack);
            left = true;
            up = -0.015f;
        } else if (wheel == 3) {
            SkateboardRenderer.SKATEBOARD_MODEL.backAxel.translateAndRotate(modelTranslateStack);
            SkateboardRenderer.SKATEBOARD_MODEL.rightBackWheel.translateAndRotate(modelTranslateStack);
            up = -0.005f;
        }
        Vector4f bodyOffsetVec = new Vector4f(left ? -0.08f : 0.08f, 0.0f, 0.0f, 1.0f);
        bodyOffsetVec.mul((Matrix4fc)modelTranslateStack.m_85850_().m_252922_());
        Vec3 wheelOffset = new Vec3((double)bodyOffsetVec.x(), (double)bodyOffsetVec.y(), (double)bodyOffsetVec.z());
        modelTranslateStack.m_85849_();
        return wheelOffset.m_82520_(0.0, (double)(-up), 0.0);
    }

    private static void renderRainbowFromWheel(SkateboardEntity entity, Vec3 from, Vec3 to, int wheel, PoseStack poseStack, MultiBufferSource bufferSource, float skateYaw, boolean rainbow) {
        Vec3 sub = from.m_82546_(to);
        double d = sub.m_165924_();
        float rotY = (float)(Mth.m_14136_((double)sub.f_82479_, (double)sub.f_82481_) * 57.2957763671875);
        float rotX = (float)(-(Mth.m_14136_((double)sub.f_82480_, (double)d) * 57.2957763671875)) - 90.0f;
        Vec3 wheelOffset = SkateboardRenderer.translateToWheel(wheel);
        poseStack.m_85836_();
        poseStack.m_85837_(wheelOffset.f_82479_, wheelOffset.f_82480_, wheelOffset.f_82481_);
        poseStack.m_85841_(-1.0f, 1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(skateYaw));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotY));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotX));
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        VertexConsumer rainbowConsumer = bufferSource.m_6299_(ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)(rainbow ? RAINBOW_TRAIL_TEXTURE : AESTHETIC_TRAIL_TEXTURE), (boolean)false));
        float height = Mth.m_14036_((float)((float)(sub.m_82553_() * 0.5)), (float)0.0f, (float)1.2f);
        float moveAlong = ((float)entity.f_19797_ + Minecraft.m_91087_().m_91296_()) * -0.1f;
        SkateboardRenderer.rainbowVertex(rainbowConsumer, matrix4f, matrix3f, 240, 0.3f, height, 0.0f, moveAlong + 1.0f, 0.0f);
        SkateboardRenderer.rainbowVertex(rainbowConsumer, matrix4f, matrix3f, 240, 0.7f, height, 1.0f, moveAlong + 1.0f, 0.0f);
        SkateboardRenderer.rainbowVertex(rainbowConsumer, matrix4f, matrix3f, 240, 0.7f, 0.0f, 1.0f, moveAlong, 1.0f);
        SkateboardRenderer.rainbowVertex(rainbowConsumer, matrix4f, matrix3f, 240, 0.3f, 0.0f, 0.0f, moveAlong, 1.0f);
        poseStack.m_85849_();
    }

    private static void rainbowVertex(VertexConsumer p_114090_, Matrix4f p_114091_, Matrix3f p_114092_, int p_114093_, float p_114094_, float p_114095_, float p_114096_, float p_114097_, float alpha) {
        p_114090_.m_252986_(p_114091_, p_114094_ - 0.5f, p_114095_, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(p_114096_, p_114097_).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(SkateboardEntity skateboard) {
        return null;
    }
}

