/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.PinkSaltPillar;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class Undermine
extends Behavior<Berserker> {
    private static final int DURATION = Mth.m_14167_((float)22.4f);
    private static final int MAX_DURATION = 50;

    public Undermine() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)GMemoryModuleTypes.RAMPAGE_TICKS.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)GMemoryModuleTypes.IMPALING_COOLDOWN.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)GMemoryModuleTypes.IS_SMASHING.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)GMemoryModuleTypes.IS_IMPALING.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)GMemoryModuleTypes.IS_SUMMONING.get()), (Object)MemoryStatus.VALUE_ABSENT), 50);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Berserker mob) {
        List list = serverLevel.m_45976_(LivingEntity.class, mob.m_20191_());
        for (LivingEntity nearby : list) {
            if (!nearby.m_6084_() || nearby.m_6095_() == GEntityTypes.BERSERKER.get()) continue;
            return false;
        }
        return mob.m_217003_(Pose.STANDING) && mob.shouldAttack() && mob.m_216992_((Entity)mob.m_6274_().m_21952_(MemoryModuleType.f_26372_).get(), 15.0, 20.0);
    }

    protected boolean canStillUse(ServerLevel serverLevel, Berserker mob, long l) {
        return true;
    }

    protected void start(ServerLevel serverLevel, Berserker mob, long l) {
        Brain<Berserker> brain = mob.m_6274_();
        brain.m_21882_(MemoryModuleType.f_26373_, (Object)true, (long)DURATION);
        brain.m_21882_((MemoryModuleType)GMemoryModuleTypes.IS_IMPALING.get(), (Object)Unit.INSTANCE, 50L);
        brain.m_21879_((MemoryModuleType)GMemoryModuleTypes.IMPALING_COUNT.get(), (Object)(brain.m_21952_((MemoryModuleType)GMemoryModuleTypes.IMPALING_COUNT.get()).orElse(0) + 1));
        brain.m_21936_(MemoryModuleType.f_26370_);
        mob.setPhase(Berserker.Phase.UNDERMINE);
        mob.m_5496_((SoundEvent)GSoundEvents.BERSERKER_SMASH.get(), 3.0f, 1.0f);
    }

    protected void tick(ServerLevel serverLevel, Berserker mob, long l) {
        Optional memory = mob.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        memory.ifPresent(target -> mob.m_21563_().m_24964_(target.m_20182_()));
        mob.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        if (mob.m_6274_().m_21874_(MemoryModuleType.f_26373_)) {
            return;
        }
        if (memory.isPresent() && mob.canTargetEntity((Entity)memory.get())) {
            LivingEntity target2 = (LivingEntity)memory.get();
            double d = Math.min(target2.m_20186_(), mob.m_20186_());
            double e = Math.max(target2.m_20186_(), mob.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(target2.m_20189_() - mob.m_20189_()), (double)(target2.m_20185_() - mob.m_20185_()));
            if (mob.m_20270_((Entity)target2) < 4.0f) {
                float g;
                int index;
                mob.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(-1.0, -1.0, -1.0));
                for (index = 0; index < 5; ++index) {
                    g = f + (float)index * (float)Math.PI * 0.4f;
                    this.createPillar(mob, 0, 4.0f, 0.0f, mob.m_20185_() + (double)Mth.m_14089_((float)g) * 1.5, mob.m_20189_() + (double)Mth.m_14031_((float)g) * 1.5, d, e, g);
                }
                for (index = 0; index < 8; ++index) {
                    g = f + (float)index * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.createPillar(mob, 3, 4.0f, 0.0f, mob.m_20185_() + (double)Mth.m_14089_((float)g) * 2.5, mob.m_20189_() + (double)Mth.m_14031_((float)g) * 2.5, d, e, g);
                }
            } else {
                mob.m_7618_(EntityAnchorArgument.Anchor.EYES, target2.m_20182_());
                for (int index = 0; index < 16; ++index) {
                    double h = 1.25 * (double)(index + 1);
                    this.createPillar(mob, index, 6.0f, 0.2f, mob.m_20185_() + (double)Mth.m_14089_((float)f) * h + (double)((mob.m_217043_().m_188501_() - 0.5f) * 0.4f), mob.m_20189_() + (double)Mth.m_14031_((float)f) * h + (double)((mob.m_217043_().m_188501_() - 0.5f) * 0.4f), d, e, f);
                }
            }
        }
        mob.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, (long)(50 - DURATION));
    }

    private void createPillar(Berserker mob, int index, float damage, float damageLowerRate, double d, double e, double f, double g, float h) {
        BlockPos blockPos = BlockPos.m_274561_((double)d, (double)g, (double)e);
        boolean bl = false;
        double j = 0.0;
        do {
            VoxelShape voxelShape;
            BlockPos blockPos2 = blockPos.m_7495_();
            BlockState blockState = mob.m_9236_().m_8055_(blockPos2);
            if (!blockState.m_60783_((BlockGetter)mob.m_9236_(), blockPos2, Direction.UP)) continue;
            if (!mob.m_9236_().m_46859_(blockPos) && !(voxelShape = mob.m_9236_().m_8055_(blockPos).m_60812_((BlockGetter)mob.m_9236_(), blockPos)).m_83281_()) {
                j = voxelShape.m_83297_(Direction.Axis.Y);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)f) - 1);
        if (bl) {
            if (damageLowerRate > 0.0f) {
                damage -= (float)index * damageLowerRate;
            }
            mob.m_9236_().m_7967_((Entity)new PinkSaltPillar(mob.m_9236_(), d, (double)blockPos.m_123342_() + j, e, h, index, damage, (LivingEntity)mob));
        }
    }

    protected void stop(ServerLevel serverLevel, Berserker mob, long l) {
        mob.setPhase(Berserker.Phase.IDLING);
        Optional memory = mob.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        Optional undermine = mob.m_6274_().m_21952_((MemoryModuleType)GMemoryModuleTypes.IMPALING_COUNT.get());
        if (undermine.isPresent() && (Integer)undermine.get() >= 3) {
            mob.m_6274_().m_21882_((MemoryModuleType)GMemoryModuleTypes.IMPALING_COOLDOWN.get(), (Object)Unit.INSTANCE, 50L);
            mob.m_6274_().m_21879_((MemoryModuleType)GMemoryModuleTypes.IMPALING_COUNT.get(), (Object)0);
        } else if (memory.isPresent() && (double)((LivingEntity)memory.get()).m_20270_((Entity)mob) < 4.0) {
            mob.m_6274_().m_21882_((MemoryModuleType)GMemoryModuleTypes.IMPALING_COOLDOWN.get(), (Object)Unit.INSTANCE, 400L);
        }
    }
}

