/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.entities.ai.tasks.Rise;

public class PreservedAi {
    public static Brain<?> makeBrain(Brain<Preserved> brain) {
        PreservedAi.initCoreActivity(brain);
        PreservedAi.initEmergeActivity(brain);
        PreservedAi.initIdleActivity(brain);
        PreservedAi.initFightActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<Preserved> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initEmergeActivity(Brain<Preserved> brain) {
        brain.m_21895_(Activity.f_219852_, 5, ImmutableList.of((Object)((Object)new Rise(40))), MemoryModuleType.f_217786_);
    }

    private static void initIdleActivity(Brain<Preserved> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)StartAttacking.m_257710_(PreservedAi::findNearestValidAttackTarget), (Object)SetEntityLookTargetSometimes.m_257458_((float)8.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), PreservedAi.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(Brain<Preserved> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.2f), (Object)MeleeAttack.m_257733_((int)40), (Object)StopAttackingIfTargetInvalid.m_257822_()), MemoryModuleType.f_26372_);
    }

    private static RunOne<Preserved> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Preserved preserved) {
        return preserved.m_6274_().m_21952_(MemoryModuleType.f_148194_);
    }

    public static void updateActivity(Preserved preserved) {
        preserved.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_219852_, (Object)Activity.f_37988_, (Object)Activity.f_37979_));
    }
}

