/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.platform.forge;

import com.faboslav.friendsandfoes.network.base.Packet;
import com.faboslav.friendsandfoes.network.base.PacketHandler;
import com.faboslav.friendsandfoes.platform.ModVersion;
import com.faboslav.friendsandfoes.util.client.PlayerProvider;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketChannelManagerImpl {
    public static final Map<ResourceLocation, Channel> CHANNELS = new HashMap<ResourceLocation, Channel>();

    public static void registerChannel(ResourceLocation name) {
        String protocolVersion = ModVersion.getModVersion();
        Channel channel = new Channel(0, NetworkRegistry.newSimpleChannel((ResourceLocation)name, () -> protocolVersion, protocolVersion::equals, protocolVersion::equals));
        CHANNELS.put(name, channel);
    }

    public static <T extends Packet<T>> void registerS2CPacket(ResourceLocation name, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + name + " not registered");
        }
        ++channel.packets;
        channel.channel.registerMessage(channel.packets, packetClass, handler::encode, handler::decode, (msg, ctx) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            context.enqueueWork(() -> {
                Player player = null;
                if (context.getSender() == null) {
                    player = PlayerProvider.getClientPlayer();
                }
                if (player != null) {
                    Player finalPlayer = player;
                    handler.handle(msg).apply(finalPlayer, finalPlayer.m_9236_());
                }
            });
            context.setPacketHandled(true);
        });
    }

    public static <T extends Packet<T>> void registerC2SPacket(ResourceLocation name, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + name + " not registered");
        }
        ++channel.packets;
        channel.channel.registerMessage(channel.packets, packetClass, handler::encode, handler::decode, (msg, ctx) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            ServerPlayer player = context.getSender();
            if (player != null) {
                context.enqueueWork(() -> PacketChannelManagerImpl.lambda$registerC2SPacket$3(handler, msg, (Player)player));
            }
            context.setPacketHandled(true);
        });
    }

    public static <T extends Packet<T>> void sendToServer(ResourceLocation name, T packet) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + name + " not registered");
        }
        channel.channel.sendToServer(packet);
    }

    public static <T extends Packet<T>> void sendToPlayer(ResourceLocation name, T packet, Player player) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + name + " not registered");
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            channel.channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), packet);
        }
    }

    private static /* synthetic */ void lambda$registerC2SPacket$3(PacketHandler handler, Packet msg, Player player) {
        handler.handle(msg).apply(player, player.m_9236_());
    }

    private static final class Channel {
        private int packets;
        private final SimpleChannel channel;

        private Channel(int packets, SimpleChannel channel) {
            this.packets = packets;
            this.channel = channel;
        }
    }
}

