/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.brain;

import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.entity.ai.brain.task.coppergolem.CopperGolemLocateButtonTask;
import com.faboslav.friendsandfoes.entity.ai.brain.task.coppergolem.CopperGolemPressButtonTask;
import com.faboslav.friendsandfoes.entity.ai.brain.task.coppergolem.CopperGolemSpinHeadTask;
import com.faboslav.friendsandfoes.entity.ai.brain.task.coppergolem.CopperGolemTravelToButtonTask;
import com.faboslav.friendsandfoes.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.init.FriendsAndFoesMemorySensorType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Set;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class CopperGolemBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super CopperGolemEntity>>> SENSORS;
    private static final UniformInt SPIN_HEAD_COOLDOWN_PROVIDER;
    private static final UniformInt PRESS_BUTTON_COOLDOWN_PROVIDER;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.m_21923_(MEMORY_MODULES, SENSORS);
        Brain brain = profile.m_22073_(dynamic);
        CopperGolemBrain.addCoreActivities((Brain<CopperGolemEntity>)brain);
        CopperGolemBrain.addAvoidActivities((Brain<CopperGolemEntity>)brain);
        CopperGolemBrain.addIdleActivities((Brain<CopperGolemEntity>)brain);
        CopperGolemBrain.addPressButtonActivities((Brain<CopperGolemEntity>)brain);
        CopperGolemBrain.addSpinHeadActivities((Brain<CopperGolemEntity>)brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void addCoreActivities(Brain<CopperGolemEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_SPIN_HEAD_COOLDOWN.get()), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get())));
    }

    private static void addPressButtonActivities(Brain<CopperGolemEntity> brain) {
        brain.m_21903_(FriendsAndFoesActivities.COPPER_GOLEM_PRESS_BUTTON.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CopperGolemLocateButtonTask())), (Object)Pair.of((Object)1, (Object)((Object)new CopperGolemTravelToButtonTask())), (Object)Pair.of((Object)2, (Object)((Object)new CopperGolemPressButtonTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148196_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addSpinHeadActivities(Brain<CopperGolemEntity> brain) {
        brain.m_21903_(FriendsAndFoesActivities.COPPER_GOLEM_SPIN_HEAD.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CopperGolemSpinHeadTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148196_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_SPIN_HEAD_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void addAvoidActivities(Brain<CopperGolemEntity> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.25f, (int)8, (boolean)true)), MemoryModuleType.f_26383_);
    }

    private static void addIdleActivities(Brain<CopperGolemEntity> brain) {
        brain.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new FollowTemptation(copperGolem -> Float.valueOf(1.25f))), (Object)Pair.of((Object)1, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_SPIN_HEAD_COOLDOWN.get(), (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static void updateActivities(CopperGolemEntity copperGolem) {
        copperGolem.m_6274_().m_21926_((List)ImmutableList.of((Object)FriendsAndFoesActivities.COPPER_GOLEM_PRESS_BUTTON.get(), (Object)FriendsAndFoesActivities.COPPER_GOLEM_SPIN_HEAD.get(), (Object)Activity.f_37991_, (Object)Activity.f_37979_));
    }

    public static void setSpinHeadCooldown(CopperGolemEntity copperGolem) {
        copperGolem.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_SPIN_HEAD_COOLDOWN.get(), (Object)SPIN_HEAD_COOLDOWN_PROVIDER.m_214085_(copperGolem.m_217043_()));
    }

    public static void setPressButtonCooldown(CopperGolemEntity copperGolem) {
        copperGolem.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get(), (Object)PRESS_BUTTON_COOLDOWN_PROVIDER.m_214085_(copperGolem.m_217043_()));
    }

    public static void setPressButtonCooldown(CopperGolemEntity copperGolem, UniformInt cooldown) {
        copperGolem.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get(), (Object)cooldown.m_214085_(copperGolem.m_217043_()));
    }

    public static Ingredient getTemptItems() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42784_});
    }

    static {
        SENSORS = List.of(FriendsAndFoesMemorySensorType.COPPER_GOLEM_TEMPTATIONS.get(), FriendsAndFoesMemorySensorType.COPPER_GOLEM_SPECIFIC_SENSOR.get());
        MEMORY_MODULES = List.of(MemoryModuleType.f_148196_, MemoryModuleType.f_148197_, MemoryModuleType.f_148198_, MemoryModuleType.f_148205_, MemoryModuleType.f_26377_, MemoryModuleType.f_26371_, MemoryModuleType.f_26370_, MemoryModuleType.f_26383_, MemoryModuleType.f_26326_, FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get(), FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_SPIN_HEAD_COOLDOWN.get(), FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get());
        SPIN_HEAD_COOLDOWN_PROVIDER = TimeUtil.m_145020_((int)8, (int)16);
        PRESS_BUTTON_COOLDOWN_PROVIDER = TimeUtil.m_145020_((int)15, (int)30);
    }
}

