/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.dynamic_resources;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.duck.IExtendedModelBakery;
import org.embeddedt.modernfix.forge.dynresources.IModelBakerImpl;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelBakery.ModelBakerImpl.class}, priority=600)
public abstract class ModelBakerImplMixin
implements IModelBakerImpl {
    private static final boolean debugDynamicModelLoading = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    @Shadow
    @Final
    private ModelBakery f_243927_;
    private boolean mfix$ignoreCache = false;
    @Shadow
    @Final
    private Function<Material, TextureAtlasSprite> f_243920_;
    private ResourceLocation capturedLocation;
    private UnbakedModel capturedModel;
    private ModelState capturedState;

    @Override
    public void mfix$ignoreCache() {
        this.mfix$ignoreCache = true;
    }

    @Inject(method={"bake(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/resources/model/ModelState;Ljava/util/function/Function;)Lnet/minecraft/client/resources/model/BakedModel;"}, at={@At(value="HEAD")}, remap=false)
    private void captureState(ResourceLocation arg, ModelState state, Function<Material, TextureAtlasSprite> sprites, CallbackInfoReturnable<BakedModel> cir) {
        this.capturedState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getModel"}, at={@At(value="HEAD")}, cancellable=true)
    private void obtainModel(ResourceLocation arg, CallbackInfoReturnable<UnbakedModel> cir) {
        this.capturedLocation = arg;
        if (debugDynamicModelLoading) {
            ModernFix.LOGGER.info("Baking {}", (Object)arg);
        }
        IExtendedModelBakery extendedBakery = (IExtendedModelBakery)this.f_243927_;
        if (arg instanceof ModelResourceLocation && arg != ModelBakery.f_119230_) {
            ModelBakery modelBakery = this.f_243927_;
            synchronized (modelBakery) {
                this.f_243927_.m_119306_((ModelResourceLocation)arg);
                cir.setReturnValue((Object)this.f_243927_.f_119214_.getOrDefault(arg, extendedBakery.mfix$getUnbakedMissingModel()));
                this.f_243927_.f_119214_.clear();
            }
        } else {
            cir.setReturnValue((Object)this.f_243927_.m_119341_(arg));
        }
        UnbakedModel toReplace = (UnbakedModel)cir.getReturnValue();
        for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
            try {
                toReplace = integration.onUnbakedModelPreBake(arg, toReplace, this.f_243927_);
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Exception firing model pre-bake event for {}", (Object)arg, (Object)e);
            }
        }
        cir.setReturnValue((Object)toReplace);
        ((UnbakedModel)cir.getReturnValue()).m_5500_(arg_0 -> ((ModelBakery)this.f_243927_).m_119341_(arg_0));
        this.capturedModel = (UnbakedModel)cir.getReturnValue();
        if (cir.getReturnValue() == extendedBakery.mfix$getUnbakedMissingModel() && arg != ModelBakery.f_119230_ && debugDynamicModelLoading) {
            ModernFix.LOGGER.warn("Model {} not present", (Object)arg);
        }
    }

    @ModifyExpressionValue(method={"bake(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/resources/model/ModelState;Ljava/util/function/Function;)Lnet/minecraft/client/resources/model/BakedModel;"}, at={@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", ordinal=0)}, remap=false)
    private Object ignoreCacheIfRequested(Object o) {
        return this.mfix$ignoreCache ? null : o;
    }

    @ModifyExpressionValue(method={"bake(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/resources/model/ModelState;Ljava/util/function/Function;)Lnet/minecraft/client/resources/model/BakedModel;"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/UnbakedModel;bake(Lnet/minecraft/client/resources/model/ModelBaker;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/resources/model/BakedModel;")})
    private BakedModel unifyMissingBakedModel(BakedModel model) {
        for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
            model = integration.onBakedModelLoad(this.capturedLocation, this.capturedModel, model, this.capturedState, this.f_243927_);
        }
        return model;
    }
}

