/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.reg;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.ModStairBlock;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.common.block.GingerBlock;
import net.mehvahdjukaar.snowyspirit.common.block.GlowLightsBlock;
import net.mehvahdjukaar.snowyspirit.common.block.GlowLightsBlockTile;
import net.mehvahdjukaar.snowyspirit.common.block.GumdropButton;
import net.mehvahdjukaar.snowyspirit.common.block.SnowGlobeBlock;
import net.mehvahdjukaar.snowyspirit.common.block.WildGingerBlock;
import net.mehvahdjukaar.snowyspirit.common.block.WreathBlock;
import net.mehvahdjukaar.snowyspirit.common.entity.ContainerHolderEntity;
import net.mehvahdjukaar.snowyspirit.common.entity.SledEntity;
import net.mehvahdjukaar.snowyspirit.common.items.CandyCaneItem;
import net.mehvahdjukaar.snowyspirit.common.items.EggnogItem;
import net.mehvahdjukaar.snowyspirit.common.items.GlowLightsItem;
import net.mehvahdjukaar.snowyspirit.common.items.SledItem;
import net.mehvahdjukaar.snowyspirit.reg.ModSounds;
import net.minecraft.Util;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;

public class ModRegistry {
    public static final String SLED_NAME = "sled";
    public static final Supplier<EntityType<SledEntity>> SLED = ModRegistry.regEntity("sled", () -> EntityType.Builder.m_20704_(SledEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10));
    public static final Supplier<EntityType<ContainerHolderEntity>> CONTAINER_ENTITY = ModRegistry.regEntity("container_entity", () -> EntityType.Builder.m_20704_(ContainerHolderEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.75f, 0.75f).m_20702_(8));
    public static final Map<WoodType, SledItem> SLED_ITEMS = new LinkedHashMap<WoodType, SledItem>();
    public static final Supplier<Block> CANDY_CANE_BLOCK = ModRegistry.regWithItem("candy_cane_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152497_).m_284180_(MapColor.f_283765_).m_60999_().m_60978_(1.5f).m_60918_(SoundType.f_154660_)));
    public static final String CANDY_CANE_NAME = "candy_cane";
    public static final Supplier<Item> CANDY_CANE = ModRegistry.regItem("candy_cane", () -> new CandyCaneItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.4f).m_38767_())));
    public static final Supplier<Item> GINGERBREAD_COOKIE = ModRegistry.regItem("gingerbread_cookie", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(1).m_38766_().m_38758_(0.4f).m_38767_())));
    public static final String EGGNOG_NAME = "eggnog";
    public static final Supplier<Item> EGGNOG = ModRegistry.regItem("eggnog", EggnogItem::new);
    public static final String WINTER_DISC_NAME = "music_disc_winter";
    public static final Supplier<Item> WINTER_DISC = ModRegistry.regItem("music_disc_winter", () -> PlatHelper.newMusicDisc((int)14, ModSounds.WINTER_MUSIC, (Item.Properties)new Item.Properties().m_41497_(Rarity.RARE).m_41487_(1), (int)161));
    public static final Supplier<Block> GINGERBREAD_BLOCK = ModRegistry.regWithItem("gingerbread", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283895_).m_60918_(SoundType.f_56736_).m_60978_(1.0f)));
    public static final Supplier<Block> GINGERBREAD_STAIRS = ModRegistry.regWithItem("gingerbread_stairs", () -> new ModStairBlock(GINGERBREAD_BLOCK, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GINGERBREAD_BLOCK.get()))));
    public static final Supplier<Block> GINGERBREAD_SLAB = ModRegistry.regWithItem("gingerbread_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GINGERBREAD_BLOCK.get()))));
    public static final Supplier<Block> GINGERBREAD_FROSTED_BLOCK = ModRegistry.regWithItem("gingerbread_frosted", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GINGERBREAD_BLOCK.get()))));
    public static final Supplier<Block> GINGERBREAD_DOOR = ModRegistry.regWithItem("gingerbread_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GINGERBREAD_BLOCK.get())), BlockSetType.f_271512_){});
    public static final Supplier<Block> GINGERBREAD_TRAPDOOR = ModRegistry.regWithItem("gingerbread_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GINGERBREAD_BLOCK.get())), BlockSetType.f_271512_){});
    public static final Supplier<Block> GINGER_WILD = ModRegistry.regWithItem("wild_ginger", () -> new WildGingerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50359_)));
    public static final String GINGER_NAME = "ginger";
    public static final Supplier<Block> GINGER_CROP = ModRegistry.regBlock("ginger", () -> new GingerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60910_().m_60977_().m_60966_()));
    public static final Supplier<Item> GINGER_FLOWER = ModRegistry.regItem("ginger_flower", () -> new ItemNameBlockItem(GINGER_CROP.get(), new Item.Properties()));
    public static final Supplier<Item> GINGER = ModRegistry.regItem("ginger", () -> new Item(new Item.Properties()));
    public static final Supplier<Block> GINGER_POT = ModRegistry.regBlock("potted_ginger", () -> PlatHelper.newFlowerPot(() -> (FlowerPotBlock)Blocks.f_50276_, GINGER_CROP, (BlockBehaviour.Properties)BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
    public static final Supplier<SimpleParticleType> GLOW_LIGHT_PARTICLE = RegHelper.registerParticle((ResourceLocation)SnowySpirit.res("glow_light"));
    public static final String GUMDROP_NAME = "gumdrop";
    public static final Map<DyeColor, Supplier<Block>> GUMDROPS_BUTTONS = (Map)BlocksColorAPI.SORTED_COLORS.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), c -> ModRegistry.regWithItem("gumdrop_" + c.m_41065_(), () -> new GumdropButton((DyeColor)c))));
    public static final String GLOW_LIGHTS_NAME = "glow_lights";
    public static final Map<DyeColor, Supplier<Block>> GLOW_LIGHTS_BLOCKS = (Map)Util.m_137537_(() -> {
        HashMap<DyeColor, Supplier<Block>> m = new HashMap<DyeColor, Supplier<Block>>();
        for (DyeColor c : DyeColor.values()) {
            m.put(c, ModRegistry.regBlock("glow_lights_" + c.m_41065_(), () -> new GlowLightsBlock(c)));
        }
        m.put(null, ModRegistry.regBlock("glow_lights_prismatic", () -> new GlowLightsBlock(null)));
        return m;
    });
    public static final Map<DyeColor, Supplier<Item>> GLOW_LIGHTS_ITEMS = (Map)Util.m_137537_(() -> {
        HashMap<DyeColor, Supplier<Item>> m = new HashMap<DyeColor, Supplier<Item>>();
        for (DyeColor c : BlocksColorAPI.SORTED_COLORS) {
            m.put(c, ModRegistry.regItem("glow_lights_" + c.m_41065_(), () -> new GlowLightsItem(GLOW_LIGHTS_BLOCKS.get(c).get())));
        }
        m.put(null, ModRegistry.regItem("glow_lights_prismatic", () -> new GlowLightsItem(GLOW_LIGHTS_BLOCKS.get(null).get())));
        return m;
    });
    public static final Supplier<BlockEntityType<GlowLightsBlockTile>> GLOW_LIGHTS_BLOCK_TILE = ModRegistry.regTile("glow_lights", () -> PlatHelper.newBlockEntityType(GlowLightsBlockTile::new, (Block[])((Block[])GLOW_LIGHTS_BLOCKS.values().stream().map(Supplier::get).toArray(Block[]::new))));
    public static final String WREATH_NAME = "wreath";
    public static final Supplier<Block> WREATH = ModRegistry.regWithItem("wreath", () -> new WreathBlock(BlockBehaviour.Properties.m_284310_().m_278183_().m_60955_().m_284180_(MapColor.f_283784_).m_60918_(SoundType.f_56760_).m_60978_(0.1f).m_60910_()));
    public static final String SNOW_GLOBE_NAME = "snow_globe";
    public static final Supplier<Block> SNOW_GLOBE = ModRegistry.regWithItem("snow_globe", () -> new SnowGlobeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60918_(SoundType.f_56744_).m_284180_(MapColor.f_283808_).m_60978_(0.5f)));

    public static void init() {
        BlockSetAPI.addDynamicItemRegistration(ModRegistry::registerSledItems, WoodType.class);
    }

    private static void registerSledItems(Registrator<Item> event, Collection<WoodType> woodTypes) {
        for (WoodType wood : woodTypes) {
            if (!wood.canBurn()) continue;
            String name = wood.getVariantId(SLED_NAME);
            SledItem item = new SledItem(wood);
            event.register(SnowySpirit.res(name), (Object)item);
            SLED_ITEMS.put(wood, item);
            wood.addChild(SLED_NAME, (Object)item);
        }
    }

    public static <T extends Item> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((ResourceLocation)SnowySpirit.res(name), sup);
    }

    public static <T extends BlockEntityType<E>, E extends BlockEntity> Supplier<T> regTile(String name, Supplier<T> sup) {
        return RegHelper.registerBlockEntityType((ResourceLocation)SnowySpirit.res(name), sup);
    }

    public static <T extends Block> Supplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((ResourceLocation)SnowySpirit.res(name), sup);
    }

    public static <T extends Block> Supplier<T> regWithItem(String name, Supplier<T> blockFactory) {
        return ModRegistry.regWithItem(name, blockFactory, new Item.Properties(), 0);
    }

    public static <T extends Block> Supplier<T> regWithItem(String name, Supplier<T> blockFactory, Item.Properties properties, int burnTime) {
        Supplier<T> block = ModRegistry.regBlock(name, blockFactory);
        ModRegistry.regBlockItem(name, block, properties, burnTime);
        return block;
    }

    public static Supplier<BlockItem> regBlockItem(String name, Supplier<? extends Block> blockSup, Item.Properties properties, int burnTime) {
        return RegHelper.registerItem((ResourceLocation)SnowySpirit.res(name), () -> burnTime == 0 ? new BlockItem((Block)blockSup.get(), properties) : new WoodBasedBlockItem((Block)blockSup.get(), properties, burnTime));
    }

    public static <T extends Entity> Supplier<EntityType<T>> regEntity(String name, Supplier<EntityType.Builder<T>> builder) {
        return RegHelper.registerEntityType((ResourceLocation)SnowySpirit.res(name), () -> ((EntityType.Builder)builder.get()).m_20712_(name));
    }
}

