/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.integration.supp;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.reg.ModMemoryModules;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;

public class PlacePresentTask
extends Behavior<Villager> {
    private final float speedModifier;
    private BlockPos targetPos;
    private int ticksSinceReached = 0;
    private int cooldown = 600;

    public static boolean isPresentOn() {
        return CommonConfigs.isEnabled((String)"present");
    }

    public PlacePresentTask(float speed) {
        super((Map)ImmutableMap.of(ModMemoryModules.PLACED_PRESENT.get(), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26362_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), 190, 270);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Villager pOwner) {
        if (this.cooldown-- > 0) {
            return false;
        }
        if (pOwner.m_6162_()) {
            return false;
        }
        if (!SnowySpirit.isChristmasSeason((Level)level)) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((Level)level, (Entity)pOwner) || level.f_46441_.m_188503_(5) != 0) {
            this.cooldown = 1000;
            return false;
        }
        Optional meeting = pOwner.m_6274_().m_21952_(MemoryModuleType.f_26362_);
        if (meeting.isEmpty() || level.m_46472_() != ((GlobalPos)meeting.get()).m_122640_() || ((GlobalPos)meeting.get()).m_122646_().m_123331_((Vec3i)pOwner.m_20183_()) > 225.0) {
            this.cooldown = 400;
            return false;
        }
        return true;
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 20 * (10 + pLevel.f_46441_.m_188503_(10)) + pLevel.f_46441_.m_188503_(20);
        this.ticksSinceReached = 0;
        this.targetPos = PlacePresentTask.getValidPlacementPos(pLevel, (LivingEntity)pEntity);
        if (this.targetPos != null) {
            pEntity.m_6274_().m_21936_(MemoryModuleType.f_26374_);
            pEntity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(this.targetPos, this.speedModifier, 1));
            PlacePresentTask.displayAsHeldItem(pEntity, this.getRandomPresent(pLevel.f_46441_));
        }
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.m_6732_(pLevel, (LivingEntity)pEntity, pGameTime);
        PlacePresentTask.clearHeldItem(pEntity);
        this.targetPos = null;
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.targetPos != null && PlacePresentTask.isValidPlacementSpot(pLevel, this.targetPos);
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        if (this.targetPos != null) {
            pOwner.m_6274_().m_21936_(MemoryModuleType.f_26374_);
            pOwner.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(this.targetPos, this.speedModifier, 2));
            pOwner.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.targetPos));
            if (this.targetPos.m_203195_((Position)pOwner.m_20182_(), 2.3)) {
                ++this.ticksSinceReached;
                if (this.ticksSinceReached > 20) {
                    ItemStack stack = pOwner.m_21205_();
                    Item item = stack.m_41720_();
                    if (item instanceof BlockItem) {
                        BlockItem blockItem = (BlockItem)item;
                        BlockState state = (BlockState)blockItem.m_40614_().m_49966_().m_61124_((Property)PresentBlock.PACKED, (Comparable)Boolean.valueOf(true));
                        pLevel.m_46597_(this.targetPos, state);
                        SoundType soundtype = state.m_60827_();
                        pLevel.m_5594_(null, this.targetPos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                        pOwner.m_6274_().m_21879_(ModMemoryModules.PLACED_PRESENT.get(), (Object)true);
                        BlockEntity blockEntity = pLevel.m_7702_(this.targetPos);
                        if (blockEntity instanceof PresentBlockTile) {
                            PresentBlockTile tile = (PresentBlockTile)blockEntity;
                            tile.m_59626_(SnowySpirit.res("chests/present_villager"), pLevel.m_213780_().m_188505_());
                            tile.setSender(pOwner.m_7755_().getString());
                        }
                    }
                    this.targetPos = null;
                }
            }
        }
    }

    @Nullable
    private static BlockPos getValidPlacementPos(ServerLevel pLevel, LivingEntity pWalker) {
        RandomSource random = pWalker.m_217043_();
        Optional v = pWalker.m_6274_().m_21952_(MemoryModuleType.f_26362_);
        if (v.isEmpty()) {
            return null;
        }
        BlockPos meeting = ((GlobalPos)v.get()).m_122646_();
        for (int i = 0; i < 6; ++i) {
            BlockPos pos = meeting.m_7918_(random.m_188503_(20) - 10, random.m_188503_(6) - 3, random.m_188503_(20) - 10);
            if (!PlacePresentTask.isValidPlacementSpot(pLevel, pos)) continue;
            return pos;
        }
        return null;
    }

    public static boolean isValidPlacementSpot(ServerLevel serverLevel, BlockPos pos) {
        BlockState state;
        if (serverLevel.m_45527_(pos) && (double)serverLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() >= (double)(serverLevel.m_5736_() - 10) && (state = serverLevel.m_8055_(pos)).m_247087_() && state.m_60819_().m_76178_()) {
            BlockState below = serverLevel.m_8055_(pos.m_7495_());
            return below.m_60783_((BlockGetter)serverLevel, pos, Direction.UP) || below.m_204336_(BlockTags.f_144274_);
        }
        return false;
    }

    public ItemStack getRandomPresent(RandomSource random) {
        return ((Block)((Supplier)ModRegistry.PRESENTS.get(DyeColor.values()[random.m_188503_(DyeColor.values().length)])).get()).m_5456_().m_7968_();
    }

    public static void clearHeldItem(Villager self) {
        self.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        self.m_21409_(EquipmentSlot.MAINHAND, 0.085f);
    }

    public static void displayAsHeldItem(Villager self, ItemStack stack) {
        self.m_8061_(EquipmentSlot.MAINHAND, stack);
        self.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }
}

