/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.ai.ILNearestAttackableTargetGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.setup.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Minions", description="Elder Guardians will spawn Elder Minions.")
@LoadFeature(module="progressivebosses:elder_guardian")
public class MinionFeature
extends Feature {
    @Config(min=0.0)
    @Label(name="Base Cooldown", description="Elder Guardians will spawn Elder Minions every this tick value (20 ticks = 1 sec).")
    public static Integer baseCooldown = 200;
    @Config(min=0.0)
    @Label(name="Cooldown Reduction per Missing Elder", description="The base cooldown is reduced by this value for each missing Elder Guardian.")
    public static Integer cooldownReductionPerMissingElder = 60;

    public MinionFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onElderGuardianSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)entity;
        CompoundTag nbt = elderGuardian.getPersistentData();
        nbt.m_128405_("progressivebosses:elder_minion_cooldown", baseCooldown.intValue());
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        if (event.getEntity().m_9236_().f_46443_ || !this.isEnabled() || !((livingEntity = event.getEntity()) instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)livingEntity;
        Level world = event.getEntity().m_9236_();
        CompoundTag elderGuardianTags = elderGuardian.getPersistentData();
        if (elderGuardian.m_21223_() <= 0.0f) {
            return;
        }
        int cooldown = elderGuardianTags.m_128451_("progressivebosses:elder_minion_cooldown");
        if (cooldown > 0) {
            elderGuardianTags.m_128405_("progressivebosses:elder_minion_cooldown", cooldown - 1);
            return;
        }
        cooldown = baseCooldown - cooldownReductionPerMissingElder * elderGuardian.getPersistentData().m_128451_("progressivebosses:difficulty");
        elderGuardianTags.m_128405_("progressivebosses:elder_minion_cooldown", cooldown);
        int radius = 24;
        BlockPos pos1 = elderGuardian.m_20183_().m_7918_(-radius, -radius, -radius);
        BlockPos pos2 = elderGuardian.m_20183_().m_7918_(radius, radius, radius);
        AABB bb = new AABB(pos1, pos2);
        List players = world.m_45976_(ServerPlayer.class, bb);
        if (players.isEmpty()) {
            return;
        }
        List minionsInAABB = world.m_6443_(Guardian.class, elderGuardian.m_20191_().m_82400_(12.0), entity -> entity.getPersistentData().m_128441_("progressivebosses:elder_minion"));
        int minionsCountInAABB = minionsInAABB.size();
        if (minionsCountInAABB >= 5) {
            return;
        }
        MinionFeature.summonMinion(world, new Vec3(elderGuardian.m_20185_(), elderGuardian.m_20186_(), elderGuardian.m_20189_()));
    }

    public static void summonMinion(Level world, Vec3 pos) {
        Guardian elderMinion = new Guardian(EntityType.f_20455_, world);
        CompoundTag minionTags = elderMinion.getPersistentData();
        minionTags.m_128379_("mobspropertiesrandomness:processed", true);
        minionTags.m_128379_("progressivebosses:elder_minion", true);
        elderMinion.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        elderMinion.m_6593_((Component)Component.m_237115_((String)"progressivebosses:elder_minion"));
        elderMinion.f_21355_ = BuiltInLootTables.f_78712_;
        MCUtils.applyModifier((LivingEntity)elderMinion, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)Strings.AttributeModifiers.SWIM_SPEED_BONUS_UUID, (String)"progressivebosses:swim_speed_bonus", (double)2.0, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        for (WrappedGoal prioritizedGoal : elderMinion.f_21346_.f_25345_) {
            if (!(prioritizedGoal.m_26015_() instanceof NearestAttackableTargetGoal)) continue;
            goalsToRemove.add(prioritizedGoal.m_26015_());
        }
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)elderMinion.f_21345_).m_25363_(arg_0));
        elderMinion.f_21346_.m_25352_(1, (Goal)new ILNearestAttackableTargetGoal((Mob)elderMinion, Player.class, false).setIgnoreLineOfSight());
        world.m_7967_((Entity)elderMinion);
    }
}

