/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.network;

import com.alexander.whatareyouvotingfor.events.HandleWolfArmourEvents;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncWolfArmourToClientPacket {
    private final int entityID;
    private final boolean hasArmour;

    public SyncWolfArmourToClientPacket(int entityID, boolean hasArmour) {
        this.entityID = entityID;
        this.hasArmour = hasArmour;
    }

    public SyncWolfArmourToClientPacket(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.hasArmour = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.hasArmour);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> HandleWolfArmourEvents.addNewUpdate(this.entityID, this.hasArmour));
        return true;
    }
}

