/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moyai.forge;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.moyai.MoyaiHeadLayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="moyai", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class MoyaiClientForge {
    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        MoyaiClientForge.addLayer(event.getRenderer(EntityType.f_20460_));
    }

    private static <T extends LivingEntity, M extends HierarchicalModel<T>, R extends LivingEntityRenderer<T, M>> void addLayer(@Nullable R renderer) {
        if (renderer != null) {
            renderer.m_115326_(new MoyaiHeadLayer(renderer));
        }
    }

    @Mod.EventBusSubscriber(modid="moyai", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Rumbler {
        private static final int SHAKE_DURATION = 40;
        private static final int MAX_DIST = 16;
        private static final Map<BlockPos, Float> CACHED_POS = new HashMap<BlockPos, Float>();
        private static float animationCounter = 0.0f;

        public static void setShaking(BlockPos pos, int note) {
            float n = 1.0f - (float)note / 24.0f;
            LocalPlayer p = Minecraft.m_91087_().f_91074_;
            if (p != null) {
                CACHED_POS.put(pos, Float.valueOf(40.0f * (0.75f * (n - 0.5f) + 1.0f)));
            }
        }

        private static double getIntensity(BlockPos pos, Player player) {
            double dist = player.m_20182_().m_82531_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            return Math.max(0.0, 256.0 - dist) / 256.0;
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                animationCounter += 1.0f;
            }
        }

        @SubscribeEvent
        public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
            LocalPlayer p = Minecraft.m_91087_().f_91074_;
            if (p != null && !Minecraft.m_91087_().m_91104_()) {
                double maxIntensity = 0.0;
                HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
                for (Map.Entry<BlockPos, Float> e : CACHED_POS.entrySet()) {
                    BlockPos pos = e.getKey();
                    maxIntensity = Math.max(maxIntensity, Rumbler.getIntensity(pos, (Player)p));
                    float duration = e.getValue().floatValue();
                    if ((duration = (float)((double)duration - event.getPartialTick())) < 0.0f) {
                        toRemove.add(pos);
                        continue;
                    }
                    CACHED_POS.put(pos, Float.valueOf(duration));
                }
                toRemove.forEach(CACHED_POS::remove);
                if (maxIntensity != 0.0) {
                    event.setRoll((float)((double)event.getRoll() + (double)(Mth.m_14031_((float)((float)(((double)animationCounter + event.getPartialTick()) / 3.0 % 1.0 * 2.0 * Math.PI))) * 1.5f) * maxIntensity));
                }
            }
        }
    }
}

