/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.reg.ModBlocks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class SaltBucketItem
extends Item {
    public SaltBucketItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level level, List<Component> tooltip, TooltipFlag context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.spelunkery.salt_bucket_1", (Object[])new Object[]{this.getSaltToPlace(stack)}).m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.WHITE})));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.salt_bucket_2").m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})));
        }
    }

    public void setAmount(ItemStack stack, int amount) {
        stack.m_41784_().m_128405_("salt", amount);
    }

    public int getAmount(ItemStack stack) {
        return stack.m_41784_().m_128451_("salt");
    }

    public int getSaltToPlace(ItemStack stack) {
        return switch (this.getAmount(stack)) {
            default -> 8;
            case 1 -> 7;
            case 2 -> 6;
            case 3 -> 5;
            case 4 -> 4;
            case 5 -> 3;
            case 6 -> 2;
            case 7 -> 1;
        };
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult interactionResult = this.place(new BlockPlaceContext(context));
        if (!interactionResult.m_19077_() && this.m_41472_()) {
            InteractionResult interactionResult2 = this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
            return interactionResult2 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : interactionResult2;
        }
        return interactionResult;
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockPlaceContext = this.updatePlacementContext(context);
        if (blockPlaceContext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockState = this.getPlacementState(blockPlaceContext);
        if (blockState == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockPlaceContext, blockState)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        Player player = blockPlaceContext.m_43723_();
        ItemStack itemStack = blockPlaceContext.m_43722_();
        BlockState blockState2 = level.m_8055_(blockPos);
        if (blockState2.m_60713_(blockState.m_60734_())) {
            blockState2 = this.updateBlockStateFromTag(blockPos, level, itemStack, blockState2);
            this.updateCustomBlockEntityTag(blockPos, level, player, itemStack, blockState2);
            blockState2.m_60734_().m_6402_(level, blockPos, blockState2, (LivingEntity)player, itemStack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockPos, itemStack);
            }
        }
        SoundType soundType = blockState2.m_60827_();
        level.m_5594_(player, blockPos, this.getPlaceSound(blockState2), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        level.m_220407_(GameEvent.f_157797_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState2));
        if (player == null || !player.m_150110_().f_35937_) {
            if (this.getAmount(itemStack) < 7) {
                this.setAmount(itemStack, this.getAmount(itemStack) + 1);
            } else {
                player.m_21008_(context.m_43724_(), Items.f_42446_.m_7968_());
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected SoundEvent getPlaceSound(BlockState state) {
        return state.m_60827_().m_56777_();
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        return context;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        return SaltBucketItem.updateCustomBlockEntityTag(level, player, pos, stack);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState blockState = this.getBlock().m_5573_(context);
        return blockState != null && this.canPlace(context, blockState) ? blockState : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos pos, Level level, ItemStack stack, BlockState state) {
        BlockState blockState = state;
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag != null) {
            CompoundTag compoundTag2 = compoundTag.m_128469_("BlockStateTag");
            StateDefinition stateDefinition = state.m_60734_().m_49965_();
            for (String string : compoundTag2.m_128431_()) {
                Property property = stateDefinition.m_61081_(string);
                if (property == null) continue;
                String string2 = compoundTag2.m_128423_(string).m_7916_();
                blockState = SaltBucketItem.updateState(blockState, property, string2);
            }
        }
        if (blockState != state) {
            level.m_7731_(pos, blockState, 2);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> property, String valueIdentifier) {
        return property.m_6215_(valueIdentifier).map(comparable -> (BlockState)state.m_61124_(property, comparable)).orElse(state);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.m_43723_();
        CollisionContext collisionContext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return (!this.mustSurvive() || state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) && context.m_43725_().m_45752_(state, context.m_8083_(), collisionContext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 11);
    }

    public static boolean updateCustomBlockEntityTag(Level level, @Nullable Player player, BlockPos pos, ItemStack stack) {
        BlockEntity blockEntity;
        MinecraftServer minecraftServer = level.m_7654_();
        if (minecraftServer == null) {
            return false;
        }
        CompoundTag compoundTag = SaltBucketItem.getBlockEntityData(stack);
        if (compoundTag != null && (blockEntity = level.m_7702_(pos)) != null) {
            if (!(level.f_46443_ || !blockEntity.m_6326_() || player != null && player.m_36337_())) {
                return false;
            }
            CompoundTag compoundTag2 = blockEntity.m_187482_();
            CompoundTag compoundTag3 = compoundTag2.m_6426_();
            compoundTag2.m_128391_(compoundTag);
            if (!compoundTag2.equals((Object)compoundTag3)) {
                blockEntity.m_142466_(compoundTag2);
                blockEntity.m_6596_();
                return true;
            }
        }
        return false;
    }

    public Block getBlock() {
        return ModBlocks.SALT.get();
    }

    @Nullable
    public static CompoundTag getBlockEntityData(ItemStack stack) {
        return stack.m_41737_("BlockEntityTag");
    }
}

