/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.textures.mipmaps;

import com.mojang.blaze3d.platform.NativeImage;
import me.jellysquid.mods.sodium.client.util.NativeImageHelper;
import me.jellysquid.mods.sodium.client.util.color.ColorSRGB;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={SpriteContents.class})
public class SpriteContentsMixin {
    @Mutable
    @Shadow
    @Final
    private NativeImage f_243904_;

    @Redirect(method={"<init>(Lnet/minecraft/util/Identifier;Lnet/minecraft/client/texture/SpriteDimensions;Lnet/minecraft/client/texture/NativeImage;Lnet/minecraft/client/resource/metadata/AnimationResourceMetadata;Lnet/minecraftforge/client/textures/ForgeTextureMetadata;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/texture/SpriteContents;image:Lnet/minecraft/client/texture/NativeImage;", opcode=181))
    private void sodium$beforeGenerateMipLevels(SpriteContents instance, NativeImage nativeImage, ResourceLocation identifier) {
        SpriteContentsMixin.sodium$fillInTransparentPixelColors(nativeImage);
        this.f_243904_ = nativeImage;
    }

    @Unique
    private static void sodium$fillInTransparentPixelColors(NativeImage nativeImage) {
        long ppPixel = NativeImageHelper.getPointerRGBA(nativeImage);
        int pixelCount = nativeImage.m_85084_() * nativeImage.m_84982_();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float totalWeight = 0.0f;
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            long pPixel = ppPixel + (long)(pixelIndex * 4);
            int color = MemoryUtil.memGetInt((long)pPixel);
            int alpha = FastColor.ABGR32.m_266503_((int)color);
            if (alpha == 0) continue;
            float weight = alpha;
            r += ColorSRGB.srgbToLinear(FastColor.ABGR32.m_266313_((int)color)) * weight;
            g += ColorSRGB.srgbToLinear(FastColor.ABGR32.m_266446_((int)color)) * weight;
            b += ColorSRGB.srgbToLinear(FastColor.ABGR32.m_266247_((int)color)) * weight;
            totalWeight += weight;
        }
        if (totalWeight == 0.0f) {
            return;
        }
        int averageColor = ColorSRGB.linearToSrgb(r /= totalWeight, g /= totalWeight, b /= totalWeight, 0);
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            long pPixel = ppPixel + (long)(pixelIndex * 4);
            int color = MemoryUtil.memGetInt((long)pPixel);
            int alpha = FastColor.ABGR32.m_266503_((int)color);
            if (alpha != 0) continue;
            MemoryUtil.memPutInt((long)pPixel, (int)averageColor);
        }
    }
}

