/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.world.ReadableContainerExtended;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorCache;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorSource;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorView;
import me.jellysquid.mods.sodium.client.world.biome.BiomeSlice;
import me.jellysquid.mods.sodium.client.world.biome.ColorResolverCache;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import org.embeddedt.embeddium.api.ChunkMeshEvent;
import org.embeddedt.embeddium.api.MeshAppender;
import org.jetbrains.annotations.Nullable;

public class WorldSlice
implements BlockAndTintGetter,
BiomeColorView {
    private static final LightLayer[] LIGHT_TYPES = LightLayer.values();
    private static final int SECTION_BLOCK_COUNT = 4096;
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private static final int NEIGHBOR_CHUNK_RADIUS = Mth.m_144941_((int)2, (int)16) >> 4;
    private static final int SECTION_ARRAY_LENGTH = 1 + NEIGHBOR_CHUNK_RADIUS * 2;
    private static final int SECTION_ARRAY_SIZE = SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH;
    private static final int LOCAL_XYZ_BITS = 4;
    private static final BlockState EMPTY_BLOCK_STATE = Blocks.f_50016_.m_49966_();
    public final ClientLevel world;
    private final BiomeSlice biomeSlice;
    private final BiomeColorCache biomeColors;
    private final ColorResolverCache biomeColorsLegacy;
    private final BlockState[][] blockArrays;
    @Nullable
    private final DataLayer[][] lightArrays;
    @Nullable
    private final Int2ReferenceMap<BlockEntity>[] blockEntityArrays;
    private int originX;
    private int originY;
    private int originZ;
    private BoundingBox volume;

    public static ChunkRenderContext prepare(Level world, SectionPos origin, ClonedChunkSectionCache sectionCache) {
        boolean isEmpty;
        LevelChunk chunk = world.m_6325_(origin.m_123341_(), origin.m_123343_());
        LevelChunkSection section = chunk.m_7103_()[world.m_151566_(origin.m_123342_())];
        List<MeshAppender> meshAppenders = ChunkMeshEvent.post(world, origin);
        boolean bl = isEmpty = (section == null || section.m_188008_()) && meshAppenders.isEmpty();
        if (isEmpty) {
            return null;
        }
        BoundingBox volume = new BoundingBox(origin.m_123229_() - 2, origin.m_123234_() - 2, origin.m_123239_() - 2, origin.m_123244_() + 2, origin.m_123247_() + 2, origin.m_123248_() + 2);
        int minChunkX = origin.m_123341_() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkY = origin.m_123342_() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkZ = origin.m_123343_() - NEIGHBOR_CHUNK_RADIUS;
        int maxChunkX = origin.m_123341_() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkY = origin.m_123342_() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkZ = origin.m_123343_() + NEIGHBOR_CHUNK_RADIUS;
        ClonedChunkSection[] sections = new ClonedChunkSection[SECTION_ARRAY_SIZE];
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    sections[WorldSlice.getLocalSectionIndex((int)(chunkX - minChunkX), (int)(chunkY - minChunkY), (int)(chunkZ - minChunkZ))] = sectionCache.acquire(chunkX, chunkY, chunkZ);
                }
            }
        }
        return new ChunkRenderContext(origin, sections, volume).withMeshAppenders(meshAppenders);
    }

    public WorldSlice(ClientLevel world) {
        this.world = world;
        this.blockArrays = new BlockState[SECTION_ARRAY_SIZE][4096];
        this.lightArrays = new DataLayer[SECTION_ARRAY_SIZE][LIGHT_TYPES.length];
        this.blockEntityArrays = new Int2ReferenceMap[SECTION_ARRAY_SIZE];
        this.biomeSlice = new BiomeSlice();
        this.biomeColors = new BiomeColorCache(this.biomeSlice, (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_());
        this.biomeColorsLegacy = new ColorResolverCache(this.biomeSlice, (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_());
        for (Object[] objectArray : this.blockArrays) {
            Arrays.fill(objectArray, EMPTY_BLOCK_STATE);
        }
    }

    public void copyData(ChunkRenderContext context) {
        this.originX = context.getOrigin().m_123341_() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.originY = context.getOrigin().m_123342_() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.originZ = context.getOrigin().m_123343_() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.volume = context.getVolume();
        for (int x = 0; x < SECTION_ARRAY_LENGTH; ++x) {
            for (int y = 0; y < SECTION_ARRAY_LENGTH; ++y) {
                for (int z = 0; z < SECTION_ARRAY_LENGTH; ++z) {
                    this.copySectionData(context, WorldSlice.getLocalSectionIndex(x, y, z));
                }
            }
        }
        this.biomeSlice.update(this.world, context);
        this.biomeColors.update(context);
        this.biomeColorsLegacy.update(context);
    }

    private void copySectionData(ChunkRenderContext context, int sectionIndex) {
        ClonedChunkSection section = context.getSections()[sectionIndex];
        Objects.requireNonNull(section, "Chunk section must be non-null");
        this.unpackBlockData(this.blockArrays[sectionIndex], context, section);
        this.lightArrays[sectionIndex][LightLayer.BLOCK.ordinal()] = section.getLightArray(LightLayer.BLOCK);
        this.lightArrays[sectionIndex][LightLayer.SKY.ordinal()] = section.getLightArray(LightLayer.SKY);
        this.blockEntityArrays[sectionIndex] = section.getBlockEntityMap();
    }

    private void unpackBlockData(BlockState[] blockArray, ChunkRenderContext context, ClonedChunkSection section) {
        SectionPos pos;
        if (section.getBlockData() == null) {
            Arrays.fill(blockArray, EMPTY_BLOCK_STATE);
            return;
        }
        ReadableContainerExtended<BlockState> container = ReadableContainerExtended.of(section.getBlockData());
        SectionPos origin = context.getOrigin();
        if (origin.equals((Object)(pos = section.getPosition()))) {
            container.sodium$unpack((BlockState[])blockArray);
        } else {
            BoundingBox bounds = context.getVolume();
            int minBlockX = Math.max(bounds.m_162395_(), pos.m_123229_());
            int maxBlockX = Math.min(bounds.m_162399_(), pos.m_123244_());
            int minBlockY = Math.max(bounds.m_162396_(), pos.m_123234_());
            int maxBlockY = Math.min(bounds.m_162400_(), pos.m_123247_());
            int minBlockZ = Math.max(bounds.m_162398_(), pos.m_123239_());
            int maxBlockZ = Math.min(bounds.m_162401_(), pos.m_123248_());
            container.sodium$unpack((BlockState[])blockArray, minBlockX & 0xF, minBlockY & 0xF, minBlockZ & 0xF, maxBlockX & 0xF, maxBlockY & 0xF, maxBlockZ & 0xF);
        }
    }

    public void reset() {
        for (int sectionIndex = 0; sectionIndex < SECTION_ARRAY_LENGTH; ++sectionIndex) {
            Arrays.fill(this.lightArrays[sectionIndex], null);
            this.blockEntityArrays[sectionIndex] = null;
        }
    }

    public BlockState m_8055_(BlockPos pos) {
        return this.getBlockState(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public BlockState getBlockState(int x, int y, int z) {
        if (!this.volume.m_260866_(x, y, z)) {
            return EMPTY_BLOCK_STATE;
        }
        int relX = x - this.originX;
        int relY = y - this.originY;
        int relZ = z - this.originZ;
        return this.blockArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)][WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF)];
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    public float m_7717_(Direction direction, boolean shaded) {
        return this.world.m_7717_(direction, shaded);
    }

    public LevelLightEngine m_5518_() {
        throw new UnsupportedOperationException();
    }

    public int m_45517_(LightLayer type, BlockPos pos) {
        int relZ;
        int relY;
        if (!this.volume.m_260866_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
            return 0;
        }
        int relX = pos.m_123341_() - this.originX;
        DataLayer lightArray = this.lightArrays[WorldSlice.getLocalSectionIndex(relX >> 4, (relY = pos.m_123342_() - this.originY) >> 4, (relZ = pos.m_123343_() - this.originZ) >> 4)][type.ordinal()];
        if (lightArray == null) {
            return 0;
        }
        return lightArray.m_62560_(relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public int m_45524_(BlockPos pos, int ambientDarkness) {
        if (!this.volume.m_260866_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
            return 0;
        }
        int relX = pos.m_123341_() - this.originX;
        int relY = pos.m_123342_() - this.originY;
        int relZ = pos.m_123343_() - this.originZ;
        DataLayer[] lightArrays = this.lightArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)];
        DataLayer skyLightArray = lightArrays[LightLayer.SKY.ordinal()];
        DataLayer blockLightArray = lightArrays[LightLayer.BLOCK.ordinal()];
        int localX = relX & 0xF;
        int localY = relY & 0xF;
        int localZ = relZ & 0xF;
        int skyLight = skyLightArray == null ? 0 : skyLightArray.m_62560_(localX, localY, localZ) - ambientDarkness;
        int blockLight = blockLightArray == null ? 0 : blockLightArray.m_62560_(localX, localY, localZ);
        return Math.max(blockLight, skyLight);
    }

    public BlockEntity m_7702_(BlockPos pos) {
        return this.getBlockEntity(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public BlockEntity getBlockEntity(int x, int y, int z) {
        if (!this.volume.m_260866_(x, y, z)) {
            return null;
        }
        int relX = x - this.originX;
        int relY = y - this.originY;
        int relZ = z - this.originZ;
        Int2ReferenceMap<BlockEntity> blockEntities = this.blockEntityArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)];
        if (blockEntities == null) {
            return null;
        }
        return (BlockEntity)blockEntities.get(WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF));
    }

    public int m_6171_(BlockPos pos, ColorResolver resolver) {
        BiomeColorSource source = BiomeColorSource.from(resolver);
        if (source != null) {
            return this.biomeColors.getColor(source, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        return this.biomeColorsLegacy.getColor(resolver, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public int m_141928_() {
        return this.world.m_141928_();
    }

    public int m_141937_() {
        return this.world.m_141937_();
    }

    @Override
    public int getColor(BiomeColorSource source, int x, int y, int z) {
        return this.biomeColors.getColor(source, x, y, z);
    }

    public static int getLocalBlockIndex(int x, int y, int z) {
        return y << 4 << 4 | z << 4 | x;
    }

    public static int getLocalSectionIndex(int x, int y, int z) {
        return y * SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH + z * SECTION_ARRAY_LENGTH + x;
    }
}

