/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.viewport;

import me.jellysquid.mods.sodium.client.render.viewport.CameraTransform;
import me.jellysquid.mods.sodium.client.render.viewport.frustum.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import org.joml.Vector3d;

public final class Viewport {
    private final Frustum frustum;
    private final CameraTransform transform;
    private final SectionPos chunkCoords;
    private final BlockPos blockCoords;

    public Viewport(Frustum frustum, Vector3d position) {
        this.frustum = frustum;
        this.transform = new CameraTransform(position.x, position.y, position.z);
        this.chunkCoords = SectionPos.m_123173_((int)SectionPos.m_175552_((double)position.x), (int)SectionPos.m_175552_((double)position.y), (int)SectionPos.m_175552_((double)position.z));
        this.blockCoords = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
    }

    public boolean isBoxVisible(int intX, int intY, int intZ, float radius) {
        float floatX = (float)(intX - this.transform.intX) - this.transform.fracX;
        float floatY = (float)(intY - this.transform.intY) - this.transform.fracY;
        float floatZ = (float)(intZ - this.transform.intZ) - this.transform.fracZ;
        return this.frustum.testAab(floatX - radius, floatY - radius, floatZ - radius, floatX + radius, floatY + radius, floatZ + radius);
    }

    public CameraTransform getTransform() {
        return this.transform;
    }

    public SectionPos getChunkCoord() {
        return this.chunkCoords;
    }

    public BlockPos getBlockCoord() {
        return this.blockCoords;
    }
}

