/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util;

import java.util.List;
import java.util.Set;
import net.minecraft.util.RandomSource;

public final class RandomUtil {
    public static final RandomSource RANDOM = RandomSource.m_216327_();

    public static int randomRange(int min, int max) {
        return RANDOM.m_188503_(max - min) + min;
    }

    public static double randomRange(double min, double max) {
        return min + (max - min) * RANDOM.m_188500_();
    }

    public static float randomDirection(float value) {
        return RANDOM.m_188499_() ? value : -value;
    }

    public static double randomDirection(double value) {
        return RANDOM.m_188499_() ? value : -value;
    }

    public static int randomDirection(int value) {
        return RANDOM.m_188499_() ? value : -value;
    }

    public static <T> T choose(T ... values) {
        return values[RANDOM.m_188503_(values.length)];
    }

    public static <T> T choose(List<T> values) {
        return values.get(RANDOM.m_188503_(values.size()));
    }

    public static <T> T choose(Set<T> values) {
        return values.stream().skip(RANDOM.m_188503_(values.size())).findFirst().orElse(null);
    }

    public static int randomBias(int min, int max) {
        int num = RandomUtil.randomRange(min, max);
        int mid = max / 2 - min / 2;
        int halfMid = mid / 2;
        if (num > mid) {
            num -= RANDOM.m_188503_(halfMid + 1);
        } else if (num < mid) {
            num += RANDOM.m_188503_(halfMid + 1);
        }
        return num;
    }

    private RandomUtil() {
    }
}

