/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.ai;

import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class BetterCrossbowAttackGoal<T extends Mob>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final T mob;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public BetterCrossbowAttackGoal(T mob, double d, float f) {
        this.mob = mob;
        this.speedModifier = d;
        this.attackRadiusSqr = f * f;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingCrossbow();
    }

    private boolean isHoldingCrossbow() {
        return this.mob.m_21055_(Items.f_42717_);
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingCrossbow();
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
            ((CrossbowAttackMob)this.mob).m_6136_(false);
            CrossbowItem.m_40884_((ItemStack)this.mob.m_21211_(), (boolean)false);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return;
        }
        boolean bl = this.mob.m_21574_().m_148306_((Entity)livingEntity);
        boolean bl2 = this.seeTime > 0;
        boolean bl4 = bl2;
        if (bl != bl2) {
            this.seeTime = 0;
        }
        this.seeTime = bl ? (this.seeTime = this.seeTime + 1) : (this.seeTime = this.seeTime - 1);
        double d = this.mob.m_20280_((Entity)livingEntity);
        boolean bl3 = (d > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
        boolean bl5 = bl3;
        if (bl3) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                this.mob.m_21573_().m_5624_((Entity)livingEntity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
            }
        } else {
            this.updatePathDelay = 0;
            this.mob.m_21573_().m_26573_();
        }
        this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            if (!bl3) {
                this.mob.m_6672_(ProjectileUtil.m_37297_(this.mob, (Item)Items.f_42717_));
                this.crossbowState = CrossbowState.CHARGING;
                ((CrossbowAttackMob)this.mob).m_6136_(true);
            }
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            ItemStack itemStack;
            int i;
            if (!this.mob.m_6117_()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((i = this.mob.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(itemStack = this.mob.m_21211_()))) {
                this.mob.m_21253_();
                this.crossbowState = CrossbowState.CHARGED;
                this.attackDelay = 20 + this.mob.m_217043_().m_188503_(20);
                ((CrossbowAttackMob)this.mob).m_6136_(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && bl) {
            ((RangedAttackMob)this.mob).m_6504_(livingEntity, 1.0f);
            ItemStack itemStack2 = this.mob.m_21120_(ProjectileUtil.m_37297_(this.mob, (Item)Items.f_42717_));
            CrossbowItem.m_40884_((ItemStack)itemStack2, (boolean)false);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

