/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import party.lemons.biomemakeover.init.BMEffects;
import party.lemons.biomemakeover.init.BMEntities;
import party.lemons.biomemakeover.level.PoltergeistHandler;

public class GhostEntity
extends Monster
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> IsCharging = SynchedEntityData.m_135353_(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt WANDER_RANGE_HORIZONTAL = UniformInt.m_146622_((int)-7, (int)7);
    private static final UniformInt WANDER_RANGE_VERTICAL = UniformInt.m_146622_((int)-5, (int)5);
    private static final double CHARGE_MIN_DISTANCE = 2.0;
    private static final double CHARGE_MAX_DISTANCE = 10.0;
    private static final int POLTERGEIST_RANGE = 10;
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    private int angerTime;
    private UUID targetUuid;
    private static final UniformInt REINFORCE_TIME_RANGE = TimeUtil.m_145020_((int)4, (int)6);
    private int reinforceTime;
    private static final UniformInt ANGER_SOUND_TIME_RANGE = TimeUtil.m_145020_((int)0, (int)1);
    private int angrySoundDelay;
    private BlockPos homePosition;

    public GhostEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new GhostMoveControl(this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PoltergeistGoal());
        this.f_21345_.m_25352_(4, (Goal)new ChargeTargetGoal());
        this.f_21345_.m_25352_(8, (Goal)new FlyAroundGoal());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((GhostEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IsCharging, (Object)false);
    }

    public void m_6478_(MoverType moverType, Vec3 vec3) {
        super.m_6478_(moverType, vec3);
        this.m_20101_();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
        if (this.getHomePosition() == null) {
            this.homePosition = this.m_20097_();
        }
    }

    private BlockPos getHomePosition() {
        return this.homePosition;
    }

    protected void m_8024_() {
        if (this.m_21660_()) {
            this.maybePlayFirstAngerSound();
        }
        this.m_21666_((ServerLevel)this.m_9236_(), true);
        if (this.m_5448_() != null) {
            this.checkAlertTime();
        }
        super.m_8024_();
    }

    private void checkAlertTime() {
        if (this.reinforceTime > 0) {
            --this.reinforceTime;
        } else {
            if (this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                this.alertNearby();
            }
            this.reinforceTime = REINFORCE_TIME_RANGE.m_214085_(this.f_19796_);
        }
    }

    private void maybePlayFirstAngerSound() {
        if (this.angrySoundDelay > 0) {
            --this.angrySoundDelay;
            if (this.angrySoundDelay == 0) {
                this.playAngerSound();
            }
        }
    }

    private void alertNearby() {
        double alertRange = this.m_21133_(Attributes.f_22277_);
        BlockPos pos = this.m_20097_();
        AABB alertBounds = AABB.m_82333_((Vec3)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_82377_(alertRange, 10.0, alertRange);
        this.m_9236_().m_45976_(GhostEntity.class, alertBounds).stream().filter(e -> e != this).filter(e -> e.m_5448_() == null).filter(e -> this.m_5448_() != null && !e.m_7307_((Entity)this.m_5448_())).forEach(e -> e.m_6710_(this.m_5448_()));
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (this.m_5448_() == null && target != null) {
            this.angrySoundDelay = ANGER_SOUND_TIME_RANGE.m_214085_(this.f_19796_);
            this.reinforceTime = REINFORCE_TIME_RANGE.m_214085_(this.f_19796_);
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            this.m_6598_(player);
        }
        super.m_6710_(target);
    }

    private void playAngerSound() {
        this.m_5496_(BMEffects.GHOST_ANGRY.get(), this.m_6121_() * 2.0f, this.m_6100_());
    }

    public void chooseRandomAngerTime() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int i) {
        this.angerTime = i;
    }

    @Nullable
    public UUID m_6120_() {
        return this.targetUuid;
    }

    public void m_6925_(@Nullable UUID uUID) {
        this.targetUuid = uUID;
    }

    public void m_6825_() {
        this.chooseRandomAngerTime();
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.m_21678_(compoundTag);
        if (this.getHomePosition() != null) {
            compoundTag.m_128405_("HomeX", this.homePosition.m_123341_());
            compoundTag.m_128405_("HomeY", this.homePosition.m_123342_());
            compoundTag.m_128405_("HomeZ", this.homePosition.m_123343_());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_147285_(this.m_9236_(), tag);
        if (tag.m_128441_("HomeX")) {
            this.homePosition = new BlockPos(tag.m_128451_("HomeX"), tag.m_128451_("HomeY"), tag.m_128451_("HomeZ"));
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(BMEntities.GHOST_IMMUNE_DAMAGE)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_21660_() ? BMEffects.GHOST_ANGRY.get() : BMEffects.GHOST_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return BMEffects.GHOST_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return BMEffects.GHOST_HURT.get();
    }

    private void setCharging(boolean charging) {
        this.m_20088_().m_135381_(IsCharging, (Object)charging);
    }

    public boolean isCharging() {
        return (Boolean)this.m_20088_().m_135370_(IsCharging);
    }

    public static boolean checkGhostSpawnRules(EntityType<GhostEntity> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return serverLevelAccessor.m_46791_() != Difficulty.PEACEFUL && GhostEntity.isDarkEnoughToSpawnGhost(serverLevelAccessor, blockPos, randomSource) && GhostEntity.m_217057_(entityType, (LevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean isDarkEnoughToSpawnGhost(ServerLevelAccessor serverLevelAccessor, BlockPos blockPos, RandomSource randomSource) {
        if (serverLevelAccessor.m_45517_(LightLayer.SKY, blockPos) > randomSource.m_188503_(32)) {
            return false;
        }
        DimensionType dimensionType = serverLevelAccessor.m_6042_();
        int i = 5;
        if (i < 15 && serverLevelAccessor.m_45517_(LightLayer.BLOCK, blockPos) > i) {
            return false;
        }
        int j = serverLevelAccessor.m_6018_().m_46470_() ? serverLevelAccessor.m_46849_(blockPos, 10) : serverLevelAccessor.m_46803_(blockPos);
        return j <= dimensionType.m_223569_().m_214085_(randomSource);
    }

    class GhostMoveControl
    extends MoveControl {
        private GhostMoveControl(GhostEntity owner) {
            super((Mob)owner);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 targetPosition = new Vec3(this.f_24975_ - GhostEntity.this.m_20185_(), this.f_24976_ - GhostEntity.this.m_20186_(), this.f_24977_ - GhostEntity.this.m_20189_());
                double length = targetPosition.m_82553_();
                if (length < GhostEntity.this.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    GhostEntity.this.m_20256_(GhostEntity.this.m_20184_().m_82490_(0.5));
                } else {
                    GhostEntity.this.m_20256_(GhostEntity.this.m_20184_().m_82549_(targetPosition.m_82490_(this.f_24978_ * 0.05 / length)));
                    if (GhostEntity.this.m_5448_() == null) {
                        if (EntitySelector.f_20406_.test(GhostEntity.this.m_5448_())) {
                            GhostEntity.this.m_6710_(null);
                        }
                        Vec3 vec3d2 = GhostEntity.this.m_20184_();
                        GhostEntity.this.m_146922_(-((float)Mth.m_14136_((double)vec3d2.f_82479_, (double)vec3d2.f_82481_)) * 57.295776f);
                        GhostEntity.this.f_20883_ = GhostEntity.this.m_146908_();
                    } else {
                        double e = GhostEntity.this.m_5448_().m_20185_() - GhostEntity.this.m_20185_();
                        double f = GhostEntity.this.m_5448_().m_20189_() - GhostEntity.this.m_20189_();
                        GhostEntity.this.m_146922_(-((float)Mth.m_14136_((double)e, (double)f)) * 57.295776f);
                        GhostEntity.this.f_20883_ = GhostEntity.this.m_146908_();
                    }
                }
            }
        }
    }

    private class PoltergeistGoal
    extends Goal {
        private PoltergeistGoal() {
        }

        public void m_8037_() {
            for (int i = 0; i < 4; ++i) {
                PoltergeistHandler.doPoltergeist(GhostEntity.this.m_9236_(), (Entity)GhostEntity.this, GhostEntity.this.m_20183_(), 10);
            }
            super.m_8037_();
        }

        public boolean m_8036_() {
            return true;
        }

        public boolean m_8045_() {
            return false;
        }
    }

    class ChargeTargetGoal
    extends Goal {
        private ChargeTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (GhostEntity.this.m_5448_() != null && !GhostEntity.this.m_21566_().m_24995_() && GhostEntity.this.f_19796_.m_188503_(2) == 0) {
                return GhostEntity.this.m_20280_((Entity)GhostEntity.this.m_5448_()) > 2.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return GhostEntity.this.m_21566_().m_24995_() && GhostEntity.this.isCharging() && GhostEntity.this.m_5448_() != null && GhostEntity.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity target = GhostEntity.this.m_5448_();
            Vec3 targetPosition = target.m_20299_(1.0f);
            GhostEntity.this.f_21342_.m_6849_(targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_, 1.25);
            GhostEntity.this.setCharging(true);
            GhostEntity.this.m_5496_(BMEffects.GHOST_CHARGE.get(), 1.0f, 1.0f);
        }

        public void m_8041_() {
            GhostEntity.this.setCharging(false);
        }

        public void m_8037_() {
            LivingEntity target = GhostEntity.this.m_5448_();
            if (EntitySelector.f_20406_.test(target)) {
                GhostEntity.this.m_6710_(null);
            }
            if (GhostEntity.this.m_20191_().m_82400_(2.0).m_82381_(target.m_20191_())) {
                GhostEntity.this.m_7327_((Entity)target);
                GhostEntity.this.setCharging(false);
            } else {
                double distance = GhostEntity.this.m_20280_((Entity)target);
                if (distance < 10.0) {
                    Vec3 vec3d = target.m_20299_(1.0f);
                    GhostEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
                }
            }
        }
    }

    class FlyAroundGoal
    extends Goal {
        private FlyAroundGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !GhostEntity.this.m_21566_().m_24995_() && GhostEntity.this.f_19796_.m_188503_(2) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            if (GhostEntity.this.getHomePosition() == null) {
                GhostEntity.this.homePosition = GhostEntity.this.m_20097_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos randomTarget = GhostEntity.this.homePosition.m_7918_(WANDER_RANGE_HORIZONTAL.m_214085_(GhostEntity.this.f_19796_), WANDER_RANGE_VERTICAL.m_214085_(GhostEntity.this.f_19796_), WANDER_RANGE_HORIZONTAL.m_214085_(GhostEntity.this.f_19796_));
                if (!GhostEntity.this.m_9236_().m_46859_(randomTarget)) continue;
                GhostEntity.this.f_21342_.m_6849_((double)randomTarget.m_123341_() + 0.5, (double)randomTarget.m_123342_() + 0.5, (double)randomTarget.m_123343_() + 0.5, 0.25);
                if (GhostEntity.this.m_5448_() != null) break;
                GhostEntity.this.m_21563_().m_24950_((double)randomTarget.m_123341_() + 0.5, (double)randomTarget.m_123342_() + 0.5, (double)randomTarget.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

