/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiCheckBox
extends GuiLabel {
    @OnlyIn(value=Dist.CLIENT)
    private static StyleDisplay PARTIAL_STYLE;
    public static final int CHECKBOX_WIDTH = 7;
    public boolean value = false;
    public String title;
    public boolean partial = false;
    public Consumer<Boolean> changed;

    public GuiCheckBox(String name, boolean value) {
        super(name);
        this.value = value;
    }

    public GuiCheckBox consumeChanged(Consumer<Boolean> changed) {
        this.changed = changed;
        return this;
    }

    @Override
    public GuiCheckBox setTranslate(String translate) {
        return (GuiCheckBox)super.setTranslate(translate);
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return super.preferredWidth(availableWidth) + 7 + 3;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return Math.max(10, super.preferredHeight(width, availableHeight));
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT_NO_DISABLE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        int yoffset = 0;
        PoseStack pose = graphics.m_280168_();
        GuiStyle style = this.getStyle();
        if (!this.enabled) {
            style.disabled.render(pose, 0.0, yoffset, 7.0, 7.0);
        }
        style.get(ControlFormatting.ControlStyleBorder.SMALL).render(pose, 0.0, yoffset, 7.0, 7.0);
        style.get(ControlFormatting.ControlStyleFace.NESTED_BACKGROUND, rect.inside(mouseX, mouseY)).render(pose, 1.0, yoffset + 1, 5.0, 5.0);
        if (this.value) {
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, "x", 1, yoffset - 1, this.enabled ? -1 : style.fontColorHighlight.toInt(), false);
        } else if (this.partial) {
            if (PARTIAL_STYLE == null) {
                PARTIAL_STYLE = new DisplayColor();
            }
            PARTIAL_STYLE.render(pose, 2.0, yoffset + 2, 3.0, 3.0);
        }
        pose.m_85836_();
        pose.m_252880_(10.0f, 0.0f, 0.0f);
        this.text.render(pose);
        pose.m_85849_();
    }

    public void set(boolean value) {
        if (this.value == value) {
            return;
        }
        this.value = value;
        this.raiseEvent(new GuiControlChangedEvent(this));
        if (this.changed != null) {
            this.changed.accept(value);
        }
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        GuiCheckBox.playSound((Holder.Reference<SoundEvent>)SoundEvents.f_12490_);
        this.set(!this.value);
        return true;
    }
}

