/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.misc;

import net.minecraft.world.phys.Vec3;

public class VoronoiGenerator {
    private long seed;
    private double offsetAmount = 1.0;
    private static final int PrimeX = 501125321;
    private static final int PrimeY = 1136930381;
    private static final int PrimeZ = 1720413743;
    private static final double[] RandVecs2D = new double[]{-0.2700222134590149, -0.9628540873527527, 0.38630926609039307, -0.9223693013191223, 0.04444859176874161, -0.9990116953849792, -0.5992523431777954, -0.8005602359771729, -0.781928f, 0.6233687400817871, 0.9464672207832336, 0.3227999210357666, -0.651414692401886, -0.7587218880653381, 0.9378472566604614, 0.3470483720302582, -0.8497875928878784, -0.5271252393722534, -0.8790425658226013, 0.47674325108528137, -0.8923003077507019, -0.4514423608779907, -0.37984442710876465, -0.9250503778457642, -0.9951651096343994, 0.09821637719869614, 0.7724397778511047, -0.635088f, 0.7573283314704895, -0.6530343294143677, -0.9928004741668701, -0.1197800561785698, -0.05326656997203827, 0.9985803365707397, 0.9754253625869751, -0.22033007442951202, -0.7665018439292908, 0.6422421336174011, 0.9916366934776306, 0.12906061112880707, -0.994696855545044, 0.10285037755966187, -0.5379205346107483, -0.8429955244064331, 0.5022815465927124, -0.8647041320800781, 0.45598214864730835, -0.889988899230957, -0.8659130930900574, -0.5001944303512573, 0.0879458412528038, -0.9961252808570862, -0.5051684975624084, 0.8630207180976868, 0.7753185033798218, -0.6315703988075256, -0.6921944618225098, 0.7217110395431519, -0.5191659331321716, -0.854673445224762, 0.8978623151779175, -0.4402764141559601, -0.17067740857601166, 0.9853269457817078, -0.935343f, -0.3537420630455017, -0.9992404580116272, 0.03896746784448624, -0.2882064f, -0.9575682878494263, -0.9663811326026917, 0.2571138f, -0.8759714365005493, -0.4823630154132843, -0.8303123116493225, -0.5572983622550964, 0.05110133811831474, -0.9986934661865234, -0.855837345123291, -0.5172450542449951, 0.09887025505304337, 0.9951003193855286, 0.9189016222953796, 0.39448678493499756, -0.24393758177757263, -0.9697909355163574, -0.812140941619873, -0.5834612846374512, -0.9910431504249573, 0.13354213535785675, 0.8492423892021179, -0.5280031561851501, -0.9717838764190674, -0.23587295413017273, 0.9949457049369812, 0.1004142090678215, 0.6241065263748169, -0.7813392281532288, 0.6629102826118469, 0.7486988306045532, -0.7197418212890625, 0.6942418217658997, -0.8143370747566223, -0.5803922414779663, 0.10452105104923248, -0.9945226907730103, -0.10659261047840118, -0.9943027496337891, 0.44579967856407166, -0.8951327800750732, 0.10554740577936172, 0.9944142699241638, -0.9927902817726135, 0.11986444890499115, -0.8334366679191589, 0.5526150465011597, 0.9115561842918396, -0.4111756f, 0.8285545110702515, -0.5599084496498108, 0.7217097878456116, -0.6921957731246948, 0.4940492808818817, -0.8694338798522949, -0.3652321398258209, -0.9309164881706238, -0.9696606993675232, 0.24445484578609467, 0.08925509452819824, -0.9960088133811951, 0.5354071259498596, -0.8445941209793091, -0.10535761713981628, 0.9944344162940979, -0.9890284538269043, 0.1477251f, 0.004856104962527752, 0.9999881982803345, 0.9885598421096802, 0.15082913637161255, 0.9286129474639893, -0.37104982137680054, -0.5832393765449524, -0.8123003244400024, 0.30152076482772827, 0.953459620475769, -0.9575110673904419, 0.28839656710624695, 0.9715802073478699, -0.2367105484008789, 0.2299818f, 0.97319495677948, 0.9557638168334961, -0.2941352128982544, 0.7409561276435852, 0.6715534329414368, -0.9971513748168945, -0.07542631030082703, 0.6905710697174072, -0.7232645153999329, -0.2907137f, -0.9568101167678833, 0.5912777781486511, -0.8064679503440857, -0.945459246635437, -0.3257404863834381, 0.6664455533027649, 0.7455536723136902, 0.6236134767532349, 0.7817328572273254, 0.9126994013786316, -0.40863165259361267, -0.819176197052002, 0.5735419392585754, -0.8812745809555054, -0.4726046025753021, 0.995331346988678, 0.09651672840118408, 0.9855650663375854, -0.1692969650030136, -0.8495981097221375, 0.5274306535720825, 0.6174854040145874, -0.786582350730896, 0.8508156538009644, 0.5254642963409424, 0.9985032677650452, -0.0546925f, 0.19713716208934784, -0.9803759455680847, 0.6607855558395386, -0.7505747079849243, -0.030974941328167915, 0.9995201826095581, -0.6731660962104797, 0.73949134349823, -0.7195018529891968, -0.6944905519485474, 0.9727511405944824, 0.2318516f, 0.9997059106826782, -0.02425069f, 0.44217875599861145, -0.8969269394874573, 0.9981350898742676, -0.061043672263622284, -0.917366087436676, -0.39804455637931824, -0.8150056600570679, -0.579453f, -0.8789331316947937, 0.476945f, 0.015860583633184433, 0.9998742341995239, -0.8095464706420898, 0.5870558023452759, -0.9165899157524109, -0.3998286724090576, -0.8023542761802673, 0.5968480706214905, -0.5176737904548645, 0.8555780649185181, -0.8154407143592834, -0.5788405537605286, 0.4022010266780853, -0.9155513644218445, -0.9052556753158569, -0.4248672127723694, 0.7317445874214172, 0.681579f, -0.5647632479667664, -0.825253f, -0.8403276205062866, -0.5420788526535034, -0.9314281344413757, 0.3639252483844757, 0.5238198637962341, 0.8518290519714355, 0.7432804107666016, -0.66898f, -0.9853715896606445, -0.17041973769664764, 0.46014687418937683, 0.8878428339958191, 0.8258553743362427, 0.5638819336891174, 0.6182366013526917, 0.785992f, 0.8331502676010132, -0.5530466437339783, 0.15003074705600739, 0.9886813163757324, -0.6623303890228271, -0.7492119073867798, -0.6685986518859863, 0.7436234354972839, 0.7025606036186218, 0.7116239070892334, -0.5419389605522156, -0.8404178619384766, -0.3388616442680359, 0.9408361911773682, 0.833153f, 0.5530425310134888, -0.29897207021713257, -0.954261839389801, 0.2638522982597351, 0.9645630717277527, 0.12410873919725418, -0.9922686219215393, -0.7282649278640747, -0.6852957010269165, 0.69625f, 0.7177993655204773, -0.9183535575866699, 0.395761f, -0.6326102018356323, -0.774470329284668, -0.9331892132759094, -0.35938552021980286, -0.11537793278694153, -0.9933216571807861, 0.951497495174408, -0.30765655636787415, -0.08987977355718613, -0.9959526062011719, 0.6678497195243835, 0.7442961931228638, 0.795240044593811, -0.6062946915626526, -0.6462007164955139, -0.7631675004959106, -0.27335986495018005, 0.9619118571281433, 0.966959f, -0.25493183732032776, -0.9792894721031189, 0.20246519148349762, -0.5369502902030945, -0.843613862991333, -0.2700364589691162, -0.9628500938415527, -0.6400277018547058, 0.7683518528938293, -0.785453736782074, -0.6189203858375549, 0.06005905568599701, -0.9981948137283325, -0.024557704105973244, 0.9996984004974365, -0.6598362326622009, 0.7514094710350037, -0.6253894567489624, -0.7803127765655518, -0.6210408806800842, -0.783778190612793, 0.8348888754844666, 0.5504185557365417, -0.15922752022743225, 0.9872419238090515, 0.8367622494697571, 0.5475663542747498, -0.8675754070281982, -0.497305691242218, -0.20226626098155975, -0.9793305397033691, 0.939919f, 0.34139755368232727, 0.9877404570579529, -0.1561049073934555, -0.9034455418586731, 0.42870283126831055, 0.12698042392730713, -0.9919052124023438, -0.3819601f, 0.9241788387298584, 0.9754626154899597, 0.22016525268554688, -0.3204015791416168, -0.9472818374633789, -0.987476110458374, 0.15776874125003815, 0.025353483855724335, -0.9996785521507263, 0.4835131f, -0.8753371238708496, -0.28508f, -0.9585037231445312, -0.068055160343647, -0.9976815581321716, -0.7885243892669678, -0.6150034666061401, 0.3185392f, -0.9479097127914429, 0.8880043029785156, 0.45983514189720154, 0.6476921439170837, -0.7619021534919739, 0.9820241332054138, 0.18875542283058167, 0.9357275366783142, -0.35272371768951416, -0.8894895315170288, 0.45695552229881287, 0.7922791242599487, 0.6101588010787964, 0.7483818531036377, 0.6632681488990784, -0.728892982006073, -0.6846276521682739, 0.8729032874107361, -0.487893283367157, 0.828834593296051, 0.5594937205314636, 0.08074566721916199, 0.9967347383499146, 0.9799148440361023, -0.1994165f, -0.580730676651001, -0.8140957355499268, -0.47000497579574585, -0.8826637864112854, 0.2409493f, 0.9705377221107483, 0.9437816739082336, -0.33056941628456116, -0.8927998542785645, -0.4504535496234894, -0.806962251663208, 0.5906030535697937, 0.06258973479270935, 0.9980393648147583, -0.9312597513198853, 0.36435598134994507, 0.5777449607849121, 0.8162173628807068, -0.3360096f, -0.9418585896492004, 0.6979320645332336, -0.7161639332771301, -0.002008157316595316, -0.999998f, -0.18272943794727325, -0.9831632375717163, -0.6523911952972412, 0.7578824162483215, -0.4302626848220825, -0.9027037024497986, -0.9985126256942749, -0.05452091246843338, -0.01028102170675993, -0.9999471306800842, -0.4946071207523346, 0.8691166639328003, -0.299935f, 0.9539596438407898, 0.8165472149848938, 0.5772786736488342, 0.2697460353374481, 0.9629315137863159, -0.7306287288665771, -0.6827749609947205, -0.7590951919555664, -0.6509796380996704, -0.9070538282394409, 0.4210146f, -0.5104861259460449, -0.859886f, 0.861335039138794, 0.5080373287200928, 0.500788152217865, -0.8655698895454407, -0.6541581749916077, 0.7563577890396118, -0.8382755517959595, -0.5452468395233154, 0.6940070986747742, 0.7199681997299194, 0.069509357213974, 0.9975813031196594, 0.17029422521591187, -0.9853932857513428, 0.2695973217487335, 0.9629731178283691, 0.5519612431526184, -0.8338697552680969, 0.2256575f, -0.9742066860198975, 0.4215262830257416, -0.9068161845207214, 0.48818734288215637, -0.8727388381958008, -0.3683854937553406, -0.9296731352806091, -0.9825390577316284, 0.186056450009346, 0.8125647306442261, 0.582871f, 0.3196461f, -0.947537f, 0.9570913910865784, 0.2897862493991852, -0.6876655220985413, -0.7260276079177856, -0.9988771080970764, -0.04737672954797745, -0.1250178962945938, 0.9921544790267944, -0.8280133605003357, 0.5607083439826965, 0.932486355304718, -0.361205130815506, 0.63946533203125, 0.7688199281692505, -0.016238471493124962, -0.9998681545257568, -0.9955014586448669, -0.09474613517522812, -0.8145331740379333, 0.580117f, 0.4037328064441681, -0.9148769378662109, 0.9944263100624084, 0.10543368011713028, -0.16247116029262543, 0.9867132902145386, -0.9949488043785095, -0.10038387775421143, -0.6995302438735962, 0.714603f, 0.5263414978981018, -0.8502732515335083, -0.5395221710205078, 0.8419713973999023, 0.6579370498657227, 0.7530729174613953, 0.014267588034272194, -0.9998981952667236, -0.6734383702278137, 0.7392433285713196, 0.6394121050834656, -0.7688642144203186, 0.9211571216583252, 0.3891908526420593, -0.1466372162103653, -0.9891903400421143, -0.782318115234375, 0.6228790879249573, -0.5039610862731934, -0.8637263774871826, -0.774312f, -0.632804f};
    private static final double[] RandVecs3D = new double[]{-0.7292736768722534, -0.6618439555168152, 0.17355819046497345, 0.0, 0.7902920842170715, -0.5480887293815613, -0.2739291f, 0.0, 0.7217578887939453, 0.6226212382316589, -0.3023380935192108, 0.0, 0.565683126449585, -0.8208298087120056, -0.07900002598762512, 0.0, 0.760049045085907, -0.5555979609489441, -0.33709996938705444, 0.0, 0.3713945746421814, 0.5011264681816101, 0.7816254496574402, 0.0, -0.12770624458789825, -0.4254438877105713, -0.8959289193153381, 0.0, -0.2881561f, -0.5815839171409607, 0.7607405781745911, 0.0, 0.5849561095237732, -0.6628202199935913, -0.4674352f, 0.0, 0.3307171165943146, 0.039165373891592026, 0.9429168701171875, 0.0, 0.8712121844291687, -0.4113374352455139, -0.26793816685676575, 0.0, 0.580981f, 0.7021915912628174, 0.4115677773952484, 0.0, 0.5037568807601929, 0.633005678653717, -0.5878204107284546, 0.0, 0.44937121868133545, 0.6013901829719543, 0.6606022715568542, 0.0, -0.6878404021263123, 0.0901889055967331, -0.7202371954917908, 0.0, -0.5958956480026245, -0.6469350457191467, 0.4757976531982422, 0.0, -0.5127052068710327, 0.1946921944618225, -0.8361987471580505, 0.0, -0.9911507368087769, -0.054102763533592224, -0.12121531367301941, 0.0, -0.2149721086025238, 0.9720882177352905, -0.09397608041763306, 0.0, -0.7518650889396667, -0.5428057312965393, 0.3742469549179077, 0.0, 0.5237069129943848, 0.8516377210617065, -0.02107817865908146, 0.0, 0.6333504915237427, 0.19261671602725983, -0.7495104670524597, 0.0, -0.06788241863250732, 0.39983057975769043, 0.9140719175338745, 0.0, -0.5538628697395325, -0.47298967838287354, -0.6852129101753235, 0.0, -0.7261455655097961, -0.5911991000175476, 0.3509933352470398, 0.0, -0.9229274988174438, -0.17828087508678436, 0.3412049412727356, 0.0, -0.6968814730644226, 0.6511274576187134, 0.300648033618927, 0.0, 0.9608044624328613, -0.20983631908893585, -0.18117249011993408, 0.0, 0.06817146390676498, -0.9743404984474182, 0.21450690925121307, 0.0, -0.357728511095047, -0.6697087287902832, -0.6507845520973206, 0.0, -0.18686211109161377, 0.7648617029190063, -0.6164974570274353, 0.0, -0.6541697382926941, 0.3967914879322052, 0.6439087390899658, 0.0, 0.699334f, -0.6164538264274597, 0.3618239164352417, 0.0, -0.15466657280921936, 0.6291283965110779, 0.7617583274841309, 0.0, -0.6841613054275513, -0.2580482065677643, -0.6821542382240295, 0.0, 0.5383980870246887, 0.42586550116539, 0.727163f, 0.0, -0.5026987791061401, -0.7939832806587219, -0.3418837f, 0.0, 0.3202971816062927, 0.28344154357910156, 0.9039195775985718, 0.0, 0.8683227300643921, -3.76265641534701E-4, -0.4959995150566101, 0.0, 0.7911200523376465, -0.08511045575141907, 0.6057105660438538, 0.0, -0.04011016f, -0.439724862575531, 0.8972364068031311, 0.0, 0.914512f, 0.3579346239566803, -0.1885487586259842, 0.0, -0.961203932762146, -0.27564841508865356, 0.010246668942272663, 0.0, 0.6510361433029175, -0.28777992725372314, -0.7023778557777405, 0.0, -0.20417863130569458, 0.7365237474441528, 0.6448596119880676, 0.0, -0.7718263864517212, 0.379062682390213, 0.5104855895042419, 0.0, -0.3060082793235779, -0.769298791885376, 0.5608371496200562, 0.0, 0.4540073275566101, -0.5024843215942383, 0.735789954662323, 0.0, 0.4816795587539673, 0.6021208167076111, -0.636738f, 0.0, 0.696198046207428, -0.32221972942352295, 0.6414691805839539, 0.0, -0.6532160639762878, -0.6781148910522461, 0.336851567029953, 0.0, 0.5089301466941833, -0.6154662370681763, -0.6018234491348267, 0.0, -0.16359198093414307, -0.9133604764938354, -0.37284088134765625, 0.0, 0.524080216884613, -0.8437663912773132, 0.11575058847665787, 0.0, 0.5902587175369263, 0.4983817934989929, -0.6349883675575256, 0.0, 0.5863227844238281, 0.4947647452354431, 0.6414307951927185, 0.0, 0.6779335141181946, 0.2341345250606537, 0.6968408823013306, 0.0, 0.7177054286003113, -0.685897946357727, 0.12017863243818283, 0.0, -0.532882f, -0.5205125212669373, 0.6671608090400696, 0.0, -0.8654873967170715, -0.0700727105140686, -0.4960053861141205, 0.0, -0.286181f, 0.7952089309692383, 0.5345495343208313, 0.0, -0.04849529638886452, 0.9810836315155029, -0.18741156160831451, 0.0, -0.6358521580696106, 0.6058348417282104, 0.47818002104759216, 0.0, 0.6254794597625732, -0.28616195917129517, 0.7258696556091309, 0.0, -0.258526f, 0.5061949491500854, -0.8227581977844238, 0.0, 0.021363068372011185, 0.5064016580581665, -0.862033f, 0.0, 0.2001117765903473, 0.8599263429641724, 0.4695550501346588, 0.0, 0.47435614466667175, 0.6014984846115112, -0.6427953243255615, 0.0, 0.662299394607544, -0.5202474594116211, -0.539168f, 0.0, 0.08084972947835922, -0.6532720327377319, 0.752794086933136, 0.0, -0.689368724822998, 0.05928603559732437, 0.7219805121421814, 0.0, -0.11218871176242828, -0.9673185348510742, 0.22739525139331818, 0.0, 0.7344115972518921, 0.5979668498039246, -0.3210533f, 0.0, 0.5789393186569214, -0.24888497591018677, 0.776457f, 0.0, 0.6988182663917542, 0.3557169735431671, -0.6205791234970093, 0.0, -0.8636845350265503, -0.27487713098526, -0.4224826f, 0.0, -0.4247028f, -0.4640880823135376, 0.7773350477218628, 0.0, 0.5257722735404968, -0.8427017331123352, 0.11583299189805984, 0.0, 0.9343830347061157, 0.31630247831344604, -0.16395439207553864, 0.0, -0.10168363898992538, -0.8057302832603455, -0.5834887623786926, 0.0, -0.6529238820075989, 0.50602126121521, -0.5635892748832703, 0.0, -0.24652861058712006, -0.9668205976486206, -0.06694497168064117, 0.0, -0.9776896834373474, -0.20992505550384521, -0.007368825376033783, 0.0, 0.773689329624176, 0.5734244585037231, 0.2694238f, 0.0, -0.6095088124275208, 0.4995678961277008, 0.6155737042427063, 0.0, 0.5794535279273987, 0.7434546947479248, 0.33392924070358276, 0.0, -0.8226211071014404, 0.08142581582069397, 0.5627293586730957, 0.0, -0.5103854537010193, 0.47036677598953247, 0.719904f, 0.0, -0.5764971971511841, -0.07231656461954117, -0.813892662525177, 0.0, 0.725062906742096, 0.39499714970588684, -0.5641463398933411, 0.0, -0.1525424f, 0.48608407378196716, -0.8604958057403564, 0.0, -0.5550976395606995, -0.4957820773124695, 0.6678823232650757, 0.0, -0.18836143612861633, 0.9145869612693787, 0.35784173011779785, 0.0, 0.7625556588172913, -0.5414408445358276, -0.3540489673614502, 0.0, -0.5870231986045837, -0.3226498067378998, -0.7424963712692261, 0.0, 0.30511242151260376, 0.226254403591156, -0.925048828125, 0.0, 0.6379576325416565, 0.5772424340248108, -0.5097070336341858, 0.0, -0.5966776013374329, 0.14548523724079132, -0.7891830801963806, 0.0, -0.6583305597305298, 0.6555487513542175, -0.36994147300720215, 0.0, 0.7434892654418945, 0.23510846495628357, 0.6260573267936707, 0.0, 0.5562114119529724, 0.8264360427856445, -0.08736328780651093, 0.0, -0.302894f, -0.8251526951789856, 0.47684192657470703, 0.0, 0.11293438076972961, -0.9858884215354919, -0.12357107549905777, 0.0, 0.5937653183937073, -0.5896813869476318, 0.5474656820297241, 0.0, 0.675796389579773, -0.5835758447647095, -0.4502648413181305, 0.0, 0.7242302894592285, -0.11527197808027267, 0.6798550486564636, 0.0, -0.9511914253234863, 0.0753624f, -0.2992580831050873, 0.0, 0.2539471f, -0.18863393366336823, 0.9486454129219055, 0.0, 0.5714336037635803, -0.16794508695602417, -0.8032795786857605, 0.0, -0.06778234988451004, 0.3978269398212433, 0.9149531722068787, 0.0, 0.6074972748756409, 0.73306f, -0.3058922588825226, 0.0, -0.5435478687286377, 0.16758224368095398, 0.8224791288375854, 0.0, -0.5876678228378296, -0.3380044996738434, -0.7351186871528625, 0.0, -0.7967562675476074, 0.04097822681069374, -0.6029098629951477, 0.0, -0.1996350884437561, 0.8706294894218445, 0.449611097574234, 0.0, -0.027876602485775948, -0.9106232523918152, -0.4122962f, 0.0, -0.7797626256942749, -0.625763475894928, 0.01975775510072708, 0.0, -0.5211232900619507, 0.7401644587516785, -0.42495545744895935, 0.0, 0.8575425148010254, 0.4053273f, -0.316750168800354, 0.0, 0.10452233254909515, 0.8390195965766907, -0.5339674353599548, 0.0, 0.3501823f, 0.9242523908615112, -0.15208502113819122, 0.0, 0.1987849920988083, 0.07647613435983658, 0.9770547151565552, 0.0, 0.7845996618270874, 0.6066256761550903, -0.12809641659259796, 0.0, 0.09006737172603607, -0.9750989675521851, -0.20265690982341766, 0.0, -0.8274343609809875, -0.5422995686531067, 0.14582036435604095, 0.0, -0.3485797643661499, -0.4158022701740265, 0.8400003910064697, 0.0, -0.2471779f, -0.730482f, -0.6366310715675354, 0.0, -0.3700155019760132, 0.8577948212623596, 0.3567584455013275, 0.0, 0.5913394689559937, -0.5483119487762451, -0.591330349445343, 0.0, 0.12048735469579697, -0.7626472115516663, -0.6354935169219971, 0.0, 0.616959273815155, 0.03079648f, 0.7863922715187073, 0.0, 0.12581568956375122, -0.664083f, -0.7369967699050903, 0.0, -0.6477565169334412, -0.17401473224163055, -0.7417077422142029, 0.0, 0.6217889189720154, -0.7804430723190308, -0.06547655165195465, 0.0, 0.6589943170547485, -0.6096987724304199, 0.4404473602771759, 0.0, -0.26898375153541565, -0.6732403039932251, -0.6887635588645935, 0.0, -0.3849775195121765, 0.5676542520523071, 0.7277094125747681, 0.0, 0.5754444599151611, 0.8110471367835999, -0.10519634932279587, 0.0, 0.91415935754776, 0.3832947909832001, 0.13190056383609772, 0.0, -0.10792531818151474, 0.924549400806427, 0.3654593527317047, 0.0, 0.3779771029949188, 0.30431488156318665, 0.8743716478347778, 0.0, -0.21428851783275604, -0.8259286284446716, 0.5214617252349854, 0.0, 0.5802544355392456, 0.41480985283851624, -0.7008833885192871, 0.0, -0.19826608896255493, 0.8567161560058594, -0.4761596620082855, 0.0, -0.03381553664803505, 0.3773180842399597, -0.9254661202430725, 0.0, -0.686792254447937, -0.6656597852706909, 0.29191336035728455, 0.0, 0.7731742858886719, -0.28757935762405396, -0.565243f, 0.0, -0.09655942022800446, 0.9193708300590515, -0.3813575f, 0.0, 0.27157023549079895, -0.957791f, -0.09426605701446533, 0.0, 0.24510157108306885, -0.6917998790740967, -0.6792188286781311, 0.0, 0.9777007699012756, -0.17538553476333618, 0.11550365388393402, 0.0, -0.522474f, 0.8521606922149658, 0.029036158695816994, 0.0, -0.7734880447387695, -0.5261292457580566, 0.3534179627895355, 0.0, -0.713449239730835, -0.2695472538471222, 0.6467878222465515, 0.0, 0.16440372169017792, 0.5105845928192139, -0.8439637422561646, 0.0, 0.6494635939598083, 0.05585611239075661, 0.7583383917808533, 0.0, -0.4711971f, 0.5017280578613281, -0.7254256010055542, 0.0, -0.6335764527320862, -0.2381686270236969, -0.7361090779304504, 0.0, -0.9021533131599426, -0.2709478f, -0.33571818470954895, 0.0, -0.3793711f, 0.8722581267356873, 0.3086152f, 0.0, -0.685559868812561, -0.3250143229961395, 0.6514394283294678, 0.0, 0.2900942265987396, -0.7799057960510254, -0.5546100735664368, 0.0, -0.20983193814754486, 0.8503707051277161, 0.48253515362739563, 0.0, -0.45926037430763245, 0.6598504185676575, -0.594707727432251, 0.0, 0.8715945482254028, 0.09616365283727646, -0.48070311546325684, 0.0, -0.6776666045188904, 0.7118504643440247, -0.1844907f, 0.0, 0.704437792301178, 0.3124276101589203, 0.637304f, 0.0, -0.7052319049835205, -0.24010932445526123, -0.6670798063278198, 0.0, 0.08192100375890732, -0.720733642578125, -0.6883545517921448, 0.0, -0.6993681192398071, -0.5875763297080994, -0.4069869f, 0.0, -0.12814544141292572, 0.6419895887374878, 0.755928635597229, 0.0, -0.6337388157844543, -0.6785471439361572, -0.3714146912097931, 0.0, 0.5565052032470703, -0.21688875555992126, -0.8020356893539429, 0.0, -0.579155445098877, 0.7244371771812439, -0.3738579f, 0.0, 0.11757791042327881, -0.7096450924873352, 0.6946792602539062, 0.0, -0.613461971282959, 0.13236311078071594, 0.778552770614624, 0.0, 0.6984635591506958, -0.02980516292154789, -0.7150247097015381, 0.0, 0.8318082690238953, -0.3930172026157379, 0.3919597566127777, 0.0, 0.1469576358795166, 0.055416516959667206, -0.9875892400741577, 0.0, 0.7088685631752014, -0.2690504f, 0.6520101428031921, 0.0, 0.2726053297519684, 0.6736976504325867, -0.6868899464607239, 0.0, -0.6591295599937439, 0.30354586243629456, -0.6880466341972351, 0.0, 0.4815131425857544, -0.752826988697052, 0.4487723112106323, 0.0, 0.943001f, 0.1675647348165512, -0.28752613067626953, 0.0, 0.43480294942855835, 0.7695304751396179, -0.46772778034210205, 0.0, 0.393199622631073, 0.5944736003875732, 0.7014236450195312, 0.0, 0.7254336476325989, -0.6039256453514099, 0.3301814794540405, 0.0, 0.7590235471725464, -0.6506083011627197, 0.024333132430911064, 0.0, -0.855276882648468, -0.3430042862892151, 0.3883935809135437, 0.0, -0.6139746904373169, 0.6981725096702576, 0.36822575330734253, 0.0, -0.7465905547142029, -0.575201f, 0.3342849314212799, 0.0, 0.5730065703392029, 0.8105555176734924, -0.12109167873859406, 0.0, -0.9225877523422241, -0.3475210964679718, -0.16751404106616974, 0.0, -0.7105816602706909, -0.47196921706199646, -0.5218417048454285, 0.0, -0.0856461f, 0.3583001494407654, 0.9296696782112122, 0.0, -0.8279697895050049, -0.2043157f, 0.5222271084785461, 0.0, 0.42794403433799744, 0.278166f, 0.8599346280097961, 0.0, 0.539908f, -0.7857120633125305, -0.3019204f, 0.0, 0.5678403973579407, -0.5495414137840271, -0.6128307580947876, 0.0, -0.9896070957183838, 0.13656391203403473, -0.04503418505191803, 0.0, -0.6154342889785767, -0.644087553024292, 0.4543037414550781, 0.0, 0.1074204370379448, -0.7946340441703796, 0.5975094437599182, 0.0, -0.359545f, -0.888553f, 0.2849578261375427, 0.0, -0.21804052591323853, 0.1529889f, 0.9638738036155701, 0.0, -0.7277432084083557, -0.6164050698280334, -0.30072346329689026, 0.0, 0.7249729037284851, -0.006697194650769234, 0.688744843006134, 0.0, -0.5553659200668335, -0.5336586236953735, 0.6377907991409302, 0.0, 0.5137557983398438, 0.7976208329200745, -0.316f, 0.0, -0.3794024884700775, 0.9245608448982239, -0.035227514803409576, 0.0, 0.8229248523712158, 0.2745365798473358, -0.4974176585674286, 0.0, -0.5404114127159119, 0.6091141700744629, 0.5804613828659058, 0.0, 0.8036581873893738, -0.270302951335907, 0.5301601886749268, 0.0, 0.6044318675994873, 0.6832968592643738, 0.40959432721138, 0.0, 0.06389988958835602, 0.965820848941803, -0.2512108087539673, 0.0, 0.10871133208274841, 0.7402471303939819, -0.6634877920150757, 0.0, -0.713427722454071, -0.6926783919334412, 0.10591284930706024, 0.0, 0.6458897590637207, -0.5724548697471619, -0.5050958395004272, 0.0, -0.655393123626709, 0.7381471395492554, 0.15999561548233032, 0.0, 0.3910961449146271, 0.9188871383666992, -0.05186755955219269, 0.0, -0.4879022538661957, -0.5904377102851868, 0.6429111361503601, 0.0, 0.601479f, 0.7707441449165344, -0.21018201112747192, 0.0, -0.5677173137664795, 0.7511361241340637, 0.3368851840496063, 0.0, 0.7858573794364929, 0.2266746610403061, 0.5753666758537292, 0.0, -0.4520345628261566, -0.6042227149009705, -0.6561857461929321, 0.0, 0.0022721162531524897, 0.4132844f, -0.9105991721153259, 0.0, -0.5815751552581787, -0.5162925720214844, 0.6286591291427612, 0.0, -0.03703704848885536, 0.8273785710334778, 0.5604221224784851, 0.0, -0.511969268321991, 0.7953543663024902, -0.324498f, 0.0, -0.2682417333126068, -0.957229f, -0.10843876004219055, 0.0, -0.23224827647209167, -0.9679130911827087, -0.0959424301981926, 0.0, 0.3554328978061676, -0.8881505727767944, 0.29130062460899353, 0.0, 0.734652042388916, -0.4371373f, 0.5188422799110413, 0.0, 0.998512f, 0.046590112149715424, -0.0283394455909729, 0.0, -0.372768759727478, -0.9082481265068054, 0.19007572531700134, 0.0, 0.917373776435852, -0.3483642041683197, 0.1925298422574997, 0.0, 0.2714911103248596, 0.4147529602050781, -0.8684886693954468, 0.0, 0.5131763219833374, -0.7116334438323975, 0.4798207f, 0.0, -0.8737353682518005, 0.1888699233531952, -0.44823506474494934, 0.0, 0.8460043668746948, -0.3725217878818512, 0.38145f, 0.0, 0.8978727459907532, -0.1780209094285965, -0.40265753865242004, 0.0, 0.21780656278133392, -0.9698323011398315, -0.10947895050048828, 0.0, -0.1518031358718872, -0.7788918018341064, -0.6085091233253479, 0.0, -0.2600385f, -0.4755398f, -0.840382f, 0.0, 0.5723134875297546, -0.7474340796470642, -0.337341845035553, 0.0, -0.7174140810966492, 0.16990171372890472, -0.675611138343811, 0.0, -0.6841807961463928, 0.02145707607269287, -0.728996753692627, 0.0, -0.2007448f, 0.06555605679750443, -0.9774476885795593, 0.0, -0.11488036811351776, -0.8044887185096741, 0.5827524065971375, 0.0, -0.787035f, 0.03447489067912102, 0.6159443259239197, 0.0, -0.2015596479177475, 0.6859872341156006, 0.6991389393806458, 0.0, -0.0858108252286911, -0.1092083603143692, -0.9903080463409424, 0.0, 0.5532693266868591, 0.7325250506401062, -0.3966107666492462, 0.0, -0.1842489391565323, -0.9777374863624573, -0.100407674908638, 0.0, 0.07754737883806229, -0.9111505746841431, 0.4047110378742218, 0.0, 0.13998384773731232, 0.7601631283760071, -0.634473443031311, 0.0, 0.44844192266464233, -0.8452892303466797, 0.29049253463745117, 0.0};
    private DistanceType distanceType;

    public VoronoiGenerator(long seed) {
        this.seed = seed;
        this.distanceType = DistanceType.euclidean;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setOffsetAmount(double offsetAmount) {
        this.offsetAmount = offsetAmount;
    }

    public void setDistanceType(DistanceType distanceType) {
        this.distanceType = distanceType;
    }

    public VoronoiInfo get2(double x, double z) {
        int xr = (int)Math.round(x);
        int zr = (int)Math.round(z);
        double distance0 = 3.4028234663852886E38;
        double distance1 = 3.4028234663852886E38;
        int closestHash = 0;
        double cellularJitter = 0.43701595067977905 * this.offsetAmount;
        int xPrimed = (xr - 1) * 501125321;
        int zPrimedBase = (zr - 1) * 1720413743;
        Vec3 localPos = new Vec3((double)xr, 0.0, (double)zr);
        Vec3 cellPos = new Vec3((double)xr, 0.0, (double)zr);
        for (int xi = xr - 1; xi <= xr + 1; ++xi) {
            int zPrimed = zPrimedBase;
            for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                int hash = VoronoiGenerator.hash((int)this.seed, xPrimed, zPrimed);
                int idx = hash & 0x1FE;
                double vecX = (double)xi - x + RandVecs2D[idx] * cellularJitter;
                double vecZ = (double)zi - z + RandVecs2D[idx | 1] * cellularJitter;
                double newDistance = this.distanceType.getComparisonLength(vecX, 0.0, vecZ);
                distance1 = Math.min(Math.min(distance1, newDistance), distance0);
                if (newDistance < distance0) {
                    distance0 = newDistance;
                    closestHash = hash;
                    localPos = new Vec3(vecX, 0.0, vecZ);
                    cellPos = new Vec3((double)xi + RandVecs2D[idx] * cellularJitter, 0.0, (double)zi + RandVecs2D[idx | 1] * cellularJitter);
                }
                zPrimed += 1720413743;
            }
            xPrimed += 501125321;
        }
        return new VoronoiInfo(this.distanceType.getDistance(distance0), this.distanceType.getDistance(distance1), (double)closestHash * 4.656612873077393E-10, cellPos, localPos);
    }

    public VoronoiInfo get3(double x, double y, double z) {
        int xr = (int)Math.round(x);
        int yr = (int)Math.round(y);
        int zr = (int)Math.round(z);
        double distance0 = 3.4028234663852886E38;
        double distance1 = 3.4028234663852886E38;
        int closestHash = 0;
        double cellularJitter = 0.39614352583885193 * this.offsetAmount;
        int xPrimed = (xr - 1) * 501125321;
        int yPrimedBase = (yr - 1) * 1136930381;
        int zPrimedBase = (zr - 1) * 1720413743;
        Vec3 localPos = new Vec3((double)xr, (double)yr, (double)zr);
        Vec3 cellPos = new Vec3((double)xr, (double)yr, (double)zr);
        for (int xi = xr - 1; xi <= xr + 1; ++xi) {
            int yPrimed = yPrimedBase;
            for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                int zPrimed = zPrimedBase;
                for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                    int hash = VoronoiGenerator.hash((int)this.seed, xPrimed, yPrimed, zPrimed);
                    int idx = hash & 0x3FC;
                    double vecX = (double)xi - x + RandVecs3D[idx] * cellularJitter;
                    double vecY = (double)yi - y + RandVecs3D[idx | 1] * cellularJitter;
                    double vecZ = (double)zi - z + RandVecs3D[idx | 2] * cellularJitter;
                    Vec3 cell = new Vec3((double)xi + RandVecs3D[idx] * cellularJitter, (double)yi + RandVecs3D[idx | 1] * cellularJitter, (double)zi + RandVecs3D[idx | 2] * cellularJitter);
                    double newDistance = this.distanceType.getComparisonLength(vecX, vecY, vecZ);
                    distance1 = Math.min(Math.max(distance1, newDistance), distance0);
                    if (newDistance < distance0) {
                        distance0 = newDistance;
                        closestHash = hash;
                        localPos = new Vec3(vecX, vecY, vecZ);
                        cellPos = cell;
                    }
                    zPrimed += 1720413743;
                }
                yPrimed += 1136930381;
            }
            xPrimed += 501125321;
        }
        return new VoronoiInfo(this.distanceType.getDistance(distance0), this.distanceType.getDistance(distance1), (double)closestHash * 4.656612873077393E-10, cellPos, localPos);
    }

    private static int hash(int seed, int ... primedCoords) {
        int hash = seed;
        for (int primedCoord : primedCoords) {
            hash ^= primedCoord;
        }
        return hash *= 668265261;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DistanceType implements iDistanceType
    {
        euclidean{

            @Override
            public double getComparisonLength(double x, double y, double z) {
                return x * x + y * y + z * z;
            }

            @Override
            public double getDistance(double tempDistance) {
                return Math.sqrt(tempDistance);
            }
        }
        ,
        euclideanSq{

            @Override
            public double getComparisonLength(double x, double y, double z) {
                return x * x + y * y + z * z;
            }

            @Override
            public double getDistance(double tempDistance) {
                return tempDistance;
            }
        }
        ,
        manhattan{

            @Override
            public double getComparisonLength(double x, double y, double z) {
                return Math.abs(x) + Math.abs(y) + Math.abs(z);
            }

            @Override
            public double getDistance(double tempDistance) {
                return tempDistance;
            }
        }
        ,
        hybrid{

            @Override
            public double getComparisonLength(double x, double y, double z) {
                return Math.abs(x) + Math.abs(y) + Math.abs(z) + (x * x + y * y + z * z);
            }

            @Override
            public double getDistance(double tempDistance) {
                return tempDistance * 0.5;
            }
        };

    }

    public record VoronoiInfo(double distance, double distance1, double hash, Vec3 cellPos, Vec3 localPos) {
    }

    public static interface iDistanceType {
        public double getComparisonLength(double var1, double var3, double var5);

        public double getDistance(double var1);
    }
}

