/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public abstract class AbstractCaveGenerationStructure
extends Structure {
    private final ResourceKey<Biome> matchingBiome;

    protected AbstractCaveGenerationStructure(Structure.StructureSettings settings, ResourceKey<Biome> matchingBiome) {
        super(settings);
        this.matchingBiome = matchingBiome;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return this.atYCaveBiomePoint(context, Heightmap.Types.OCEAN_FLOOR_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, context));
    }

    protected Optional<Structure.GenerationStub> atYCaveBiomePoint(Structure.GenerationContext context, Heightmap.Types heightMap, Consumer<StructurePiecesBuilder> builderConsumer) {
        ChunkPos chunkpos = context.f_226628_();
        int i = chunkpos.m_151390_();
        int j = chunkpos.m_151393_();
        int k = this.getGenerateYHeight(context.f_226626_(), i, j);
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, k, j), builderConsumer));
    }

    public void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        int i = context.f_226628_().m_45604_();
        int j = context.f_226628_().m_45605_();
        int k = context.f_226622_().m_6337_();
        BlockPos center = new BlockPos(i, this.getGenerateYHeight(context.f_226626_(), i, j), j);
        int heightRad = this.getHeightRadius(context.f_226626_(), context.f_226622_().m_6337_());
        int widthRad = this.getWidthRadius(context.f_226626_());
        int biomeUp = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.UP, center, heightRad) + this.getYExpand();
        int biomeDown = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.DOWN, center, heightRad) + this.getYExpand();
        BlockPos ground = center.m_6625_(biomeDown - 2);
        int biomeEast = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.EAST, ground, widthRad);
        int biomeWest = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.WEST, ground, widthRad);
        int biomeNorth = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.NORTH, ground, widthRad);
        int biomeSouth = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.SOUTH, ground, widthRad);
        int widthBlocks = (biomeEast + biomeWest + biomeNorth + biomeSouth) / 4;
        int heightBlocks = (biomeUp + biomeDown) / 2;
        int widthChunks = (int)Math.ceil((float)(widthBlocks + 16) / 16.0f / 2.0f) + 2;
        int heightChunks = this.getHeightOverride((int)Math.ceil((float)(heightBlocks + 16) / 16.0f / 2.0f));
        int minYChunks = (int)Math.ceil((float)context.f_226622_().m_142062_() / 16.0f);
        int maxYChunks = (int)Math.ceil(20.0);
        for (int chunkX = -widthChunks; chunkX <= widthChunks; ++chunkX) {
            for (int chunkZ = -widthChunks; chunkZ <= widthChunks; ++chunkZ) {
                for (int chunkY = Math.max(-heightChunks, minYChunks); chunkY <= Math.min(heightChunks, maxYChunks); ++chunkY) {
                    StructurePiece piece = this.createPiece(center.m_121955_((Vec3i)new BlockPos(chunkX * 16, chunkY * 16, chunkZ * 16)), center, heightBlocks, widthBlocks, context.f_226624_());
                    builder.m_142679_(piece);
                }
            }
        }
    }

    protected int getHeightOverride(int heightIn) {
        return heightIn;
    }

    protected int getYExpand() {
        return -5;
    }

    protected abstract StructurePiece createPiece(BlockPos var1, BlockPos var2, int var3, int var4, RandomState var5);

    private static Holder<Biome> getBiomeHolder(BiomeSource biomeSource, RandomState randomState, BlockPos pos) {
        return biomeSource.m_203407_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_()), randomState.m_224579_());
    }

    protected int biomeContinuesInDirectionFor(BiomeSource biomeSource, RandomState randomState, Direction direction, BlockPos start, int cutoff) {
        BlockPos check;
        Holder<Biome> biomeHolder;
        int i;
        for (i = 0; i < cutoff && (biomeHolder = AbstractCaveGenerationStructure.getBiomeHolder(biomeSource, randomState, check = start.m_5484_(direction, i))).m_203565_(this.matchingBiome); i += 16) {
        }
        return Math.min(i, cutoff);
    }

    public abstract int getGenerateYHeight(WorldgenRandom var1, int var2, int var3);

    public abstract int getWidthRadius(WorldgenRandom var1);

    public abstract int getHeightRadius(WorldgenRandom var1, int var2);

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.RAW_GENERATION;
    }
}

