/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.map;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.item.CaveMapItem;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.message.UpdateCaveBiomeMapTagMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public class FilloutCaveBiomeMap
implements Runnable {
    private ItemStack map;
    private BlockPos center;
    private Player player;
    private ServerLevel serverLevel;
    private ResourceKey<Biome> biomeResourceKey;
    private UUID taskUUID;
    private int legIndex;
    private int leg;
    private int legX;
    private int legZ;

    public FilloutCaveBiomeMap(ItemStack map, ServerLevel serverLevel, BlockPos center, Player player, UUID taskUUID) {
        this.map = map;
        this.serverLevel = serverLevel;
        this.center = center;
        ResourceKey<Biome> from = CaveMapItem.getBiomeTarget(map);
        this.biomeResourceKey = from == null ? ACBiomeRegistry.MAGNETIC_CAVES : from;
        this.player = player;
        this.taskUUID = taskUUID;
    }

    @Override
    public void run() {
        BlockPos biomeCorner = this.findBiome();
        CompoundTag tag = this.map.m_41784_();
        if (biomeCorner != null) {
            BlockPos centered = this.getCenterOfBiome(biomeCorner);
            this.fillOutMapColors(centered, tag);
            tag.m_128405_("BiomeX", centered.m_123341_());
            tag.m_128405_("BiomeY", centered.m_123342_());
            tag.m_128405_("BiomeZ", centered.m_123343_());
            tag.m_128356_("RandomSeed", this.serverLevel.m_213780_().m_188505_());
            tag.m_128379_("Filled", true);
            AlexsCaves.LOGGER.info("Found {} at {} {} {}", new Object[]{this.biomeResourceKey.m_135782_(), centered.m_123341_(), centered.m_123342_(), centered.m_123343_()});
        } else {
            this.player.m_213846_((Component)Component.m_237115_((String)"item.alexscaves.cave_map.error").m_130940_(ChatFormatting.RED));
        }
        tag.m_128379_("Loading", false);
        tag.m_128473_("MapUUID");
        this.map.m_41751_(tag);
        AlexsCaves.sendMSGToAll(new UpdateCaveBiomeMapTagMessage(this.player.m_19879_(), this.getTaskUUID(), tag));
    }

    private BlockPos findBiome() {
        int y = this.player.m_146904_();
        ServerChunkCache cache = this.serverLevel.m_7726_();
        BiomeSource source = cache.m_8481_().m_62218_();
        Climate.Sampler sampler = cache.m_214994_().m_224579_();
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            int height = 64;
            BlockPos nextPos = this.calculateNextSpiralPos();
            if (nextPos == null) {
                return null;
            }
            int[] searchedHeights = Mth.m_216250_((int)y, (int)(this.serverLevel.m_141937_() + 1), (int)this.serverLevel.m_151558_(), (int)64).toArray();
            int nextBlockX = nextPos.m_123341_();
            int nextBlockZ = nextPos.m_123343_();
            int quartX = QuartPos.m_175400_((int)nextBlockX);
            int quartZ = QuartPos.m_175400_((int)nextBlockZ);
            for (int blockY : searchedHeights) {
                int quartY = QuartPos.m_175400_((int)blockY);
                Holder holder = source.m_203407_(quartX, quartY, quartZ, sampler);
                if (!holder.m_203565_(this.biomeResourceKey)) continue;
                return new BlockPos(nextBlockX, blockY, nextBlockZ);
            }
        }
        return null;
    }

    private BlockPos calculateNextSpiralPos() {
        int step = 32;
        BlockPos current = new BlockPos(this.legX, 0, this.legZ).m_121945_(ACMath.HORIZONTAL_DIRECTIONS[(this.leg + 4) % 4]);
        int newX = current.m_123341_();
        int newZ = current.m_123343_();
        int legSize = this.leg / 2 + 1;
        int maxLegs = 4 * Math.floorDiv((Integer)AlexsCaves.COMMON_CONFIG.caveMapSearchDistance.get(), 32);
        if (this.legIndex >= legSize) {
            if (this.leg > maxLegs) {
                return null;
            }
            ++this.leg;
            this.legIndex = 0;
        }
        ++this.legIndex;
        this.legX = newX;
        this.legZ = newZ;
        return new BlockPos(this.center.m_123341_() + newX * 32, 0, this.center.m_123343_() + newZ * 32);
    }

    private BlockPos getCenterOfBiome(BlockPos biomeCorner) {
        BlockPos yCentered;
        int biomeNorth = 0;
        int biomeSouth = 0;
        int biomeEast = 0;
        int biomeWest = 0;
        if (this.mapBiomeBeneathSurfaceOnly()) {
            int iterations = 0;
            yCentered = biomeCorner;
            while (iterations < 256 && this.serverLevel.m_204166_(yCentered).m_203565_(this.biomeResourceKey)) {
                ++iterations;
                yCentered = yCentered.m_7494_();
            }
            yCentered = yCentered.m_6625_(10);
        } else {
            int biomeUp;
            int biomeDown = 0;
            for (biomeUp = 0; biomeUp < 32 && this.serverLevel.m_204166_(biomeCorner.m_6630_(biomeUp)).m_203565_(this.biomeResourceKey); biomeUp += 8) {
            }
            while (biomeDown < 64 && this.serverLevel.m_204166_(biomeCorner.m_6625_(biomeDown)).m_203565_(this.biomeResourceKey)) {
                biomeDown += 8;
            }
            yCentered = biomeCorner.m_175288_((int)Math.floor((float)biomeUp * 0.25f) - biomeDown);
        }
        while (biomeNorth < 800 && this.serverLevel.m_204166_(yCentered.m_122013_(biomeNorth)).m_203565_(this.biomeResourceKey)) {
            biomeNorth += 8;
        }
        while (biomeSouth < 800 && this.serverLevel.m_204166_(yCentered.m_122020_(biomeSouth)).m_203565_(this.biomeResourceKey)) {
            biomeSouth += 8;
        }
        while (biomeEast < 800 && this.serverLevel.m_204166_(yCentered.m_122030_(biomeEast)).m_203565_(this.biomeResourceKey)) {
            biomeEast += 8;
        }
        while (biomeWest < 800 && this.serverLevel.m_204166_(yCentered.m_122025_(biomeWest)).m_203565_(this.biomeResourceKey)) {
            biomeWest += 8;
        }
        return yCentered.m_7918_(biomeEast - biomeWest, 0, biomeSouth - biomeNorth);
    }

    private void fillOutMapColors(BlockPos first, CompoundTag tag) {
        Registry registry = this.serverLevel.m_9598_().m_6632_(Registries.f_256952_).orElse(null);
        byte[] arr = new byte[16384];
        HashMap<Integer, Byte> biomeMap = new HashMap<Integer, Byte>();
        if (registry != null) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int scale = CaveMapItem.MAP_SCALE;
            int j = first.m_123341_();
            int k = first.m_123343_();
            int l = j / scale - 64;
            int i1 = k / scale - 64;
            for (int j1 = 0; j1 < 128; ++j1) {
                for (int k1 = 0; k1 < 128; ++k1) {
                    byte biomeHash;
                    Holder holder1 = this.serverLevel.m_204166_((BlockPos)mutableBlockPos.m_122178_((l + k1) * scale, first.m_123342_(), (i1 + j1) * scale));
                    if (this.mapBiomeBeneathSurfaceOnly()) {
                        holder1 = this.serverLevel.m_204166_((BlockPos)mutableBlockPos.m_142448_(first.m_123342_() - 5));
                    } else {
                        for (int yUpFromBottom = this.serverLevel.m_141937_() + 1; yUpFromBottom < this.serverLevel.m_151558_() && !(holder1 = this.serverLevel.m_204166_((BlockPos)mutableBlockPos.m_142448_(yUpFromBottom))).m_203565_(this.biomeResourceKey); yUpFromBottom += 32) {
                        }
                    }
                    int id = registry.m_7447_((Object)((Biome)holder1.m_203334_()));
                    if (biomeMap.containsKey(id)) {
                        biomeHash = (Byte)biomeMap.get(id);
                    } else {
                        biomeHash = (byte)biomeMap.size();
                        biomeMap.put(id, biomeHash);
                    }
                    arr[j1 * 128 + k1] = biomeHash;
                }
            }
        }
        ListTag listTag = new ListTag();
        for (Map.Entry entry : biomeMap.entrySet()) {
            CompoundTag biomeEntryTag = new CompoundTag();
            biomeEntryTag.m_128405_("BiomeID", ((Integer)entry.getKey()).intValue());
            biomeEntryTag.m_128405_("BiomeHash", (int)((Byte)entry.getValue()).byteValue());
            listTag.add((Object)biomeEntryTag);
        }
        tag.m_128365_("MapBiomeList", (Tag)listTag);
        tag.m_128382_("MapBiomes", arr);
    }

    private boolean mapBiomeBeneathSurfaceOnly() {
        return this.biomeResourceKey.equals(ACBiomeRegistry.ABYSSAL_CHASM);
    }

    public UUID getTaskUUID() {
        return this.taskUUID;
    }
}

