/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.MultipleDinosaurEggsBlock;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalBreedEggsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalFollowOwnerGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalJoinPackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalLayEggGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalLootChestsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalPackTargetGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GroundPathNavigatorNoSpin;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTargetClosePlayers;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTargetItemGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTargetUntamedGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.VallumraptorMeleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.VallumraptorOpenDoorGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.VallumraptorWanderGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GrottoceratopsEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.ChestThief;
import com.github.alexmodguy.alexscaves.server.entity.util.PackAnimal;
import com.github.alexmodguy.alexscaves.server.entity.util.TargetsDroppedItems;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.collision.ICustomCollisions;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VallumraptorEntity
extends DinosaurEntity
implements IAnimatedEntity,
ICustomCollisions,
PackAnimal,
ChestThief,
TargetsDroppedItems {
    public static final Animation ANIMATION_CALL_1 = Animation.create((int)15);
    public static final Animation ANIMATION_CALL_2 = Animation.create((int)25);
    public static final Animation ANIMATION_SCRATCH_1 = Animation.create((int)20);
    public static final Animation ANIMATION_SCRATCH_2 = Animation.create((int)20);
    public static final Animation ANIMATION_SHAKE = Animation.create((int)40);
    public static final Animation ANIMATION_STARTLEAP = Animation.create((int)20);
    public static final Animation ANIMATION_MELEE_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_MELEE_SLASH_1 = Animation.create((int)15);
    public static final Animation ANIMATION_MELEE_SLASH_2 = Animation.create((int)15);
    public static final Animation ANIMATION_GRAB = Animation.create((int)40);
    private static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.m_135353_(VallumraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEAPING = SynchedEntityData.m_135353_(VallumraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ELDER = SynchedEntityData.m_135353_(VallumraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> PUZZLED_HEAD_ROT = SynchedEntityData.m_135353_(VallumraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> RELAXED_FOR = SynchedEntityData.m_135353_(VallumraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HIDING_FOR = SynchedEntityData.m_135353_(VallumraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Animation currentAnimation;
    private int animationTick;
    private float leapProgress;
    private float prevLeapProgress;
    private float runProgress;
    private float prevRunProgress;
    private float prevPuzzleHeadRot;
    public float prevRelaxedProgress;
    public float relaxedProgress;
    private float hideProgress;
    private float prevHideProgress;
    private boolean hasRunningAttributes = false;
    private boolean hasElderAttributes = false;
    private float targetPuzzleRot;
    private VallumraptorEntity priorPackMember;
    private VallumraptorEntity afterPackMember;
    private int fleeTicks = 0;
    private Vec3 fleeFromPosition;
    private float tailYaw = this.m_146908_();
    private float prevTailYaw = this.m_146908_();
    private int eatHeldItemIn;

    public VallumraptorEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigatorNoSpin navigation = new GroundPathNavigatorNoSpin((Mob)this, level);
        navigation.m_26477_(true);
        navigation.m_148214_(true);
        return navigation;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new AnimalFollowOwnerGoal(this, 1.0, 5.0f, 2.0f, false){

            @Override
            public boolean shouldFollow() {
                return VallumraptorEntity.this.getCommand() == 2;
            }

            @Override
            public void tickDistance(float distanceTo) {
                VallumraptorEntity.this.setRunning(distanceTo > 5.0f);
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new AnimalBreedEggsGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new AnimalLayEggGoal((Animal)this, 100, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new AnimalJoinPackGoal((LivingEntity)this, 60, 8));
        this.f_21345_.m_25352_(6, (Goal)new FleeGoal());
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACItemRegistry.DINOSAUR_NUGGET.get()}), false));
        this.f_21345_.m_25352_(8, (Goal)new VallumraptorMeleeGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new VallumraptorWanderGoal(this, 1.0, 25));
        this.f_21345_.m_25352_(10, (Goal)new VallumraptorOpenDoorGoal(this));
        this.f_21345_.m_25352_(11, (Goal)new AnimalLootChestsGoal((Animal)this, 20));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(13, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new MobTargetItemGoal((PathfinderMob)this, true){

            @Override
            public void m_8056_() {
                super.m_8056_();
                VallumraptorEntity.this.setRunning(true);
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                VallumraptorEntity.this.setRunning(false);
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{VallumraptorEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new AnimalPackTargetGoal(this, GrottoceratopsEntity.class, 30, false, 5));
        this.f_21346_.m_25352_(6, new MobTargetUntamedGoal<Frog>(this, Frog.class, 100, true, false, null));
        this.f_21346_.m_25352_(7, new MobTargetUntamedGoal<Pig>(this, Pig.class, 50, true, false, null));
        this.f_21346_.m_25352_(8, (Goal)new MobTargetClosePlayers((Mob)this, 12.0f));
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)ACEntityRegistry.VALLUMRAPTOR.get()).m_20615_((Level)level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PUZZLED_HEAD_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LEAPING, (Object)false);
        this.f_19804_.m_135372_(ELDER, (Object)false);
        this.f_19804_.m_135372_(RUNNING, (Object)false);
        this.f_19804_.m_135372_(RELAXED_FOR, (Object)0);
        this.f_19804_.m_135372_(HIDING_FOR, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 28.0);
    }

    @Override
    public void m_8119_() {
        Player player;
        LivingEntity target;
        super.m_8119_();
        this.prevRunProgress = this.runProgress;
        this.prevLeapProgress = this.leapProgress;
        this.prevRelaxedProgress = this.relaxedProgress;
        this.prevHideProgress = this.hideProgress;
        this.prevTailYaw = this.tailYaw;
        float headPuzzleRot = this.getPuzzledHeadRot();
        if (this.isRunning() && this.runProgress < 5.0f) {
            this.runProgress += 1.0f;
        }
        if (!this.isRunning() && this.runProgress > 0.0f) {
            this.runProgress -= 1.0f;
        }
        if (this.isLeaping() && this.leapProgress < 5.0f) {
            this.leapProgress += 1.0f;
        }
        if (!this.isLeaping() && this.leapProgress > 0.0f) {
            this.leapProgress -= 1.0f;
        }
        if (this.getRelaxedFor() > 0 && this.relaxedProgress < 20.0f) {
            this.relaxedProgress += 1.0f;
        }
        if (this.getRelaxedFor() <= 0 && this.relaxedProgress > 0.0f) {
            this.relaxedProgress -= 1.0f;
        }
        if (this.getHideFor() > 0 && this.hideProgress < 20.0f) {
            this.hideProgress += 1.0f;
        }
        if (this.getHideFor() <= 0 && this.hideProgress > 0.0f) {
            this.hideProgress -= 1.0f;
        }
        if (this.isRunning() && !this.hasRunningAttributes) {
            this.hasRunningAttributes = true;
            this.m_21051_(Attributes.f_22279_).m_22100_(0.35);
        }
        if (!this.isRunning() && this.hasRunningAttributes) {
            this.hasRunningAttributes = false;
            this.m_21051_(Attributes.f_22279_).m_22100_(0.2);
        }
        if (this.isElder() && !this.hasElderAttributes) {
            this.hasElderAttributes = true;
            this.m_21051_(Attributes.f_22276_).m_22100_(32.0);
            this.m_21051_(Attributes.f_22284_).m_22100_(5.0);
            this.m_5634_(36.0f);
        }
        if (!this.isElder() && this.hasElderAttributes) {
            this.hasElderAttributes = false;
            this.m_21051_(Attributes.f_22276_).m_22100_(24.0);
            this.m_21051_(Attributes.f_22284_).m_22100_(0.0);
            this.m_5634_(28.0f);
        }
        if (this.f_19797_ % (this.getHideFor() > 0 ? 15 : 100) == 0 && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(2.0f);
        }
        if (!this.m_9236_().f_46443_) {
            this.puzzledTick(headPuzzleRot);
            if (this.isStillEnough() && this.f_19796_.m_188503_(100) == 0 && this.getAnimation() == NO_ANIMATION && this.getRelaxedFor() <= 0 && !this.isDancing()) {
                float rand = this.f_19796_.m_188501_();
                Animation idle = rand < 0.45f ? ANIMATION_SCRATCH_1 : (rand < 0.9f ? ANIMATION_SCRATCH_2 : ANIMATION_SHAKE);
                this.setAnimation(idle);
            }
            if (this.fleeTicks > 0) {
                --this.fleeTicks;
            }
            if (this.isLeaping()) {
                this.m_20256_(this.m_20184_().m_82542_((double)1.1f, 1.0, (double)1.1f));
            }
        }
        if (this.getAnimation() == ANIMATION_CALL_1 && this.getAnimationTick() == 5 || this.getAnimation() == ANIMATION_CALL_2 && this.getAnimationTick() == 4) {
            this.actuallyPlayAmbientSound();
        }
        if (!this.m_9236_().f_46443_) {
            if (this.eatHeldItemIn > 0) {
                --this.eatHeldItemIn;
            } else if (this.canTargetItem(this.m_21205_())) {
                ItemStack stack = this.m_21205_();
                this.m_9236_().m_7605_((Entity)this, (byte)45);
                this.m_5634_(5.0f);
                if (stack.m_150930_((Item)ACItemRegistry.DINOSAUR_NUGGET.get())) {
                    this.setRelaxedForTime(200 + this.f_19796_.m_188503_(200));
                }
                if (!this.m_9236_().f_46443_) {
                    stack.m_41774_(1);
                }
            }
            if (this.getRelaxedFor() > 0) {
                this.setRelaxedForTime(this.getRelaxedFor() - 1);
            }
            if (this.getHideFor() > 0) {
                this.setHideFor(this.getHideFor() - 1);
            }
        }
        if (!((target = this.m_5448_()) == null || !target.m_6084_() || target instanceof Player && (player = (Player)target).m_7500_())) {
            if (this.isElder()) {
                PackAnimal leader = this;
                while (leader.getAfterPackMember() != null) {
                    if (((DinosaurEntity)((Object)(leader = leader.getAfterPackMember()))).m_7307_((Entity)target)) continue;
                    ((VallumraptorEntity)leader).m_6710_(target);
                }
            }
            if (this.m_21223_() < this.m_21233_() * 0.45f && this.m_21824_() && this.getHideFor() <= 0) {
                int i = 80 + this.f_19796_.m_188503_(40);
                this.setHideFor(i);
                this.fleeFromPosition = target.m_20182_();
                this.fleeTicks = i;
                if (target instanceof Mob) {
                    Mob mob = (Mob)target;
                    mob.m_6710_(null);
                    mob.m_6703_(null);
                    mob.m_21335_(null);
                }
            }
            if (target instanceof GrottoceratopsEntity && (this.f_19797_ + this.m_19879_()) % 20 == 0 && this.getPackSize() < 4 && !this.m_21824_()) {
                this.fleeFromPosition = target.m_20182_();
                this.fleeTicks = 100 + this.f_19796_.m_188503_(100);
                this.m_6710_(null);
                this.m_6703_(null);
            }
        }
        this.tailYaw = Mth.m_14148_((float)this.tailYaw, (float)this.f_20883_, (float)8.0f);
        this.prevPuzzleHeadRot = headPuzzleRot;
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    @Override
    public void m_7822_(byte b) {
        if (b == 45) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemstack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 headPos = new Vec3(0.0, 0.1, 0.7).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), this.m_20185_() + headPos.f_82479_, this.m_20227_(0.5) + headPos.f_82480_, this.m_20189_() + headPos.f_82481_, (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.15f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f));
                }
            }
        } else {
            super.m_7822_(b);
        }
    }

    @Override
    public float maxSitTicks() {
        return 5.0f;
    }

    private void puzzledTick(float current) {
        float dist = Math.abs(this.targetPuzzleRot - current);
        LivingEntity target = this.m_5448_();
        if (target != null && target.m_6084_() || this.getAnimation() != NO_ANIMATION || this.getRelaxedFor() > 0) {
            this.targetPuzzleRot = 0.0f;
        } else if (this.f_19796_.m_188503_(10) == 0 && dist <= 0.1f) {
            if (this.f_19796_.m_188501_() < 0.25f) {
                this.targetPuzzleRot = 0.0f;
            } else {
                float invSignum = this.f_19796_.m_188501_() < 0.1f ? Math.signum(this.f_19796_.m_188501_() - 0.5f) : -Math.signum(this.targetPuzzleRot);
                this.targetPuzzleRot = this.f_19796_.m_188501_() * 50.0f * invSignum;
            }
        }
        if (current < this.targetPuzzleRot && dist > 0.1f) {
            this.setPuzzledHeadRot(current + Math.min(dist, 6.0f));
        }
        if (current > this.targetPuzzleRot && dist > 0.1f) {
            this.setPuzzledHeadRot(current - Math.min(dist, 6.0f));
        }
    }

    public float getTailYaw(float partialTick) {
        return this.prevTailYaw + (this.tailYaw - this.prevTailYaw) * partialTick;
    }

    private boolean isStillEnough() {
        return this.m_20184_().m_165924_() < 0.05;
    }

    private float getPuzzledHeadRot() {
        return ((Float)this.f_19804_.m_135370_(PUZZLED_HEAD_ROT)).floatValue();
    }

    public float getPuzzledHeadRot(float f) {
        return this.prevPuzzleHeadRot + (this.getPuzzledHeadRot() - this.prevPuzzleHeadRot) * f;
    }

    public void setPuzzledHeadRot(float rot) {
        this.f_19804_.m_135381_(PUZZLED_HEAD_ROT, (Object)Float.valueOf(rot));
    }

    public float getLeapProgress(float partialTick) {
        return (this.prevLeapProgress + (this.leapProgress - this.prevLeapProgress) * partialTick) * 0.2f;
    }

    public float getRunProgress(float partialTick) {
        return (this.prevRunProgress + (this.runProgress - this.prevRunProgress) * partialTick) * 0.2f;
    }

    public float getRelaxedProgress(float partialTick) {
        return (this.prevRelaxedProgress + (this.relaxedProgress - this.prevRelaxedProgress) * partialTick) * 0.05f;
    }

    public float getHideProgress(float partialTick) {
        return (this.prevHideProgress + (this.hideProgress - this.prevHideProgress) * partialTick) * 0.05f;
    }

    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(RUNNING);
    }

    public void setRunning(boolean bool) {
        this.f_19804_.m_135381_(RUNNING, (Object)bool);
    }

    public boolean isLeaping() {
        return (Boolean)this.f_19804_.m_135370_(LEAPING);
    }

    public void setLeaping(boolean bool) {
        this.f_19804_.m_135381_(LEAPING, (Object)bool);
    }

    public boolean isElder() {
        return (Boolean)this.f_19804_.m_135370_(ELDER);
    }

    public void setElder(boolean bool) {
        this.f_19804_.m_135381_(ELDER, (Object)bool);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_CALL_1, ANIMATION_CALL_2, ANIMATION_SCRATCH_1, ANIMATION_SCRATCH_2, ANIMATION_SHAKE, ANIMATION_STARTLEAP, ANIMATION_MELEE_BITE, ANIMATION_MELEE_SLASH_1, ANIMATION_MELEE_SLASH_2, ANIMATION_GRAB};
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setElder(compound.m_128471_("Elder"));
        this.setRelaxedForTime(compound.m_128451_("RelaxedTime"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Elder", this.isElder());
        compound.m_128405_("RelaxedTime", this.getRelaxedFor());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (spawnDataIn instanceof AgeableMob.AgeableMobGroupData) {
            AgeableMob.AgeableMobGroupData data = (AgeableMob.AgeableMobGroupData)spawnDataIn;
            if (data.m_146777_() == 0) {
                this.setElder(true);
            }
        } else {
            this.setElder(this.m_217043_().m_188503_(2) == 0);
        }
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 6.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public void m_8032_() {
        if (this.getRelaxedFor() > 0) {
            super.m_8032_();
        } else if (this.getAnimation() == NO_ANIMATION && !this.m_9236_().f_46443_) {
            this.setAnimation(this.f_19796_.m_188499_() && !this.m_21825_() ? ANIMATION_CALL_2 : ANIMATION_CALL_1);
        }
    }

    public void actuallyPlayAmbientSound() {
        float volume = this.m_6121_();
        SoundEvent soundevent = this.m_7515_();
        if (this.getAnimation() == ANIMATION_CALL_2) {
            soundevent = (SoundEvent)ACSoundRegistry.VALLUMRAPTOR_CALL.get();
            volume += 1.0f;
        }
        if (soundevent != null) {
            this.m_5496_(soundevent, volume, this.m_6100_());
        }
    }

    @Override
    public void m_7023_(Vec3 vec3d) {
        if (this.getAnimation() == ANIMATION_GRAB || this.getRelaxedFor() > 0) {
            vec3d = Vec3.f_82478_;
        }
        super.m_7023_(vec3d);
    }

    @Override
    public PackAnimal getPriorPackMember() {
        return this.priorPackMember;
    }

    @Override
    public PackAnimal getAfterPackMember() {
        return this.afterPackMember;
    }

    @Override
    public void setPriorPackMember(PackAnimal animal) {
        this.priorPackMember = (VallumraptorEntity)animal;
    }

    @Override
    public void setAfterPackMember(PackAnimal animal) {
        this.afterPackMember = (VallumraptorEntity)animal;
    }

    @Override
    public void afterSteal(BlockPos stealPos) {
        this.fleeFromPosition = Vec3.m_82512_((Vec3i)stealPos);
        this.fleeTicks = 300 + this.f_19796_.m_188503_(80);
        this.eatHeldItemIn = this.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ACItemRegistry.DINOSAUR_NUGGET.get()) ? 40 + this.f_19796_.m_188503_(20) : 100 + this.f_19796_.m_188503_(80);
    }

    @Override
    public boolean isValidLeader(PackAnimal packLeader) {
        return packLeader instanceof VallumraptorEntity && ((VallumraptorEntity)packLeader).m_6084_() && ((VallumraptorEntity)packLeader).isElder();
    }

    @Override
    public boolean shouldLootItem(ItemStack stack) {
        return this.canTargetItem(stack);
    }

    @Override
    public void startOpeningChest() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_GRAB);
        }
    }

    @Override
    public boolean didOpeningChest() {
        return this.getAnimation() == ANIMATION_GRAB && this.getAnimationTick() > 15;
    }

    public boolean canPassThrough(BlockPos blockPos, BlockState blockState, VoxelShape voxelShape) {
        return blockState.m_60734_() instanceof DoorBlock && (Boolean)blockState.m_61143_((Property)DoorBlock.f_52727_) != false;
    }

    public boolean m_20039_(BlockPos pos, BlockState blockState) {
        return (!(blockState.m_60734_() instanceof DoorBlock) || (Boolean)blockState.m_61143_((Property)DoorBlock.f_52727_) == false) && super.m_20039_(pos, blockState);
    }

    public Vec3 m_20272_(Vec3 vec3) {
        return ICustomCollisions.getAllowedMovementForEntity((Entity)this, (Vec3)vec3);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.m_204117_(ACTagRegistry.VALLUMRAPTOR_STEALS) || stack.m_41720_().m_41472_() && stack.m_41720_().getFoodProperties(stack, (LivingEntity)this).m_38746_();
    }

    @Override
    public double getMaxDistToItem() {
        return 2.0;
    }

    @Override
    public void onGetItem(ItemEntity e) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_GRAB);
        }
        if (this.getAnimation() == ANIMATION_GRAB && this.getAnimationTick() > 15) {
            if (!this.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && !this.m_9236_().f_46443_) {
                this.m_5552_(this.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
            }
            this.m_7938_((Entity)e, 1);
            ItemStack duplicate = e.m_32055_().m_41777_();
            duplicate.m_41764_(1);
            this.m_21008_(InteractionHand.MAIN_HAND, duplicate);
            e.m_32055_().m_41774_(1);
            this.eatHeldItemIn = this.m_21824_() ? 50 : 200;
        }
    }

    @Override
    public BlockState createEggBlockState() {
        return (BlockState)((Block)ACBlockRegistry.VALLUMRAPTOR_EGG.get()).m_49966_().m_61124_((Property)MultipleDinosaurEggsBlock.EGGS, (Comparable)Integer.valueOf(1 + this.f_19796_.m_188503_(3)));
    }

    public float getStepHeight() {
        return this.hasRunningAttributes ? 1.1f : 0.6f;
    }

    @Override
    public boolean tamesFromHatching() {
        return true;
    }

    public boolean m_6898_(ItemStack stack) {
        return this.m_21824_() && stack.m_150930_((Item)ACItemRegistry.DINOSAUR_NUGGET.get());
    }

    public int getRelaxedFor() {
        return (Integer)this.f_19804_.m_135370_(RELAXED_FOR);
    }

    public void setRelaxedForTime(int ticks) {
        this.f_19804_.m_135381_(RELAXED_FOR, (Object)ticks);
    }

    public int getHideFor() {
        return (Integer)this.f_19804_.m_135370_(HIDING_FOR);
    }

    public void setHideFor(int ticks) {
        this.f_19804_.m_135381_(HIDING_FOR, (Object)ticks);
    }

    protected SoundEvent m_7515_() {
        return this.getRelaxedFor() > 0 ? (SoundEvent)ACSoundRegistry.VALLUMRAPTOR_SLEEP.get() : (SoundEvent)ACSoundRegistry.VALLUMRAPTOR_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.VALLUMRAPTOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.VALLUMRAPTOR_DEATH.get();
    }

    @Override
    public boolean onFeedMixture(ItemStack itemStack, Player player) {
        if (itemStack.m_150930_((Item)ACItemRegistry.SERENE_SALAD.get()) && this.getRelaxedFor() > 0 && !this.m_21824_()) {
            this.m_5634_(5.0f);
            this.setRelaxedForTime(0);
            this.m_21828_(player);
            this.setCommand(1);
            this.m_21839_(true);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            return true;
        }
        return false;
    }

    @Override
    public boolean canOwnerCommand(Player ownerPlayer) {
        return true;
    }

    private class FleeGoal
    extends Goal {
        public FleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return VallumraptorEntity.this.fleeTicks > 0 && VallumraptorEntity.this.fleeFromPosition != null;
        }

        public void m_8041_() {
            VallumraptorEntity.this.fleeFromPosition = null;
            VallumraptorEntity.this.setRunning(false);
        }

        public void m_8037_() {
            int dist;
            Vec3 vec3;
            VallumraptorEntity.this.setRunning(true);
            if (VallumraptorEntity.this.m_21573_().m_26571_() && (vec3 = LandRandomPos.m_148521_((PathfinderMob)VallumraptorEntity.this, (int)(dist = VallumraptorEntity.this.getHideFor() > 0 ? 4 : 8), (int)dist, (Vec3)VallumraptorEntity.this.fleeFromPosition)) != null) {
                VallumraptorEntity.this.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
            }
        }
    }
}

