/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalJoinPackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GroundPathNavigatorNoSpin;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTargetClosePlayers;
import com.github.alexmodguy.alexscaves.server.entity.ai.UnderzealotBreakLightGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.UnderzealotCaptureSacrificeGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.UnderzealotMeleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.UnderzealotOpenDoorGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.UnderzealotProcessionGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.UnderzealotSacrificeGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.ForsakenEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.WatcherEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.PackAnimal;
import com.github.alexmodguy.alexscaves.server.entity.util.UnderzealotSacrifice;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class UnderzealotEntity
extends Monster
implements PackAnimal,
IAnimatedEntity {
    private static final EntityDataAccessor<Boolean> BURIED = SynchedEntityData.m_135353_(UnderzealotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CARRYING = SynchedEntityData.m_135353_(UnderzealotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PRAYING = SynchedEntityData.m_135353_(UnderzealotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> SACRIFICE_POS = SynchedEntityData.m_135353_(UnderzealotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<BlockPos>> PARTICLE_POS = SynchedEntityData.m_135353_(UnderzealotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> WORSHIP_TIME = SynchedEntityData.m_135353_(UnderzealotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Animation ANIMATION_ATTACK_0 = Animation.create((int)15);
    public static final Animation ANIMATION_ATTACK_1 = Animation.create((int)15);
    public static final Animation ANIMATION_BREAKTORCH = Animation.create((int)15);
    public static final int MAX_WORSHIP_TIME = 500;
    public int sacrificeCooldown;
    public int cloudCooldown;
    private Animation currentAnimation;
    private int animationTick;
    private float buriedProgress;
    private float prevBuriedProgress;
    private float carryingProgress;
    private float prevCarryingProgress;
    private float prayingProgress;
    private float prevPrayingProgress;
    private UnderzealotEntity priorPackMember;
    private UnderzealotEntity afterPackMember;
    private int idleBuryIn;
    private int reemergeTime;
    private BlockPos remergePos;

    public UnderzealotEntity(EntityType type, Level level) {
        super(type, level);
        this.idleBuryIn = 400 + this.f_19796_.m_188503_(800);
        this.reemergeTime = 0;
        this.remergePos = null;
        this.buriedProgress = 20.0f;
        this.prevBuriedProgress = 20.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AnimalJoinPackGoal((LivingEntity)this, 60, 11));
        this.f_21345_.m_25352_(2, (Goal)new UnderzealotOpenDoorGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new UnderzealotSacrificeGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new UnderzealotMeleeGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new UnderzealotCaptureSacrificeGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new UnderzealotProcessionGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new UnderzealotBreakLightGoal(this, 32));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 100));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{UnderzealotEntity.class, WatcherEntity.class, ForsakenEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new MobTargetClosePlayers((Mob)this, 12.0f){

            @Override
            public boolean m_8036_() {
                return !UnderzealotEntity.this.isPraying() && !UnderzealotEntity.this.isCarrying() && super.m_8036_();
            }
        });
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BURIED, (Object)false);
        this.f_19804_.m_135372_(CARRYING, (Object)false);
        this.f_19804_.m_135372_(PRAYING, (Object)false);
        this.f_19804_.m_135372_(SACRIFICE_POS, Optional.empty());
        this.f_19804_.m_135372_(PARTICLE_POS, Optional.empty());
        this.f_19804_.m_135372_(WORSHIP_TIME, (Object)0);
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 8.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.isBuried() || this.isDiggingInProgress()) {
            vec3d = Vec3.f_82478_;
        }
        super.m_7023_(vec3d);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigatorNoSpin((Mob)this, level);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevBuriedProgress = this.buriedProgress;
        this.prevCarryingProgress = this.carryingProgress;
        this.prevPrayingProgress = this.prayingProgress;
        if (!this.m_21525_() && (this.buriedProgress == 0.0f && this.isBuried() || this.buriedProgress == 20.0f && !this.isBuried())) {
            this.m_216990_((SoundEvent)ACSoundRegistry.UNDERZEALOT_DIG.get());
        }
        if (this.isBuried() && this.buriedProgress < 20.0f) {
            this.buriedProgress = Math.min(20.0f, this.buriedProgress + 1.5f);
        }
        if (!this.isBuried() && this.buriedProgress > 0.0f) {
            this.buriedProgress = Math.max(0.0f, this.buriedProgress - 1.5f);
        }
        if (this.isCarrying() && this.carryingProgress < 5.0f) {
            this.carryingProgress += 1.0f;
        }
        if (!this.isCarrying() && this.carryingProgress > 0.0f) {
            this.carryingProgress -= 1.0f;
        }
        if (this.isPraying() && this.prayingProgress < 5.0f) {
            this.prayingProgress += 1.0f;
        }
        if (!this.isPraying() && this.prayingProgress > 0.0f) {
            this.prayingProgress -= 1.0f;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isCarrying() && this.isPackFollower()) {
                for (Entity passenger : this.m_20197_()) {
                    passenger.m_8127_();
                }
            }
            this.setCarrying(!this.m_20197_().isEmpty());
            if (this.isBuried() && this.buriedProgress >= 20.0f) {
                if (this.reemergeTime-- < 0) {
                    this.m_6027_((float)this.remergePos.m_123341_() + 0.5f, this.remergePos.m_123342_(), (float)this.remergePos.m_123343_() + 0.5f);
                    this.idleBuryIn = 400 + this.f_19796_.m_188503_(800);
                    this.reemergeTime = 0;
                    this.setBuried(false);
                }
                Vec3 centerOf = Vec3.m_82539_((Vec3i)this.m_20183_()).m_82546_(this.m_20182_());
                this.m_20184_().m_82520_(centerOf.f_82479_ * (double)0.1f, 0.0, centerOf.f_82481_ * (double)0.1f);
            } else if (this.digsIdle() && this.idleBuryIn-- < 0 && this.m_20096_()) {
                this.setBuried(true);
                this.idleBuryIn = 0;
                this.reemergeAt(this.findReemergePos(this.m_20183_(), 10), 40 + this.f_19796_.m_188503_(60));
            }
            if (this.isDiggingInProgress()) {
                this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            }
        } else if (this.isDiggingInProgress()) {
            BlockState stateOn = this.m_20075_();
            if (stateOn.m_280296_()) {
                for (int i = 0; i < 3; ++i) {
                    this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, stateOn), true, this.m_20208_(0.8f), this.m_20186_(), this.m_20262_(0.8f), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() + 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f));
                }
            }
            if (this.isBuried()) {
                this.m_146867_();
            }
        }
        if (this.cloudCooldown > 0) {
            --this.cloudCooldown;
        }
        if (this.sacrificeCooldown > 0) {
            --this.sacrificeCooldown;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void m_7822_(byte b) {
        if (b == 61) {
            Vec3 eye = this.m_146892_();
            Vec3 leftHand = eye.m_82549_(new Vec3((double)0.8f, 0.0, 0.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180)));
            Vec3 rightHand = eye.m_82549_(new Vec3((double)-0.8f, 0.0, 0.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180)));
            Vec3 target = this.getParticlePos() == null ? this.m_20182_().m_82520_(0.0, 4.0, 0.0) : Vec3.m_82512_((Vec3i)this.getParticlePos());
            this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.UNDERZEALOT_MAGIC.get(), leftHand.f_82479_, leftHand.f_82480_, leftHand.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
            this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.UNDERZEALOT_MAGIC.get(), rightHand.f_82479_, rightHand.f_82480_, rightHand.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
        } else if (b == 62) {
            Vec3 particleAt = this.getParticlePos() == null ? this.m_20182_().m_82520_(0.0, 4.0, 0.0) : Vec3.m_82512_((Vec3i)this.getParticlePos());
            int carryingId = -1;
            if (this.m_20160_()) {
                carryingId = this.m_146895_() == null ? -1 : this.m_146895_().m_19879_();
            }
            this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.VOID_BEING_CLOUD.get(), particleAt.f_82479_, particleAt.f_82480_, particleAt.f_82481_, 1.0, (double)carryingId, (double)(5 + this.f_19796_.m_188503_(4)));
        } else if (b == 77) {
            if (this.m_6084_()) {
                AlexsCaves.PROXY.playWorldSound(this, (byte)5);
            }
        } else {
            super.m_7822_(b);
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        AlexsCaves.PROXY.clearSoundCacheFor((Entity)this);
        super.m_142687_(removalReason);
    }

    public BlockPos findReemergePos(BlockPos origin, int range) {
        for (int i = 0; i < 15; ++i) {
            BlockPos blockPos = origin.m_7918_(this.m_217043_().m_188503_(range) - range / 2, this.m_217043_().m_188503_(range) - range / 2, this.m_217043_().m_188503_(range) - range / 2);
            while (!this.m_9236_().m_46859_(blockPos) && blockPos.m_123342_() < this.m_9236_().m_151558_()) {
                blockPos = blockPos.m_7494_();
            }
            while (this.m_9236_().m_46859_(blockPos.m_7495_()) && blockPos.m_123342_() > this.m_9236_().m_141937_()) {
                blockPos = blockPos.m_7495_();
            }
            if (this.m_9236_().m_46859_(blockPos.m_7495_()) || !(blockPos.m_123331_((Vec3i)origin) < (double)(range * range + 10))) continue;
            return blockPos;
        }
        return origin;
    }

    public void triggerIdleDigging() {
        this.idleBuryIn = 0;
    }

    public boolean digsIdle() {
        LivingEntity target = this.m_5448_();
        return !this.isCarrying() && !this.isPackFollower() && !this.isPraying() && this.getAnimation() == NO_ANIMATION && (target == null || !target.m_6084_());
    }

    public void reemergeAt(BlockPos pos, int time) {
        this.remergePos = pos;
        this.reemergeTime = time;
    }

    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        super.m_19956_(entity, moveFunction);
        entity.m_146922_(this.f_20883_);
        entity.m_5616_(this.f_20883_);
        entity.m_5618_(this.f_20883_);
    }

    public boolean isBuried() {
        return (Boolean)this.f_19804_.m_135370_(BURIED);
    }

    public void setBuried(boolean bool) {
        this.f_19804_.m_135381_(BURIED, (Object)bool);
    }

    public boolean isCarrying() {
        return (Boolean)this.f_19804_.m_135370_(CARRYING);
    }

    public BlockPos getLastSacrificePos() {
        return ((Optional)this.f_19804_.m_135370_(SACRIFICE_POS)).orElse(null);
    }

    public void setLastSacrificePos(BlockPos lastAltarPos) {
        this.f_19804_.m_135381_(SACRIFICE_POS, Optional.ofNullable(lastAltarPos));
    }

    public BlockPos getParticlePos() {
        return ((Optional)this.f_19804_.m_135370_(PARTICLE_POS)).orElse(null);
    }

    public void setParticlePos(BlockPos lastAltarPos) {
        this.f_19804_.m_135381_(PARTICLE_POS, Optional.ofNullable(lastAltarPos));
    }

    public void setCarrying(boolean bool) {
        this.f_19804_.m_135381_(CARRYING, (Object)bool);
    }

    public boolean isPraying() {
        return (Boolean)this.f_19804_.m_135370_(PRAYING);
    }

    public void setPraying(boolean bool) {
        this.f_19804_.m_135381_(PRAYING, (Object)bool);
    }

    public int getWorshipTime() {
        return (Integer)this.f_19804_.m_135370_(WORSHIP_TIME);
    }

    public void setWorshipTime(int worship) {
        this.f_19804_.m_135381_(WORSHIP_TIME, (Object)worship);
    }

    @Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    public float getBuriedProgress(float partialTick) {
        return this.m_21525_() ? 0.0f : (this.prevBuriedProgress + (this.buriedProgress - this.prevBuriedProgress) * partialTick) * 0.05f;
    }

    public float getCarryingProgress(float partialTick) {
        return (this.prevCarryingProgress + (this.carryingProgress - this.prevCarryingProgress) * partialTick) * 0.2f;
    }

    public float getPrayingProgress(float partialTick) {
        return (this.prevPrayingProgress + (this.prayingProgress - this.prevPrayingProgress) * partialTick) * 0.2f;
    }

    @Override
    public PackAnimal getPriorPackMember() {
        return this.priorPackMember;
    }

    @Override
    public PackAnimal getAfterPackMember() {
        return this.afterPackMember;
    }

    @Override
    public void setPriorPackMember(PackAnimal animal) {
        this.priorPackMember = (UnderzealotEntity)animal;
    }

    @Override
    public void setAfterPackMember(PackAnimal animal) {
        this.afterPackMember = (UnderzealotEntity)animal;
    }

    @Override
    public boolean isValidLeader(PackAnimal packLeader) {
        return ((UnderzealotEntity)packLeader).isCarrying() && !packLeader.isPackFollower() && ((LivingEntity)packLeader).m_6084_();
    }

    public boolean isDiggingInProgress() {
        return this.buriedProgress > 0.0f && this.buriedProgress < 20.0f;
    }

    public void m_7334_(Entity entity) {
        UnderzealotEntity underzealot;
        if (!(entity instanceof UnderzealotEntity && ((underzealot = (UnderzealotEntity)entity).isPraying() || this.isPraying()) || this.isBuried() || this.isDiggingInProgress())) {
            super.m_7334_(entity);
        }
    }

    public double m_6048_() {
        return this.m_20206_();
    }

    public boolean m_6087_() {
        return !this.isBuried();
    }

    public boolean m_6094_() {
        return !this.isBuried();
    }

    public boolean m_6673_(DamageSource damageSource) {
        return damageSource.m_276093_(DamageTypes.f_268612_) || super.m_6673_(damageSource);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK_0, ANIMATION_ATTACK_1, ANIMATION_BREAKTORCH};
    }

    public static boolean checkUnderzealotSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return UnderzealotEntity.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.NATURAL) {
            this.spawnReinforcements(worldIn);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private void spawnReinforcements(ServerLevelAccessor worldIn) {
        for (int i = 0; i < 3 + this.f_19796_.m_188503_(2); ++i) {
            UnderzealotEntity friend = (UnderzealotEntity)((EntityType)ACEntityRegistry.UNDERZEALOT.get()).m_20615_((Level)worldIn.m_6018_());
            friend.m_20359_((Entity)this);
            worldIn.m_7967_((Entity)friend);
        }
    }

    public boolean isSurroundedByPrayers() {
        PackAnimal leader = this.getPackLeader();
        int prayers = 0;
        while (leader.getAfterPackMember() != null) {
            UnderzealotEntity underzealot;
            if (!((leader = leader.getAfterPackMember()) instanceof UnderzealotEntity) || !(underzealot = (UnderzealotEntity)leader).isPraying()) continue;
            ++prayers;
        }
        return prayers >= 3;
    }

    public void m_7380_(CompoundTag compound) {
        BlockPos sacrificePos;
        super.m_7380_(compound);
        compound.m_128405_("SacrificeCooldown", this.sacrificeCooldown);
        compound.m_128379_("Buried", this.isBuried());
        if (this.remergePos != null) {
            compound.m_128405_("RX", this.remergePos.m_123341_());
            compound.m_128405_("RY", this.remergePos.m_123342_());
            compound.m_128405_("RZ", this.remergePos.m_123343_());
        }
        if ((sacrificePos = this.getLastSacrificePos()) != null) {
            compound.m_128405_("SX", sacrificePos.m_123341_());
            compound.m_128405_("SY", sacrificePos.m_123342_());
            compound.m_128405_("SZ", sacrificePos.m_123343_());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.sacrificeCooldown = compound.m_128451_("SacrificeCooldown");
        this.setBuried(compound.m_128471_("Buried"));
        if (compound.m_128441_("RX") && compound.m_128441_("RY") && compound.m_128441_("RZ")) {
            this.remergePos = new BlockPos(compound.m_128451_("RX"), compound.m_128451_("RY"), compound.m_128451_("RZ"));
        }
        if (compound.m_128441_("SX") && compound.m_128441_("SY") && compound.m_128441_("SZ")) {
            this.setLastSacrificePos(new BlockPos(compound.m_128451_("SX"), compound.m_128451_("SY"), compound.m_128451_("SZ")));
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        boolean prev = super.m_6469_(damageSource, f);
        if (prev && this.m_20160_() && this.m_217043_().m_188501_() < 0.65f) {
            this.m_20153_();
            return true;
        }
        return prev;
    }

    public boolean m_6097_() {
        return super.m_6097_() && !this.isBuried();
    }

    public void postSacrifice(UnderzealotSacrifice sacrifice) {
        this.m_5496_((SoundEvent)ACSoundRegistry.UNDERZEALOT_TRANSFORMATION.get(), 8.0f, 1.0f);
        this.sacrificeCooldown = 6000 + this.f_19796_.m_188503_(6000);
        float advancementRange = 64.0f;
        for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_((double)advancementRange))) {
            if (!(player.m_20270_((Entity)this) < advancementRange)) continue;
            ACAdvancementTriggerRegistry.UNDERZEALOT_SACRIFICE.triggerForEntity((Entity)player);
        }
    }

    protected SoundEvent m_7515_() {
        return this.isCarrying() || this.isPraying() || this.isBuried() ? super.m_7515_() : (SoundEvent)ACSoundRegistry.UNDERZEALOT_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.UNDERZEALOT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.UNDERZEALOT_DEATH.get();
    }

    public void m_6135_() {
        super.m_6135_();
    }
}

