/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.VerticalSwimmingMoveControl;
import com.github.alexmodguy.alexscaves.server.entity.item.MineGuardianAnchorEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.MineExplosion;
import com.github.alexmodguy.alexscaves.server.level.storage.ACWorldData;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class MineGuardianEntity
extends Monster {
    private float explodeProgress;
    private float prevExplodeProgress;
    private float scanProgress;
    private float prevScanProgress;
    private boolean clientSideTouchedGround;
    private int scanTime = 0;
    private int maxScanTime = 0;
    private int maxSleepTime = 200 + this.f_19796_.m_188503_(100);
    private int lastScanTime = 0;
    private int timeSinceHadTarget = 0;
    private static final EntityDataAccessor<Optional<UUID>> ANCHOR_UUID = SynchedEntityData.m_135353_(MineGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> ANCHOR_ID = SynchedEntityData.m_135353_(MineGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MAX_CHAIN_LENGTH = SynchedEntityData.m_135353_(MineGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> EXPLODING = SynchedEntityData.m_135353_(MineGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EYE_CLOSED = SynchedEntityData.m_135353_(MineGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SCANNING = SynchedEntityData.m_135353_(MineGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public MineGuardianEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new VerticalSwimmingMoveControl((Mob)this, 0.7f, 30.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANCHOR_UUID, Optional.empty());
        this.f_19804_.m_135372_(ANCHOR_ID, (Object)-1);
        this.f_19804_.m_135372_(MAX_CHAIN_LENGTH, (Object)8);
        this.f_19804_.m_135372_(EXPLODING, (Object)false);
        this.f_19804_.m_135372_(EYE_CLOSED, (Object)false);
        this.f_19804_.m_135372_(SCANNING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20072_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            Vec3 delta = this.m_20184_();
            this.m_6478_(MoverType.SELF, delta);
            this.m_20256_(delta.m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    @Nullable
    public UUID getAnchorUUID() {
        return ((Optional)this.f_19804_.m_135370_(ANCHOR_UUID)).orElse(null);
    }

    public void setAnchorUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(ANCHOR_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getAnchor() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getAnchorUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(ANCHOR_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    protected SoundEvent m_7515_() {
        return this.m_20072_() ? (SoundEvent)ACSoundRegistry.MINE_GUARDIAN_IDLE.get() : (SoundEvent)ACSoundRegistry.MINE_GUARDIAN_LAND_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return this.m_20072_() ? (SoundEvent)ACSoundRegistry.MINE_GUARDIAN_HURT.get() : (SoundEvent)ACSoundRegistry.MINE_GUARDIAN_LAND_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.m_20072_() ? (SoundEvent)ACSoundRegistry.MINE_GUARDIAN_DEATH.get() : (SoundEvent)ACSoundRegistry.MINE_GUARDIAN_LAND_DEATH.get();
    }

    public boolean isExploding() {
        return (Boolean)this.f_19804_.m_135370_(EXPLODING);
    }

    public void setExploding(boolean explode) {
        this.f_19804_.m_135381_(EXPLODING, (Object)explode);
    }

    public boolean isEyeClosed() {
        return (Boolean)this.f_19804_.m_135370_(EYE_CLOSED);
    }

    public void setEyeClosed(boolean eyeClosed) {
        this.f_19804_.m_135381_(EYE_CLOSED, (Object)eyeClosed);
    }

    public boolean isScanning() {
        return (Boolean)this.f_19804_.m_135370_(SCANNING);
    }

    public void setScanning(boolean scanning) {
        this.f_19804_.m_135381_(SCANNING, (Object)scanning);
    }

    public int getMaxChainLength() {
        return (Integer)this.f_19804_.m_135370_(MAX_CHAIN_LENGTH);
    }

    public void setMaxChainLength(int length) {
        this.f_19804_.m_135381_(MAX_CHAIN_LENGTH, (Object)length);
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevExplodeProgress = this.explodeProgress;
        this.prevScanProgress = this.scanProgress;
        if (this.isScanning() && this.scanProgress < 5.0f) {
            this.scanProgress += 1.0f;
        }
        if (!this.isScanning() && this.scanProgress > 0.0f) {
            this.scanProgress -= 1.0f;
        }
        if (this.isExploding() && this.explodeProgress < 10.0f) {
            this.explodeProgress += 0.5f;
        }
        if (!this.isExploding() && this.explodeProgress > 0.0f) {
            this.explodeProgress -= 0.5f;
        }
        if (this.isExploding()) {
            if (this.explodeProgress >= 10.0f) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                Explosion.BlockInteraction blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) ? (this.m_9236_().m_46469_().m_46207_(GameRules.f_254692_) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY) : Explosion.BlockInteraction.KEEP;
                MineExplosion explosion = new MineExplosion(this.m_9236_(), (Entity)this, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 5.0f, this.m_20072_(), blockinteraction);
                explosion.explode();
                explosion.finalizeExplosion(true);
            }
            this.m_20256_(this.m_20184_().m_82542_((double)0.3f, 1.0, (double)0.3f));
        }
        if (!this.m_9236_().f_46443_) {
            Entity entity = this.getAnchor();
            if (entity == null) {
                this.setMaxChainLength(7 + this.m_217043_().m_188503_(6));
                MineGuardianAnchorEntity created = new MineGuardianAnchorEntity(this);
                this.m_9236_().m_7967_((Entity)created);
                this.setAnchorUUID(created.m_20148_());
                this.f_19804_.m_135381_(ANCHOR_ID, (Object)created.m_19879_());
            } else if (entity instanceof MineGuardianAnchorEntity) {
                MineGuardianAnchorEntity anchorEntity = (MineGuardianAnchorEntity)entity;
                anchorEntity.linkWithGuardian((Entity)this);
            }
            if (this.m_20072_()) {
                this.m_20301_(300);
            } else if (this.m_20096_()) {
                this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.6f), (double)0.6f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.6f)));
                this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
                this.m_6853_(false);
                this.m_216990_((SoundEvent)ACSoundRegistry.MINE_GUARDIAN_FLOP.get());
                this.f_19812_ = true;
            }
            LivingEntity target = this.m_5448_();
            this.timeSinceHadTarget = target == null || !target.m_6084_() ? ++this.timeSinceHadTarget : 0;
            if (this.isScanning()) {
                this.setEyeClosed(false);
                if (this.scanTime < this.maxScanTime) {
                    if (this.scanTime % 20 == 0) {
                        this.m_216990_((SoundEvent)ACSoundRegistry.MINE_GUARDIAN_SCAN.get());
                    }
                    if (this.scanTime % 5 == 0 && this.scanProgress >= 5.0f) {
                        EntityHitResult entityHitResult;
                        Entity found = null;
                        BlockHitResult hitresult = this.m_9236_().m_45547_(new ClipContext(this.m_146892_(), this.m_146892_().m_82549_(this.m_20154_().m_82490_(8.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                        if (hitresult instanceof EntityHitResult && this.isValidTarget((entityHitResult = (EntityHitResult)hitresult).m_82443_())) {
                            Entity inSight = entityHitResult.m_82443_();
                            if (!inSight.equals((Object)this) && !inSight.m_7307_((Entity)this) && !this.m_7307_(inSight) && this.m_142582_(inSight)) {
                                found = inSight;
                            }
                        } else {
                            AABB around = new AABB(hitresult.m_82450_().m_82520_(-0.5, -0.5, -0.5), hitresult.m_82450_().m_82520_(0.5, 0.5, 0.5)).m_82400_(3.0);
                            for (Entity inSight : this.m_9236_().m_45976_(LivingEntity.class, around)) {
                                if (inSight.equals((Object)this) || inSight.m_7307_((Entity)this) || this.m_7307_(inSight) || !this.m_142582_(inSight) || (found != null || !this.isValidTarget(inSight)) && (found == null || !this.isValidTarget(inSight) || !(inSight.m_20270_((Entity)this) < found.m_20270_((Entity)this)))) continue;
                                found = inSight;
                            }
                        }
                        if (found instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)found;
                            this.m_6710_(living);
                            this.setScanning(false);
                        }
                    }
                    ++this.scanTime;
                } else {
                    this.scanTime = 0;
                    this.lastScanTime = this.f_19797_;
                    this.setScanning(false);
                }
            } else if (this.isEyeClosed()) {
                int j = this.f_19797_ - this.lastScanTime;
                if (this.timeSinceHadTarget == 0 || !this.m_20072_()) {
                    this.setEyeClosed(false);
                } else if (this.m_20072_() && (this.timeSinceHadTarget > this.maxSleepTime && j > 200 || this.f_20916_ > 0)) {
                    this.maxSleepTime = 200 + this.f_19796_.m_188503_(100);
                    this.setScanning(true);
                    this.scanTime = 0;
                    this.maxScanTime = 100 + this.f_19796_.m_188503_(100);
                }
            } else if (this.m_20072_() && this.timeSinceHadTarget > 100) {
                this.setEyeClosed(true);
            }
        } else {
            Vec3 vec3 = this.m_20184_();
            if (vec3.f_82480_ > 0.0 && this.clientSideTouchedGround && !this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getFlopSound(), this.m_5720_(), 1.0f, 1.0f, false);
            }
            this.clientSideTouchedGround = vec3.f_82480_ < 0.0 && this.m_9236_().m_46575_(this.m_20183_().m_7495_(), (Entity)this);
        }
    }

    private boolean isValidTarget(Entity entity) {
        Player player;
        return entity instanceof Player && this.m_6779_((LivingEntity)(player = (Player)entity));
    }

    public static boolean checkMineGuardianSpawnRules(EntityType entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        boolean flag;
        if (!level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        boolean bl = flag = level.m_46791_() != Difficulty.PEACEFUL && MineGuardianEntity.m_219009_((ServerLevelAccessor)level, (BlockPos)blockPos, (RandomSource)randomSource) && (mobSpawnType == MobSpawnType.SPAWNER || level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_));
        if (randomSource.m_188503_(10) == 0 && blockPos.m_123342_() < level.m_5736_() - 50 && flag) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            while (!level.m_6425_((BlockPos)pos).m_76178_() && pos.m_123342_() < level.m_5736_()) {
                pos.m_122184_(0, 1, 0);
            }
            int belowAirBy = pos.m_123342_() - blockPos.m_123342_();
            pos.m_122190_((Vec3i)blockPos);
            while (!level.m_6425_((BlockPos)pos).m_76178_() && pos.m_123342_() > level.m_141937_()) {
                pos.m_122184_(0, -1, 0);
            }
            BlockState groundState = level.m_8055_((BlockPos)pos);
            return belowAirBy > 15 && (groundState.m_60713_((Block)ACBlockRegistry.MUCK.get()) || groundState.m_60713_((Block)ACBlockRegistry.ABYSSMARINE.get()) || groundState.m_60713_(Blocks.f_152550_));
        }
        return false;
    }

    public float getScanProgress(float partialTick) {
        return (this.prevScanProgress + (this.scanProgress - this.prevScanProgress) * partialTick) * 0.2f;
    }

    public float getExplodeProgress(float partialTick) {
        return (this.prevExplodeProgress + (this.explodeProgress - this.prevExplodeProgress) * partialTick) * 0.1f;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12004_;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("AnchorUUID")) {
            this.setAnchorUUID(compound.m_128342_("AnchorUUID"));
        }
        this.setMaxChainLength(compound.m_128451_("MaxChainLength"));
        this.scanTime = compound.m_128451_("ScanTime");
        this.setEyeClosed(compound.m_128471_("EyeClosed"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getAnchorUUID() != null) {
            compound.m_128362_("AnchorUUID", this.getAnchorUUID());
        }
        compound.m_128405_("MaxChainLength", this.getMaxChainLength());
        compound.m_128379_("EyeClosed", this.isEyeClosed());
        compound.m_128405_("ScanTime", this.scanTime);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setEyeClosed(true);
        this.timeSinceHadTarget = 10;
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_6668_(DamageSource damageSource) {
        Entity entity;
        super.m_6668_(damageSource);
        if (!this.m_9236_().f_46443_ && (entity = damageSource.m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            ACWorldData worldData = ACWorldData.get(this.m_9236_());
            int relations = worldData.getDeepOneReputation(player.m_20148_());
            if (relations < 0) {
                worldData.setDeepOneReputation(player.m_20148_(), relations + this.f_19796_.m_188503_(3) + 1);
            }
        }
    }

    private class MeleeGoal
    extends Goal {
        private int timer = 0;

        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = MineGuardianEntity.this.m_5448_();
            return target != null;
        }

        public void m_8056_() {
            this.timer = 0;
        }

        public void m_8037_() {
            LivingEntity target = MineGuardianEntity.this.m_5448_();
            if (target != null) {
                ++this.timer;
                double dist = MineGuardianEntity.this.m_20270_((Entity)target);
                MineGuardianEntity.this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                if (dist > 2.0) {
                    if (MineGuardianEntity.this.m_20072_()) {
                        MineGuardianEntity.this.m_21573_().m_5624_((Entity)target, 1.6);
                    }
                } else {
                    MineGuardianEntity.this.setExploding(true);
                }
                if (this.timer > 300) {
                    MineGuardianEntity.this.lastScanTime = MineGuardianEntity.this.f_19797_;
                    MineGuardianEntity.this.timeSinceHadTarget = 5;
                    MineGuardianEntity.this.setEyeClosed(true);
                    MineGuardianEntity.this.m_6710_(null);
                    MineGuardianEntity.this.m_6703_(null);
                }
            }
        }
    }
}

