/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.living.HullbreakerEntity;
import com.github.alexmodguy.alexscaves.server.message.MultipartEntityMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class HullbreakerPartEntity
extends PartEntity<HullbreakerEntity> {
    private final Entity connectedTo;
    private EntityDimensions size;
    public float scale = 1.0f;

    public HullbreakerPartEntity(HullbreakerEntity parent, Entity connectedTo, float sizeXZ, float sizeY) {
        super((Entity)parent);
        this.f_19850_ = true;
        this.connectedTo = connectedTo;
        this.size = EntityDimensions.m_20398_((float)sizeXZ, (float)sizeY);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.size;
    }

    public boolean m_5825_() {
        return true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        HullbreakerEntity parent = (HullbreakerEntity)this.getParent();
        if (parent == null) {
            return InteractionResult.PASS;
        }
        this.m_216990_(SoundEvents.f_12018_);
        if (player.m_9236_().f_46443_) {
            AlexsCaves.sendMSGToServer(new MultipartEntityMessage(parent.m_19879_(), player.m_19879_(), 0, 0.0));
        }
        return parent.m_6096_(player, hand);
    }

    public boolean m_20223_(CompoundTag tag) {
        return false;
    }

    public boolean m_5829_() {
        HullbreakerEntity parent = (HullbreakerEntity)this.getParent();
        return parent != null && parent.m_5829_();
    }

    public boolean m_6087_() {
        HullbreakerEntity parent = (HullbreakerEntity)this.getParent();
        return parent != null && parent.m_6087_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity player;
        HullbreakerEntity parent = (HullbreakerEntity)this.getParent();
        if (!this.m_6673_(source) && parent != null && (player = source.m_7639_()) != null && player.m_9236_().f_46443_) {
            AlexsCaves.sendMSGToServer(new MultipartEntityMessage(parent.m_19879_(), player.m_19879_(), 1, amount));
        }
        return false;
    }

    public boolean m_7306_(Entity entityIn) {
        return this == entityIn || this.getParent() == entityIn;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        throw new UnsupportedOperationException();
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82377_(2.0, 0.5, 2.0);
    }

    public float calculateAnimationAngle(float partialTicks, boolean pitch) {
        HullbreakerEntity parent = (HullbreakerEntity)this.getParent();
        float parentRot = parent == null ? 0.0f : parent.f_20884_ + (parent.f_20883_ - parent.f_20884_) * partialTicks;
        Vec3 connection = this.connectedTo.m_20318_(partialTicks).m_82520_(0.0, (double)(this.connectedTo.m_20206_() * 0.5f), 0.0);
        Vec3 center = this.centeredPosition(partialTicks);
        Vec3 offset = connection.m_82546_(center).m_82541_();
        Vec3 back = center.m_82549_(offset.m_82490_((double)(-1.0f * this.m_20205_())));
        double d0 = connection.f_82479_ - back.f_82479_;
        double d1 = connection.f_82480_ - back.f_82480_;
        double d2 = connection.f_82481_ - back.f_82481_;
        if (pitch) {
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            return Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 180.0 / 3.1415927410125732)))) * 0.35f;
        }
        return (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f - parentRot;
    }

    public boolean m_142391_() {
        return false;
    }

    public void setPosCenteredY(Vec3 pos) {
        this.m_6034_(pos.f_82479_, pos.f_82480_ - (double)(this.m_20206_() * 0.5f), pos.f_82481_);
    }

    public Vec3 centeredPosition() {
        return this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() * 0.5f), 0.0);
    }

    public Vec3 centeredPosition(float partialTicks) {
        return this.m_20318_(partialTicks).m_82520_(0.0, (double)(this.m_20206_() * 0.5f), 0.0);
    }
}

